<?php
define("PATH_TOKEN_TICKET", ""); // access_token.php和jsapi_ticket.php文件所处的绝对路径。例如：/server/www/cache。结尾没有/。
/*
* 如何获取绝对路径？
* echo dirname(__FILE__);
*/
class JSSDK
{
  private $appId;
  private $appSecret;

  public function __construct($appId, $appSecret)
  {
    $this->appId = $appId;
    $this->appSecret = $appSecret;
  }

  public function getSignPackage()
  {
    $jsapiTicket = $this->getJsApiTicket();
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
    $url = "$protocol$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
    $timestamp = time();
    $nonceStr = $this->createNonceStr();
    $string = "jsapi_ticket=$jsapiTicket&noncestr=$nonceStr&timestamp=$timestamp&url=$url";
    $signature = sha1($string);
    return array(
      "appId" => $this->appId,
      "nonceStr" => $nonceStr,
      "timestamp" => $timestamp,
      "url" => $url,
      "signature" => $signature,
      "rawString" => $string
    );
  }

  private function createNonceStr($length = 16)
  {
    $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    $str = "";
    for ($i = 0; $i < $length; $i++) {
      $str .= substr($chars, mt_rand(0, strlen($chars) - 1), 1);
    }
    return $str;
  }

  private function getJsApiTicket()
  {
    $filePath = PATH_TOKEN_TICKET . "/jsapi_ticket.php";
    if (!file_exists($filePath)) {
      $data = (object) [
        'expire_time' => 0,
        'jsapi_ticket' => ''
      ];
    } else {
      $fileContent = $this->get_php_file($filePath);
      $data = json_decode($fileContent);
      if (!$data || !isset($data->expire_time) || !isset($data->jsapi_ticket)) {
        $data = (object) [
          'expire_time' => 0,
          'jsapi_ticket' => ''
        ];
      }
    }
    if ($data->expire_time < time()) {
      $accessToken = $this->getAccessToken();
      $url = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?type=jsapi&access_token=$accessToken";
      $res = json_decode($this->httpGet($url));
      $ticket = $res->ticket ?? null;
      if ($ticket) {
        $data->expire_time = time() + 7000;
        $data->jsapi_ticket = $ticket;
        $this->set_php_file(PATH_TOKEN_TICKET . "/jsapi_ticket.php", json_encode($data));
      } else {
        $this->logError("Failed to retrieve jsapi_ticket from WeChat API.");
        return null;
      }
    } else {
      $ticket = $data->jsapi_ticket;
    }
    return $ticket;
  }

  private function getAccessToken()
  {
    $filePath = PATH_TOKEN_TICKET . "/access_token.php";
    if (!file_exists($filePath)) {
      $data = (object) [
        'expire_time' => 0,
        'access_token' => ''
      ];
    } else {
      $fileContent = $this->get_php_file($filePath);
      $data = json_decode($fileContent);
      if (!$data || !isset($data->expire_time) || !isset($data->access_token)) {
        $data = (object) [
          'expire_time' => 0,
          'access_token' => ''
        ];
      }
    }
    if ($data->expire_time < time()) {
      $url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=$this->appId&secret=$this->appSecret";
      $res = json_decode($this->httpGet($url));
      $access_token = $res->access_token ?? null;
      if ($access_token) {
        $data->expire_time = time() + 7000;
        $data->access_token = $access_token;
        $this->set_php_file(PATH_TOKEN_TICKET . "/access_token.php", json_encode($data));
      } else {
        $this->logError("Failed to retrieve access_token from WeChat API.");
        return null;
      }
    } else {
      $access_token = $data->access_token;
    }
    return $access_token;
  }

  private function httpGet($url)
  {
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_TIMEOUT, 500);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, true);
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
    curl_setopt($curl, CURLOPT_URL, $url);
    $res = curl_exec($curl);
    curl_close($curl);
    return $res;
  }

  private function get_php_file($filename)
  {
    return trim(substr(file_get_contents($filename), 15));
  }

  private function set_php_file($filename, $content)
  {
    $fp = fopen($filename, "w");
    fwrite($fp, "<?php exit();?>" . $content);
    fclose($fp);
  }

  private function logError($message)
  {
    $directory = __DIR__ . '/logs';
    if (!is_dir($directory)) {
      mkdir($directory, 0755, true);
    }
    $logFile = $directory . '/' . date('Y-m') . '.log';
    $timestamp = date('Y-m-d H:i:s');
    file_put_contents($logFile, "[$timestamp] $message" . PHP_EOL, FILE_APPEND);
  }
}
