<?php
if (!defined('ABSPATH')) {
    die('Access Denied!');
}
if (!class_exists("ope_form_menu_page")) {
    class ope_form_menu_page
    {
        public function add_menu_page()
        {
            add_menu_page(
                'OPE Form ' . __('Config', 'ope-form-pack'),
                'OPE Form ' . __('Config', 'ope-form-pack'),
                'manage_options',
                'ope_form_admin_settings',
                array($this, 'ope_form_admin'),
                get_template_directory_uri() . '/pack/contact-form/admin/assets/img/ope-form.png',
                500
            );
        }
        public function ope_form_admin()
        {
            require get_template_directory() . '/pack/contact-form/admin/ope_form_admin.php';
        }
        public function add_page()
        {
            add_action('admin_menu', array($this, 'add_menu_page'));
        }
        public function ope_form_enqueue()
        {
            wp_enqueue_style('ope-form-admin-main', get_template_directory_uri() . '/pack/contact-form/admin/assets/css/ope_form_panel.css', array(), crc32(date("YmdH")), 'all');
            wp_enqueue_script('ope-form-admin-script', get_template_directory_uri() . '/pack/contact-form/admin/assets/js/ope_form_panel.js', array(), crc32(date("YmdH")), true);
            wp_localize_script('ope-form-admin-script', 'ope_form_admin_object', array(
                'ajaxurl' => admin_url('admin-ajax.php'),
                'form_nonce_admin' => wp_create_nonce('ope_form_nonce_admin_panel'),
                'text_failed' => __('Failed! Please try again.', 'ope-form-pack'),
                'text_success' => __('Success!', 'ope-form-pack'),
                'text_send_successfully' => __('Mail sent successfully, please check the mailbox.', 'ope-form-pack'),
                'text_error_occurred' => __('An error occurred while sending the email. Please try again later.', 'ope-form-pack'),
                'text_enter_valid_email' => __('Please enter a valid Email address.', 'ope-form-pack'),
                'text_save_sure' => __('Are you sure you want to proceed with saving?', 'ope-form-pack'),
                'text_save_empty_sure' => __('Are you certain you want to reset the settings?', 'ope-form-pack'),
                'text_cannot_recovered' => __('Data cannot be recovered. Do you want to continue?', 'ope-form-pack')
            ));
        }
        public function enqueue()
        {
            add_action('admin_enqueue_scripts', array($this, 'ope_form_enqueue'));
        }

        public function getRandomString($n)
        {
            $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
            $randomString = '';

            for ($i = 0; $i < $n; $i++) {
                $index = rand(0, strlen($characters) - 1);
                $randomString .= $characters[$index];
            }

            return $randomString;
        }
    }
}
$ope_form_menu_page = new ope_form_menu_page();
$ope_form_menu_page->add_page();
$ope_form_menu_page->enqueue();

add_action('wp_ajax_safeOPEFORMPANELDATA', 'safeOPEFORMPANELDATA_function');
function safeOPEFORMPANELDATA_function()
{
    if (!current_user_can('administrator')) {
        wp_send_json(array('status' => 'failed', 'message' => 'Permission Denied'));
        die();
    }
    $nonce = check_ajax_referer('ope_form_nonce_admin_panel', 's');
    if ($nonce === false) {
        wp_send_json(array('status' => 'failed', 'message' => 'Auth Failed'));
        die();
    }
    $encrypted = opeEncrypDecrypt::encrypt($_POST['data']);
    $folderName = json_decode(stripslashes($_POST['folder']));
    if (!empty($folderName)) {
        if (!is_dir(ABSPATH . $folderName)) {
            mkdir(ABSPATH . $folderName, 0755);
        }
    }
    update_option('ope_form_panel_config', $encrypted);
    update_option('ope_form_panel_config_status', 'configured');
    wp_send_json(array('status' => 'success', 'message' => $folderName));
    die();
}

add_action('wp_ajax_emptyOPEFORMPANELDATA', 'emptyOPEFORMPANELDATA_function');
function emptyOPEFORMPANELDATA_function()
{
    if (!current_user_can('administrator')) {
        wp_send_json(array('status' => 'failed', 'message' => 'Permission Denied'));
        die();
    }
    $nonce = check_ajax_referer('ope_form_nonce_admin_panel', 's');
    if ($nonce === false) {
        wp_send_json(array('status' => 'failed', 'message' => ''));
        die();
    }
    delete_option('ope_form_panel_config');
    delete_option('ope_form_panel_config_status');
    wp_send_json(array('status' => 'success', 'message' => ''));
    die();
}

add_action('wp_ajax_sendTestEmail', 'sendTestEmail_function');
function sendTestEmail_function()
{
    if (!current_user_can('administrator')) {
        wp_send_json(array('status' => 'failed', 'message' => 'Permission Denied'));
        die();
    }
    $nonce = check_ajax_referer('ope_form_nonce_admin_panel', 's');
    if ($nonce === false) {
        wp_send_json(array('status' => 'failed', 'message' => ''));
        die();
    }
    $email = $_POST['email'];
    if (empty($email)) {
        wp_send_json(array('status' => 'failed', 'message' => 'Parameter Required!'));
        die();
    }
    global $ope_form_panel_config;
    $email = json_decode(stripslashes($email));
    $receiver = $email;
    $attachments = array(__DIR__ . '/assets/test/have-a-nice-day.pdf', __DIR__ . '/assets/test/have-a-nice-day.png');
    $message = 'This email is a test email with two attachments. From the OPE Form module.';
    $subject = 'Message from ' . get_option('blogname');
    $headers = array('Content-Type: text/html; charset=UTF-8', 'From: OPEForm Testing Center <' . $ope_form_panel_config->smtp_name . '>');
    $status = wp_mail($receiver, $subject, $message, $headers, $attachments);
    if ($status == false) {
        wp_send_json(array('status' => 'failed', 'message' => ''));
    } else {
        wp_send_json(array('status' => 'success', 'message' => ''));
    }
    die();
}