(function ($) {
	function switchTabs() {
		let $hash = window.location.hash;
		let $tab = jQuery('.ope-form-panel [data-id="' + $hash.replace("#", "") + '"]');
		if ($tab.length > 0) {
			$tab.addClass("current").siblings().removeClass("current");
			$('.ope-form-panel [data-content="' + $hash.replace("#", "") + '"]')
				.addClass("current")
				.siblings()
				.removeClass("current");
			$(".ope-form-panel").addClass("show");
		} else {
			$(".ope-form-panel").addClass("show");
		}
		if ($('.ope-form-panel [data-content="test"]').hasClass("current")) {
			$(".ope-form-panel-btn").addClass("hide");
		} else {
			$(".ope-form-panel-btn").removeClass("hide");
		}
		jQuery(".ope-form-panel [data-id]").on("click", function () {
			let $this = $(this);
			let $target = $this.data("id");
			window.location.hash = $target;
			$this.addClass("current").siblings().removeClass("current");
			$('.ope-form-panel [data-content="' + $target + '"]')
				.addClass("current")
				.siblings()
				.removeClass("current");
			if ($('.ope-form-panel [data-content="test"]').hasClass("current")) {
				$(".ope-form-panel-btn").addClass("hide");
			} else {
				$(".ope-form-panel-btn").removeClass("hide");
			}
		});
	}
	async function emptyOPEFORMPanelConfiguration($btn) {
		let url = ope_form_admin_object.ajaxurl,
			secureNonce = ope_form_admin_object.form_nonce_admin;

		let data = {
			s: secureNonce,
			action: "emptyOPEFORMPANELDATA",
		};
		const response = await fetch(url, {
			method: "POST",
			mode: "same-origin",
			cache: "no-cache",
			redirect: "follow",
			referrerPolicy: "same-origin",
			headers: {
				"Content-Type": "application/x-www-form-urlencoded",
				"Cache-Control": "no-cache",
			},
			credentials: "same-origin",
			body: new URLSearchParams(data),
		});
		const jsonData = await response.json();
		if (jsonData) {
			if (jsonData.status == "success") {
				alert(ope_form_admin_object.text_success);
				location.reload();
			} else {
				alert(ope_form_admin_object.text_failed);
			}
			$btn.removeClass("hold");
		}
	}
	async function safeOPEFORMPanelConfiguration($btn) {
		let url = ope_form_admin_object.ajaxurl,
			secureNonce = ope_form_admin_object.form_nonce_admin;
		let $config = {
			recipient_administrator_email: jQuery("#recipient_administrator_email")
				.val()
				.trim(),
			recipient_administrator_email_cc: jQuery("#recipient_administrator_email_cc")
				.val()
				.trim(),
			email_from_address: jQuery("#email_from_address").val().trim(),
			email_from_name: jQuery("#email_from_name").val().trim(),
			email_format: jQuery("#email_format").val().trim(),
			auto_reply: jQuery("#auto_reply").val().trim(),
			fields_check: jQuery("#fields_check").val().trim(),
			validate_code: jQuery("#validate_code").val().trim(),
			store_mail_in_db: jQuery("#store_mail_in_db").val().trim(),
			post_type_name: jQuery("#post_type_name").val().trim(),
			post_type_category: jQuery("#post_type_category").val().trim(),
			admin_email_subject: jQuery("#admin_email_subject").val().trim(),
			auto_reply_email_subject: jQuery("#auto_reply_email_subject")
				.val()
				.trim(),
			auto_reply_email_body_top: jQuery("#auto_reply_email_body_top")
				.val()
				.trim(),
			auto_reply_email_body_bottom: jQuery("#auto_reply_email_body_bottom")
				.val()
				.trim(),
			confirm_page_top: jQuery("#confirm_page_top").val().trim(),
			thanks_page_text: jQuery("#thanks_page_text").val().trim(),
			button_next: jQuery("#button_next").val().trim(),
			button_prev: jQuery("#button_prev").val().trim(),
			button_send: jQuery("#button_send").val().trim(),
			required_item: jQuery("#required_item").val().trim(),
			required_item_other: jQuery("#required_item_other").val().trim(),
			error: jQuery("#error").val().trim(),
			invalid_email: jQuery("#invalid_email").val().trim(),
			invalid_phone: jQuery("#invalid_phone").val().trim(),
			email_not_matched: jQuery("#email_not_matched").val().trim(),
			validate_code_not_mateched: jQuery("#validate_code_not_mateched")
				.val()
				.trim(),
			illegal_string: jQuery("#illegal_string").val().trim(),
			send_failed: jQuery("#send_failed").val().trim(),
			file_too_large: jQuery("#file_too_large").val().trim(),
			file_type_error: jQuery("#file_type_error").val().trim(),
			auth_failed: jQuery("#auth_failed").val().trim(),
			file_upload_text: jQuery("#file_upload_text").val().trim(),
			return: jQuery("#return").val().trim(),
			select_image_and_crop: jQuery("#select_image_and_crop").val().trim(),
			image_crop: jQuery("#image_crop").val().trim(),
			cancel_crop: jQuery("#cancel_crop").val().trim(),
			image_type_error: jQuery("#image_type_error").val().trim(),
			image_too_small: jQuery("#image_too_small").val().trim(),
			image_too_large: jQuery("#image_too_large").val().trim(),
			image_upload: jQuery("#image_upload").val().trim(),
			smtp_support: jQuery("#smtp_support").val().trim(),
			smtp_host: jQuery("#smtp_host").val().trim(),
			smtp_name: jQuery("#smtp_name").val().trim(),
			smtp_pw: jQuery("#smtp_pw").val().trim(),
			smtp_port: jQuery("#smtp_port").val().trim(),
			smtp_secure_type: jQuery("#smtp_secure_type").val().trim(),
			save_file_to_server: jQuery("#save_file_to_server").val().trim(),
			upload_max_size: jQuery("#upload_max_size").val().trim(),
			image_crop_width: jQuery("#image_crop_width").val().trim(),
			image_crop_height: jQuery("#image_crop_height").val().trim(),
			image_width: jQuery("#image_width").val().trim(),
			image_height: jQuery("#image_height").val().trim(),
			automatice_return: jQuery("#automatice_return").val().trim(),
			back_to_url: jQuery("#back_to_url").val().trim(),
			jp_address_auto_fill: jQuery("#jp_address_auto_fill").val().trim(),
			include_debug_info_in_admin_email: jQuery("#include_debug_info_in_admin_email").val().trim(),
			name_format: jQuery("#name_format").val().trim(),
			timezone: jQuery("#timezone").val().trim(),
			waiting_time: jQuery("#waiting_time").val().trim(),
			file_upload_folder_name: jQuery("#file_upload_folder_name").val().trim(),
			remove_attachments_when_delete_email: jQuery(
				"#remove_attachments_when_delete_email"
			)
				.val()
				.trim(),
			google_recaptcha_v3_site_key: jQuery("#google_recaptcha_v3_site_key").val().trim(),
			google_recaptcha_v3_secret_key: jQuery("#google_recaptcha_v3_secret_key").val().trim(),
			google_recaptcha_v3: jQuery("#google_recaptcha_v3").val().trim(),
			google_recaptcha_v3_badge: jQuery("#google_recaptcha_v3_badge").val().trim(),
		};
		let data = {
			s: secureNonce,
			action: "safeOPEFORMPANELDATA",
			data: JSON.stringify($config),
			folder: JSON.stringify(jQuery("#file_upload_folder_name").val().trim())
		};
		const response = await fetch(url, {
			method: "POST",
			mode: "same-origin",
			cache: "no-cache",
			redirect: "follow",
			referrerPolicy: "same-origin",
			headers: {
				"Content-Type": "application/x-www-form-urlencoded",
				"Cache-Control": "no-cache",
			},
			credentials: "same-origin",
			body: new URLSearchParams(data),
		});
		const jsonData = await response.json();
		if (jsonData) {
			if (jsonData.status == "success") {
				alert(ope_form_admin_object.text_success);
				location.reload();
			} else {
				alert(ope_form_admin_object.text_failed);
			}
			$btn.removeClass("hold");
		}
	}

	function safePanelSettings() {
		jQuery(".ope-form-panel #ope_form_panel_save").on("click", function () {
			let $this = $(this);
			$confirm = confirm(ope_form_admin_object.text_save_sure);
			if ($confirm === true) {
				$this.addClass("hold");
				safeOPEFORMPanelConfiguration($this);
			}
		});
		jQuery(".ope-form-panel #ope_form_panel_empty").on("click", function () {
			let $this = $(this);
			$confirm = confirm(ope_form_admin_object.text_save_empty_sure);
			if ($confirm === true) {
				$confirm = confirm(ope_form_admin_object.text_cannot_recovered);
				if ($confirm === true) {
					$this.addClass("hold");
					emptyOPEFORMPanelConfiguration($this);
				}
			}
		});
		jQuery(".ope-form-panel select").on("change", function () {
			if ($(this).val() == "on") {
				$(this).attr("data-sub", "active");
			} else {
				$(this).removeAttr("data-sub");
			}
		});
	}

	async function ajaxSendTestEmail($email) {
		let url = ope_form_admin_object.ajaxurl,
			secureNonce = ope_form_admin_object.form_nonce_admin;
		let data = {
			s: secureNonce,
			action: "sendTestEmail",
			email: JSON.stringify($email)
		};

		// Timeout function
		const timeout = new Promise((_, reject) =>
			setTimeout(() => reject(new Error('Request timed out')), 15000)
		);

		try {
			const response = await Promise.race([
				fetch(url, {
					method: "POST",
					mode: "same-origin",
					cache: "no-cache",
					redirect: "follow",
					referrerPolicy: "same-origin",
					headers: {
						"Content-Type": "application/x-www-form-urlencoded",
						"Cache-Control": "no-cache",
					},
					credentials: "same-origin",
					body: new URLSearchParams(data),
				}),
				timeout // Race against timeout
			]);

			// Check if the response is OK (status 200)
			if (!response.ok) {
				throw new Error(`HTTP error! status: ${response.status}`);
			}

			const jsonData = await response.json();

			console.log(jsonData);

			// Check if the response is valid and has a status
			if (jsonData) {
				if (jsonData.status === "success") {
					alert(ope_form_admin_object.text_send_successfully);
					location.reload();
				} else {
					alert(ope_form_admin_object.text_failed);
				}
			} else {
				throw new Error("Invalid JSON response.");
			}
		} catch (error) {
			// Handle errors such as network issues, timeout, or unexpected responses
			console.error("Error sending test email:", error);
			alert(ope_form_admin_object.text_error_occurred);
		} finally {
			// Ensure the panel button is always reset
			$(".ope-form-panel #test-send").removeClass("hold");
		}
	}



	function testSendEmail() {
		$(".ope-form-panel #test-send").off().on("click", function () {
			let $email = $("#test_email").val();
			$email = typeof $email === "string" ? $email.trim() : '';
			if (!$email) {
				alert(ope_form_admin_object.text_enter_valid_email);
			} else {
				$(this).addClass("hold");
				ajaxSendTestEmail($email);
			}
		});
	}
	$(function () {
		switchTabs();
		safePanelSettings();
		testSendEmail();
	});
})(jQuery);
