<?php
if (!defined('ABSPATH')) {
    die('Access Denied!');
}
global $ope_form_menu_page;
?>
<div class="item">
    <div class="title"><?php echo __('File upload folder name', 'ope-form-pack'); ?></div>
    <div class="control">
        <input type="text" id="file_upload_folder_name"
            value="<?php echo @$ope_form_panel_config->file_upload_folder_name ? @$ope_form_panel_config->file_upload_folder_name : ('ope_form_files_' . $ope_form_menu_page->getRandomString(16)) ?>">
    </div>
</div>
<div class="item">
    <div class="title"><?php echo __('Remove attachments when delete email', 'ope-form-pack'); ?></div>
    <div class="control">
        <select class="no-width" id="remove_attachments_when_delete_email"
            data-sub="<?php echo @$ope_form_panel_config->remove_attachments_when_delete_email == 'on' ? "active" : ""; ?>">
            <option value="off" <?php selected('off', @$ope_form_panel_config->remove_attachments_when_delete_email); ?>>
                <?php echo __('OFF', 'ope-form-pack'); ?>
            </option>
            <option value="on" <?php selected('on', @$ope_form_panel_config->remove_attachments_when_delete_email); ?>>
                <?php echo __('ON', 'ope-form-pack'); ?>
            </option>
        </select>
    </div>
</div>
<h3><?php echo __('File upload', 'ope-form-pack'); ?></h3>
<div class="item">
    <div class="title"><?php echo __('Save files to server', 'ope-form-pack'); ?></div>
    <div class="control"><select class="no-width" id="save_file_to_server"
            data-sub="<?php echo @$ope_form_panel_config->save_file_to_server == 'on' ? "active" : ""; ?>">
            <option value="off" <?php selected('off', @$ope_form_panel_config->save_file_to_server); ?>>
                <?php echo __('OFF', 'ope-form-pack'); ?>
            </option>
            <option value="on" <?php selected('on', @$ope_form_panel_config->save_file_to_server); ?>>
                <?php echo __('ON', 'ope-form-pack'); ?>
            </option>
        </select>
    </div>
</div>
<div class="item">
    <div class="title"><?php echo __('Upload MAX size', 'ope-form-pack'); ?></div>
    <div class="control"><input type="number" step="100" min="0"
            max="<?php echo @$ope_form_panel_config->upload_max_size ? @$ope_form_panel_config->upload_max_size : 10; ?>"
            id="upload_max_size"
            value="<?php echo @$ope_form_panel_config->upload_max_size ? @$ope_form_panel_config->upload_max_size : 10; ?>">&nbsp;(MB)
    </div>
    <div class="note"><?php echo __('Server set upload size:', 'ope-form-pack'); ?>
        <?php
        $opeFormClass = new opeFormClass();
        $max_upload_size = $opeFormClass->max_file_upload_size();
        $current_max_upload_size_server = round($max_upload_size / 1024 / 1024, 2);
        echo $current_max_upload_size_server . 'MB';
        ?>
    </div>
</div>
<h3><?php echo __('Image upload and crop', 'ope-form-pack'); ?></h3>
<div class="item">
    <div class="title"><?php echo __('Image crop width', 'ope-form-pack'); ?></div>
    <div class="control">
        <input type="number" step="100" min="0" max="8000" id="image_crop_width"
            value="<?php echo @$ope_form_panel_config->image_crop_width ? @$ope_form_panel_config->image_crop_width : 1200; ?>">
    </div>
</div>
<div class="item">
    <div class="title"><?php echo __('Image crop height', 'ope-form-pack'); ?></div>
    <div class="control">
        <input type="number" step="100" min="0" max="8000" id="image_crop_height"
            value="<?php echo @$ope_form_panel_config->image_crop_height ? @$ope_form_panel_config->image_crop_height : 1200; ?>">
    </div>
</div>
<div class="item">
    <div class="title"><?php echo __('Source image width', 'ope-form-pack'); ?></div>
    <div class="control">
        <input type="number" step="100" min="0" max="8000" id="image_width"
            value="<?php echo @$ope_form_panel_config->image_width ? @$ope_form_panel_config->image_width : 8000; ?>">
    </div>
</div>
<div class="item">
    <div class="title"><?php echo __('Source image height', 'ope-form-pack'); ?></div>
    <div class="control">
        <input type="number" step="100" min="0" max="8000" id="image_height"
            value="<?php echo @$ope_form_panel_config->image_height ? @$ope_form_panel_config->image_height : 8000; ?>">
    </div>
</div>