<?php
if (!defined('ABSPATH')) {
    die('Access Denied!');
}
global $ope_form_panel_config;
global $ope_form_panel_config_status;
?>
<div class="ope-form-panel">
    <h2><?php echo __('OPE Form Configuration', 'ope-form-pack'); ?><em>V2</em></h2>
    <?php
    if (empty($ope_form_panel_config_status)) {
        ?>
        <div class="ope_form_should_config">
            <?php echo __('Currently there is no configuration information in the database, please set it up first.', 'ope-form-pack'); ?>
        </div>
        <?php
    }
    ?>
    <div class="tabs">
        <div data-id="primary" class="current"><?php echo __('Primary settings', 'ope-form-pack'); ?></div>
        <div data-id="data-store"><?php echo __('Data store', 'ope-form-pack'); ?></div>
        <div data-id="text"><?php echo __('Text', 'ope-form-pack'); ?></div>
        <div data-id="smtp"><?php echo __('SMTP features', 'ope-form-pack'); ?></div>
        <div data-id="attachment"><?php echo __('Attachment', 'ope-form-pack'); ?></div>
        <div data-id="other"><?php echo __('Other', 'ope-form-pack'); ?></div>
        <div data-id="google-recaptcha">Google reCAPTCHA</div>
        <div data-id="test"><?php echo __('Test', 'ope-form-pack'); ?></div>
    </div>
    <div class="content">
        <section data-content="primary" class="current">
            <?php require_once 'primary.php'; ?>
        </section>
        <section data-content="data-store">
            <?php require_once 'data-store.php'; ?>
        </section>
        <section data-content="text">
            <?php require_once 'text.php'; ?>
        </section>
        <section data-content="smtp">
            <?php require_once 'smtp.php'; ?>
        </section>
        <section data-content="attachment">
            <?php require_once 'attachment.php'; ?>
        </section>
        <section data-content="other">
            <?php require_once 'other.php'; ?>
        </section>
        <section data-content="google-recaptcha">
            <?php require_once 'google-recaptcha.php'; ?>
        </section>
        <section data-content="test">
            <?php require_once 'test.php'; ?>
        </section>
    </div>
    <div class="ope-form-panel-btn">
        <div id="ope_form_panel_save"><span><?php echo __('Save settings', 'ope-form-pack'); ?></span></div>
        <div id="ope_form_panel_empty"><span><?php echo __('Empty settings', 'ope-form-pack'); ?></span></div>
    </div>
</div>