var opeImageCrop = function (imageTarget, requiredWidth, requiredHeight) {
	// Variables
	var $doc = jQuery(document),
		$cropMarker,
		$originalImage,
		origSrc = new Image(),
		imageTarget = jQuery(imageTarget).get(0),
		imageScale,
		imageRatio,
		cropRatio,
		adjustedRequiredWidth,
		adjustedRequiredHeight,
		eventState = {},
		allowResize = true,
		keyboardMove = false,
		imageLoaded = new jQuery.Deferred();
	origSrc.crossOrigin = "use-credentials";
	function init() {
		origSrc.onload = function () {
			// Check to make sure the target image is large enough
			if (origSrc.width < requiredWidth || origSrc.height < requiredHeight) {
				console
					.log
					//"Image Crop error: The required dimensions are larger than the target image."
					();
				return false;
			}
			// And neccessary html
			jQuery(imageTarget)
				.wrap('<div class="ope-image-crop-container"></div>')
				.before(
					'\
        <div class="ope-image-crop-crop-marker" id="opeImageCropCropMarker">\
            <div class="ope-image-crop-resize-handle-nw" id="opeImageCropResigzeHandleNW"></div>\
            <div class="ope-image-crop-resize-handle-ne" id="opeImageCropResigzeHandleNE"></div>\
            <div class="ope-image-crop-resize-handle-sw" id="opeImageCropResigzeHandleSW"></div>\
            <div class="ope-image-crop-resize-handle-se" id="opeImageCropResigzeHandleSE"></div>\
            <div class="ope-image-crop-move-handle" id="opeImageCropMoveHandle"></div>\
        </div>\
    '
				);
			$cropMarker = jQuery("#opeImageCropCropMarker");
			$originalImage = jQuery(imageTarget);
			imageScale = origSrc.width / $originalImage.width();
			imageRatio = origSrc.width / origSrc.height;
			cropRatio = requiredWidth / requiredHeight;
			adjustedRequiredWidth = requiredWidth / imageScale;
			adjustedRequiredHeight = requiredHeight / imageScale;
			centerCropMarker();
			repositionOverlay();
			$cropMarker.on("mousedown touchstart", startResize);
			$cropMarker.on(
				"mousedown touchstart",
				"#opeImageCropMoveHandle",
				startMoving
			);
			imageLoaded.resolve();
		};
		origSrc.src = imageTarget.src;
	}
	function startResize(e) {
		e.preventDefault();
		e.stopPropagation();
		saveEventState(e);
		$doc.on("mousemove touchmove", resizing);
		$doc.on("mouseup touchend", endResize);
	}
	function endResize(e) {
		e.preventDefault();
		$doc.off("mouseup touchend", endResize);
		$doc.off("mousemove touchmove", resizing);
	}
	function resizing(e) {
		var mouse = {},
			width,
			height,
			left,
			top,
			originalWidth = $cropMarker.outerWidth(),
			originalHeight = $cropMarker.outerHeight(),
			originalOffset = $cropMarker.position();
		mouse.x =
			(e.clientX || e.pageX || e.originalEvent.touches[0].clientX) +
			jQuery(window).scrollLeft();
		mouse.y =
			(e.clientY || e.pageY || e.originalEvent.touches[0].clientY) +
			jQuery(window).scrollTop();
		var SE = false,
			SW = false,
			NW = false,
			NE = false;
		if (jQuery(eventState.evnt.target).is("#opeImageCropResigzeHandleSE")) {
			SE = true;
		} else if (
			jQuery(eventState.evnt.target).is("#opeImageCropResigzeHandleSW")
		) {
			SW = true;
		} else if (
			jQuery(eventState.evnt.target).is("#opeImageCropResigzeHandleNW")
		) {
			NW = true;
		} else if (
			jQuery(eventState.evnt.target).is("#opeImageCropResigzeHandleNE")
		) {
			NE = true;
		}
		if (SE) {
			width = mouse.x - eventState.containerLeft - $originalImage.offset().left;
			height = (width / requiredWidth) * requiredHeight;
			left = eventState.containerLeft;
			top = eventState.containerTop;
		} else if (SW) {
			width =
				eventState.containerWidth -
				(mouse.x - eventState.containerLeft - $originalImage.offset().left);
			height = (width / requiredWidth) * requiredHeight;
			left = mouse.x - $originalImage.offset().left;
			top = eventState.containerTop;
		} else if (NW) {
			width =
				eventState.containerWidth -
				(mouse.x - eventState.containerLeft - $originalImage.offset().left);
			height = (width / requiredWidth) * requiredHeight;
			left = mouse.x - $originalImage.offset().left;
			top = originalOffset.top + originalHeight - height;
		} else if (NE) {
			width = mouse.x - eventState.containerLeft - $originalImage.offset().left;
			height = (width / requiredWidth) * requiredHeight;
			left = eventState.containerLeft;
			top = originalOffset.top + originalHeight - height;
		}
		if (
			top >= 0 &&
			left >= 0 &&
			Math.round(top + height) <= Math.round($originalImage.height()) &&
			Math.round(left + width) <= Math.round($originalImage.width())
		) {
			allowResize = true;
		}
		if (allowResize) {
			// Over top boundary
			if (top < 0) {
				height = originalHeight + originalOffset.top;
				width = (height / requiredHeight) * requiredWidth;
				top = 0;
				if (NW) {
					left = originalOffset.left - (width - originalWidth);
				}
				allowResize = false;
			}
			// Over left boundary
			else if (left < 0) {
				width = originalWidth + originalOffset.left;
				height = (width / requiredWidth) * requiredHeight;
				left = 0;
				if (SE) {
					top = originalOffset.top - (height - originalHeight);
				}
				allowResize = false;
			}
			// Over bottom boundary
			else if (Math.round(top + height) > Math.round($originalImage.height())) {
				height = $originalImage.height() - top;
				width = (height / requiredHeight) * requiredWidth;
				if (SW) {
					left = originalOffset.left - (width - originalWidth);
				}
				allowResize = false;
			}
			// Over right boundary
			else if (Math.round(left + width) > Math.round($originalImage.width())) {
				width = $originalImage.width() - left;
				height = (width / requiredWidth) * requiredHeight;
				if (NE) {
					top = originalOffset.top - (height - originalHeight);
				}
				allowResize = false;
			}
			// Check for min width / height
			if (width > adjustedRequiredWidth && height > adjustedRequiredHeight) {
				$cropMarker.outerWidth(width).outerHeight(height);
				$cropMarker.css({
					left: left,
					top: top,
				});
			} else {
				if (SW || NW) {
					left = left - (adjustedRequiredWidth - width);
				}
				if (NW || NE) {
					top = top - (adjustedRequiredHeight - height);
				}
				$cropMarker
					.outerWidth(adjustedRequiredWidth)
					.outerHeight(adjustedRequiredHeight);
				$cropMarker.css({
					left: left,
					top: top,
				});
			}
		}
		repositionOverlay();
	}
	function startMoving(e) {
		e.preventDefault();
		e.stopPropagation();
		saveEventState(e);
		$doc.on("mousemove touchmove", moving);
		$doc.on("mouseup touchend", endMoving);
	}
	function endMoving(e) {
		e.preventDefault();
		$doc.off("mouseup touchend", endMoving);
		$doc.off("mousemove touchmove", moving);
	}
	function moving(e) {
		var top,
			left,
			mouse = {},
			touches;
		e.stopPropagation();
		touches = e.originalEvent.touches;
		mouse.x =
			(e.clientX || e.pageX || touches[0].clientX) +
			jQuery(window).scrollLeft();
		mouse.y =
			(e.clientY || e.pageY || touches[0].clientY) + jQuery(window).scrollTop();
		top = mouse.y - (eventState.mouseY - eventState.containerTop);
		left = mouse.x - (eventState.mouseX - eventState.containerLeft);
		if (top < 0) {
			top = 0;
		}
		if (top + $cropMarker.outerHeight() > $originalImage.height()) {
			top =
				$originalImage.height() - $cropMarker[0].getBoundingClientRect().height;
		}
		if (left < 0) {
			left = 0;
		}
		if (left + $cropMarker.outerWidth() > $originalImage.width()) {
			left =
				$originalImage.width() - $cropMarker[0].getBoundingClientRect().width;
		}
		$cropMarker.css({
			top: top,
			left: left,
		});
		repositionOverlay();
	}
	document.addEventListener("keydown", function (e) {
		var top,
			left,
			shiftAmount,
			top = $cropMarker.position().top,
			left = $cropMarker.position().left;
		if (e.shiftKey) {
			shiftAmount = 20;
		} else {
			shiftAmount = 2;
		}
		if (e.key === "ArrowLeft") {
			left = left - shiftAmount;
		} else if (e.key === "ArrowUp") {
			top = top - shiftAmount;
		} else if (e.key === "ArrowRight") {
			left = left + shiftAmount;
		} else if (e.key === "ArrowDown") {
			top = top + shiftAmount;
		}
		if (top < 0) {
			top = 0;
		}
		if (top + $cropMarker.outerHeight() > $originalImage.height()) {
			top =
				$originalImage.height() - $cropMarker[0].getBoundingClientRect().width;
		}
		if (left < 0) {
			left = 0;
		}
		if (left + $cropMarker.outerWidth() > $originalImage.width()) {
			left =
				$originalImage.width() - $cropMarker[0].getBoundingClientRect().width;
		}
		if (keyboardMove) {
			$cropMarker.css({
				top: top,
				left: left,
			});
			repositionOverlay();
		}
	});
	$doc.click(function (e) {
		if (jQuery(e.target).closest(".ope-image-crop-container").length) {
			keyboardMove = true;
		} else {
			keyboardMove = false;
		}
	});
	var saveEventState = function (e) {
		eventState.containerWidth = $cropMarker.outerWidth();
		eventState.containerHeight = $cropMarker.outerHeight();
		eventState.containerLeft = $cropMarker.position().left;
		eventState.containerTop = $cropMarker.position().top;
		eventState.mouseX =
			(e.clientX || e.pageX || e.originalEvent.touches[0].clientX) +
			jQuery(window).scrollLeft();
		eventState.mouseY =
			(e.clientY || e.pageY || e.originalEvent.touches[0].clientY) +
			jQuery(window).scrollTop();
		eventState.evnt = e;
	};
	var centerCropMarker = function () {
		if (cropRatio > imageRatio) {
			$cropMarker.outerWidth($originalImage.width());
			$cropMarker.outerHeight(
				($cropMarker.outerWidth() / requiredWidth) * requiredHeight
			);
			$cropMarker.css({
				top: ($originalImage.height() - $cropMarker.height()) / 2 + "px",
				left: 0,
			});
		} else {
			$cropMarker.outerHeight($originalImage.height());
			$cropMarker.outerWidth(
				($cropMarker.outerHeight() / requiredHeight) * requiredWidth
			);
			$cropMarker.css({
				left: ($originalImage.width() - $cropMarker.width()) / 2 + "px",
				top: 0,
			});
		}
	};
	function repositionOverlay() {
		var imgWidth = $originalImage[0].getBoundingClientRect().width,
			imgHeight = $originalImage[0].getBoundingClientRect().height,
			cropTop = $cropMarker.position().top,
			cropLeft = $cropMarker.position().left,
			cropWidth = $cropMarker[0].getBoundingClientRect().width,
			cropHeight = $cropMarker[0].getBoundingClientRect().height;
		let $cpw = cropWidth;
		let $cph = cropHeight;
		let $cpt = cropTop;
		let $cpl = cropLeft;
		let $cpr = imgWidth - cropLeft - cropWidth;
		let $cpb = imgHeight - cropTop - cropHeight;
		jQuery(".ope-image-crop-container").css({
			"--clip-path-width": $cpw + "px",
			"--clip-path-height": $cph + "px",
			"--clip-path-top": $cpt + "px",
			"--clip-path-left": $cpl + "px",
			"--clip-path-right": $cpr + "px",
			"--clip-path-bottom": $cpb + "px",
		});
	}
	// Crop to required size
	this.crop = function () {
		//console.log($cropMarker);
		var cropCanvas,
			img = new Image(),
			scale = origSrc.width / $originalImage.width(),
			left = Math.round($cropMarker.position().left * scale),
			top = Math.round($cropMarker.position().top * scale),
			width = Math.round($cropMarker.outerWidth() * scale),
			height = Math.round($cropMarker.outerHeight() * scale);
		results;
		cropCanvas = document.createElement("canvas");
		cropCanvas.width = requiredWidth;
		cropCanvas.height = requiredHeight;
		cropCanvas
			.getContext("2d")
			.drawImage(
				origSrc,
				left,
				top,
				width,
				height,
				0,
				0,
				requiredWidth,
				requiredHeight
			);
		img.src = cropCanvas.toDataURL("image/jpeg", 0.9);
		var results = {
			img: img,
			left: left,
			top: top,
			width: width,
			height: height,
			requiredWidth: requiredWidth,
			requiredHeight: requiredHeight,
		};
		return results;
	};
	this.position = function (left, top, width, height) {
		jQuery.when(imageLoaded).done(function () {
			var scale = origSrc.width / $originalImage.width();
			(left = Math.round(left / scale)),
				(top = Math.round(top / scale)),
				(width = Math.round(width / scale)),
				(height = Math.round(height / scale));
			$cropMarker.outerWidth(width).outerHeight(height);
			$cropMarker.css({
				left: left,
				top: top,
			});
			repositionOverlay();
		});
	};
	this.cropReset = function () {
		centerCropMarker();
		repositionOverlay();
	};
	// Viewport resize
	jQuery(window).resize(function (e) {
		imageScale = origSrc.width / $originalImage.width();
		adjustedRequiredWidth = requiredWidth / imageScale;
		adjustedRequiredHeight = requiredHeight / imageScale;
		centerCropMarker();
		repositionOverlay();
	});
	init();
};
