(function ($) {

	const urlPattern = new RegExp(
		'^(https?:\\/\\/)?' +
		'((([a-z\\d]([a-z\\d-]*[a-z\\d])*)\\.)+[a-z]{2,}|' +
		'((\\d{1,3}\\.){3}\\d{1,3}))' +
		'(\\:\\d+)?' +
		'(\\/[-a-z\\d%_.~+]*)*' +
		'(\\?[;&a-z\\d%_.~+=-]*)?' +
		'(\\#[-a-z\\d_]*)?$', 'i'
	);

	const isValidUrl = (urlString) => urlPattern.test(urlString);

	let ope_multistep_count = 0;

	function getCAPCHACODE() {
		const $verificationGraph = jQuery(".verification-graph");
		const url = ope_form_object.ajaxurl;
		const secureNonce = ope_form_object.form_nonce;

		jQuery.ajax({
			url: url,
			method: "POST",
			data: {
				action: "get_CAPCHACODE",
				security: secureNonce,
				id: $verificationGraph.data("string"),
			}
		}).done(function (res) {
			if (res) {
				const imgTag = `<img src="data:image/png;base64,${res}">`;
				const $img = $verificationGraph.find("img");

				if ($img.length === 0) {
					$verificationGraph.html(imgTag);
				} else {
					$img.attr("src", "data:image/png;base64," + res);
				}

				$verificationGraph.removeClass("hold");
			}
		}).fail(function (err, textStatus, errorThrown) {
			alert(ope_form_object.text_issue_load_capcha);
		});
	}




	let check_CAPCHACODE_TIMER = 0;

	function checkCAPCHACODE() {
		const $verification = jQuery(".opeform-verification");
		if (!$verification.hasClass("hold")) {
			return;
		}
		clearTimeout(check_CAPCHACODE_TIMER);
		check_CAPCHACODE_TIMER = setTimeout(function () {
			const $input = jQuery(".opeform-verification input");
			const url = ope_form_object.ajaxurl;
			const secureNonce = ope_form_object.form_nonce;
			const inputValue = $input.val().trim();
			const inputId = $input.data("id");

			jQuery.ajax({
				url: url,
				method: "POST",
				data: {
					action: "check_CAPCHACODE",
					security: secureNonce,
					id: inputId,
					value: inputValue,
				}
			}).done(function (res) {
				try {
					res = JSON.parse(res);
					if (inputValue.length === 8) {
						const $icon = jQuery(".ope-form .opeform-verification-wrapper i");
						if (res.match === 1) {
							$icon.removeClass("waiting not-matched").addClass("matched");

							if (ope_form_object.check_immediately !== "on") {
								hideErrorMessage($input);
							}
						} else {
							$icon.removeClass("waiting").addClass("matched not-matched");
							errorMessage(ope_form_object.verification_failed, $input);
						}
					}
				} catch (e) {

				}

				$verification.removeClass("hold");

			}).fail(function (err, textStatus, errorThrown) {
				$verification.removeClass("hold");
			});
		}, 500);
	}

	function checkVerificationCode() {
		jQuery(".opeform-verification input")
			.off()
			.on("input", function () {
				if (jQuery(this).val().length == 8) {
					jQuery(".opeform-verification").addClass("hold");
					jQuery(".ope-form .opeform-item .opeform-verification-wrapper i").addClass("waiting");
					checkCAPCHACODE();
				} else {
					jQuery(".opeform-verification").removeClass("hold");
					jQuery(".ope-form .opeform-verification-wrapper i")
						.removeClass("waiting not-matched matched");
				}
			});
	}

	function capchacode() {
		if (jQuery(".verification-graph").length > 0) {
			getCAPCHACODE();
			jQuery(".verification-graph")
				.off()
				.on("click", function () {
					jQuery(".verification-graph").find("img").remove();
					jQuery(this).addClass("hold");
					getCAPCHACODE();
					jQuery(".opeform-verification").addClass("hold");
					checkCAPCHACODE();
				});
			checkVerificationCode();
		}
	}

	function REFRESHcapchacode() {
		getCAPCHACODE();
		jQuery(".verification-graph")
			.off()
			.on("click", function () {
				jQuery(".verification-graph").find("img").remove();
				jQuery(".verification-graph").addClass("hold");
				getCAPCHACODE();
			});
	}

	function errorMessage($text, $target, $error_type = '') {
		const $item = $target.parents(".opeform-item");

		if ($item.hasClass("has-select")) {
			$item.addClass("error-select");
		}

		if ($item.hasClass("has-checkbox")) {
			$item.addClass("expand");
			$item.find("input").addClass("error");
		} else if ($error_type !== 'type_error') {
			$target.addClass("error");
		}

		const $errMsg = $item.find(".err-msg-content");
		if ($errMsg.length === 0) {
			$item.prepend(`<div class="err-msg-content">${$text}</div>`);
			$item.find(".err-msg-content").addClass("show");
		} else {
			$errMsg.html($text).addClass("show");
		}

		const $label = $target.parent("label");
		if ($label.hasClass("other-field") && $label.find(".err-msg-content").length === 0) {
			$label.addClass("error").prepend(`<div class="err-msg-content">${$text}</div>`);
		}
	}

	function hideErrorMessage($target) {
		const $item = $target.parents(".opeform-item");

		$target.removeClass("error");
		$item.find(".err-msg-content").remove();

		if ($item.hasClass("has-checkbox")) {
			$item.removeClass("expand");
		}

		if ($item.hasClass("has-select")) {
			$item.removeClass("error-select");
		}

		$item.find(".error").removeClass("error");
	}

	function verifyText() {
		jQuery('.opeform-item [type="text"]').each(function () {
			let $this = jQuery(this);

			$this.on({
				"blur": function () {
					if ($this.val().trim().length === 0 && $this.is("[required]")) {
						errorMessage(ope_form_object.required, $this);
					}
				},
				"input": function () {
					hideErrorMessage($this);
				}
			});
		});
	}


	function verifyOtherFields() {
		jQuery('input[is-other-field].required.active').on("blur", function () {
			let $this = jQuery(this);
			if ($this.val().trim() === '') {
				errorMessage(ope_form_object.required_other, $this);
			}
		});
	}

	function verifyImage() {
		jQuery('.opeform-item .upload-image-content [type="ope_image"][required]').each(function () {
			let $this = jQuery(this);
			if ($this.val().trim().length === 0) {
				errorMessage(ope_form_object.required, $this);
			} else {
				hideErrorMessage($this);
			}
		});
	}

	function ValidateEmail(mail) {
		return /^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9-]+\.[a-zA-Z0-9.-]+$/.test(mail);
	}

	function verifyEmail() {
		jQuery('.opeform-item [type="email"]').each(function () {
			let $this = jQuery(this);

			$this.on("blur", function () {
				let emailValue = $this.val().trim();

				if (emailValue.length === 0) {
					if ($this.attr("required") !== undefined) {
						errorMessage(ope_form_object.required, $this);
					}
					if ($this.attr("confirm") !== undefined) {
						checkEmailMatch($this);
					}
					return;
				}

				if (!ValidateEmail(emailValue)) {
					errorMessage(ope_form_object.invalid_email, $this, 'type_error');
					return;
				}

				hideErrorMessage($this);

				if ($this.attr("confirm") !== undefined) {
					checkEmailMatch($this);
				} else {
					checkConfirmEmailMatch($this, emailValue);
				}
			});

			$this.on("input", function () {
				hideErrorMessage($this);
			});
		});
	}

	function checkEmailMatch($this) {
		let confirmEmail = jQuery('.opeform-item [type="email"]:not([confirm])').val().trim();
		if ($this.val().trim() !== confirmEmail) {
			errorMessage(ope_form_object.email_not_matched, $this);
		}
	}

	function checkConfirmEmailMatch($this, emailValue) {
		let confirmEmailField = $this.parents(".item").next(".item").find('[type="email"][confirm]');
		if (confirmEmailField.length > 0 && emailValue === confirmEmailField.val().trim()) {
			hideErrorMessage($this);
			hideErrorMessage(confirmEmailField);
		}
	}

	function ValidateTel(tel) {
		tel = tel.replace(/[━.*‐.*―.*－.*\-.*ー.*\-]/gi, "");
		return /^\d{10,15}$/.test(tel);
	}
	function verifyTel() {
		jQuery('.opeform-item [type="tel"]').each(function () {
			let $this = jQuery(this);
			$this.on("blur input", function () {
				let telValue = $this.val().trim();
				if (telValue.length === 0) {
					if ($this.attr("required") !== undefined) {
						errorMessage(ope_form_object.required, $this);
					}
				} else if (!ValidateTel(telValue)) {
					errorMessage(ope_form_object.invalid_phone, $this);
				} else {
					hideErrorMessage($this);
				}
			});
		});
	}

	function verifyTextarea() {
		jQuery(".opeform-item textarea").each(function () {
			let $this = jQuery(this);

			$this.on("blur input", function () {
				let value = $this.val().trim();
				if (value.length === 0 && $this.attr("required") !== undefined) {
					errorMessage(ope_form_object.required, $this);
				} else {
					hideErrorMessage($this);
				}
			});
		});
	}

	const FileSizeValidation = ($file, $maxSize, $types) => {
		const files = $file[0].files;
		if (files.length > 0) {
			let validExt = $types ? $types.replaceAll(".", "").split(",") : [];
			let isValid = true;

			Array.from(files).forEach(file => {
				const filesize = file.size;
				const name = file.name;
				const extension = name.slice(((name.lastIndexOf('.') - 1) >>> 0) + 2);

				if (filesize >= $maxSize) {
					errorMessage(ope_form_object.fileTooBig, $file);
					$file.val("");
					$file.parents(".opeform-item").removeClass("has-file").find(".upload-file-name").html("");
					isValid = false;
				} else if ($types && !validExt.includes(extension)) {
					errorMessage(ope_form_object.fileTypeError, $file);
					$file.val("");
					$file.parents(".opeform-item").removeClass("has-file").find(".upload-file-name").html("");
					isValid = false;
				}
			});

			if (isValid) {
				hideErrorMessage($file);
				$file.parents(".opeform-item").addClass("has-file")
					.find(".upload-file-name").html(files[0].name)
					.end()
					.find(".remove-file")
					.off()
					.on("click", function () {
						$file.parents(".opeform-item").removeClass("has-file")
							.find(".upload-file-name").html("");
						$file.val("");
					});
			}
		}
	};

	function verifyFile() {
		jQuery('.opeform-item [type="file"]').each(function () {
			let $this = jQuery(this);
			let $maxSize = parseInt($this.attr("size"));
			let $types = $this.attr("accept") || "";

			$this.on("change", function () {
				FileSizeValidation($this, $maxSize, $types);
			});
		});
	}

	function verifyCheckbox() {
		jQuery(".opeform-item.has-checkbox").each(function () {
			let $thisItem = jQuery(this);
			let $quantity = $thisItem.data("quantity") || 1;

			$thisItem.find("input").each(function () {
				let $this = jQuery(this);

				$this.on("change", function () {
					let $checkedItems = $thisItem.find("input:checked");
					if ($checkedItems.length >= $quantity) {
						$thisItem.find("input:not(:checked)").parent("label:not(.other-field)").addClass("disable");
						handleOtherField($this, true);
					} else {
						$thisItem.find(".disable").removeClass("disable");
						handleOtherField($this, false);
						if ($checkedItems.length <= 0 && $thisItem.attr("required") !== undefined) {
							errorMessage(ope_form_object.required, $this);
						}
					}
					if ($thisItem.find('[data-custom-receiver]').length > 0) {
						updateCustomReceiver($thisItem, $checkedItems);
					}
					hideErrorMessage($this);
				});
			});
		});
	}

	function handleOtherField($checkbox, isChecked) {
		let $otherField = $checkbox.parents(".opeform-item").find(".other-field");
		if ($checkbox.parent("label").hasClass("is-other-item")) {
			if (isChecked) {
				if ($otherField.length > 0 && !$otherField.hasClass("show")) {
					$otherField.addClass("show").find("input").addClass("active");
					if ($otherField.find("input").attr("other_required") !== undefined) {
						$otherField.find("input").addClass("required");
					}
				}
			} else {
				if ($otherField.hasClass("show")) {
					$otherField.removeClass("show").find("input").removeClass("required active");
					hideErrorMessage($otherField.find("input"));
				}
			}
		}
	}

	function updateCustomReceiver($item, $checkedItems) {
		if ($checkedItems.length > 0) {
			let $customReceiver = [];
			$checkedItems.each(function () {
				$customReceiver.push(jQuery(this).data("custom-receiver"));
			});
			$item.attr("data-receiver", $customReceiver);
		} else {
			$item.removeAttr("data-receiver");
		}
	}

	function radioBox() {
		jQuery(".opeform-item.has-radiobox").each(function () {
			let $thisItem = jQuery(this);

			$thisItem.find("input").each(function () {
				let $radio = jQuery(this);

				updateReceiver($radio);

				$radio.on("change", function () {
					$radio.parent("label").siblings("label").find("input").prop("checked", false);
					updateReceiver($radio);
				});
			});
		});
	}

	function updateReceiver($radio) {
		let $parentItem = $radio.parents(".opeform-item");

		if ($parentItem.find('[data-custom-receiver]').length > 0) {
			let $checkedItems = $parentItem.find("input:checked");

			if ($checkedItems.length > 0) {
				$parentItem.attr("data-receiver", $checkedItems.data("custom-receiver"));
			} else {
				$parentItem.removeAttr("data-receiver");
			}
		}
	}

	function formSelect() {
		jQuery(".opeform-item.has-select").each(function () {
			let $this = jQuery(this);

			$this.find(".selected-text").on("click", function () {
				toggleSelect($this);
			});

			$this.find(".select-wrapper").find("[data-value]").on("click", function () {
				selectOption($this, jQuery(this));
			});

			jQuery(document).on("click", function (e) {
				if (e.target !== $this.find(".selected-text")[0]) {
					closeSelect($this);
				}
			});
		});
	}

	function toggleSelect($this) {
		$this.find(".selected-text").toggleClass("active");
		$this.find(".select-wrapper").toggleClass("show");
		if ($this.find(".select-wrapper").hasClass("show")) {
			$this.find(".select-wrapper")[0].scrollTo(0, 0);
		}

		if ($this.attr("required") !== undefined && !$this.find(".selected-text").hasClass("active")) {
			if ($this.find('input[type="hidden"]').val().trim() === "") {
				errorMessage(ope_form_object.required, $this.find("input"));
			}
		}
	}

	function selectOption($this, $option) {
		$this.find('input[type="hidden"]').val($option.data("value"));
		$this.find(".selected-text").html($option.data("value"));
		let $custom_receiver = $option.data("custom-receiver");

		if ($custom_receiver) {
			$this.attr("data-receiver", $custom_receiver);
		} else {
			$this.removeAttr("data-receiver");
		}

		$this.find(".select-wrapper").removeClass("show");
		$this.find(".selected-text").removeClass("active");

		if ($this.attr("required") !== undefined && $this.find('input[type="hidden"]').val().trim() !== "") {
			hideErrorMessage($this.find("input"));
		}
	}

	function closeSelect($this) {
		if ($this.find(".selected-text").hasClass("active")) {
			$this.find(".select-wrapper").removeClass("show");
			$this.find(".selected-text").removeClass("active");
			if (ope_form_object.check_immediately === "on" && $this.attr("required") !== undefined) {
				if ($this.find('input[type="hidden"]').val().trim() === "") {
					errorMessage(ope_form_object.required, $this.find("input"));
				}
			}
		}
	}

	function opeFormConfirmVeriry($target) {
		let $form = $target.parents(".ope-form");
		let $flag = false;

		$form.find("input[required], textarea[required]").each(function () {
			if (jQuery(this).val().trim() === "" || jQuery(this).hasClass("error")) {
				$flag = true;
				errorMessage(ope_form_object.required, jQuery(this));
			}
		});

		$form.find(".opeform-verification input[required]").each(function () {
			if (jQuery(this).val().trim().length > 0 && jQuery(this).val().trim() == '') {
				$flag = true;
				errorMessage(ope_form_object.error, jQuery(this));
			}
		});

		$form.find(".has-select[required] input").each(function () {
			if (jQuery(this).val().trim() === "") {
				$flag = true;
				errorMessage(ope_form_object.required, jQuery(this));
			}
		});

		$form.find("input[is-other-field].active.required").each(function () {
			if (jQuery(this).val().trim() === "") {
				$flag = true;
				errorMessage(ope_form_object.required_other, jQuery(this));
			}
		});

		$form.find(".has-checkbox[required]").each(function () {
			if (jQuery(this).find("input:checked").length <= 0) {
				$flag = true;
				errorMessage(ope_form_object.required, jQuery(this).find("input").eq(0));
			}
		});

		$form.find('[type="tel"][required]').each(function () {
			let $this = jQuery(this);
			if ($this.val().trim().length <= 0) {
				$flag = true;
				errorMessage(ope_form_object.required, $this);
			} else if (!ValidateTel($this.val().trim())) {
				$flag = true;
				errorMessage(ope_form_object.invalid_phone, $this);
			}
		});

		$form.find('[type="email"][required]').each(function () {
			let $this = jQuery(this);
			if ($this.val().trim().length <= 0) {
				$flag = true;
				errorMessage(ope_form_object.required, $this);
			} else if (!ValidateEmail($this.val().trim())) {
				$flag = true;
				errorMessage(ope_form_object.invalid_email, $this);
			} else if ($this.attr("confirm") !== undefined && $this.val().trim() !== $form.find('[type="email"]:not([confirm])').val().trim()) {
				$flag = true;
				errorMessage(ope_form_object.email_not_matched, $this);
			}
		});

		return $flag;
	}

	function opeFormConfirm() {
		jQuery('.opeform-submit[data-action="confirm"]')
			.off()
			.on("click", function () {
				if (ope_form_object.check_immediately !== "on") {
					verifyText();
					verifyImage();
					verifyEmail();
					verifyTel();
					verifyTextarea();
					verifyCheckbox();
					verifyOtherFields();
				}
				if (!opeFormConfirmVeriry(jQuery(this))) {
					let $first_form_item = jQuery(this).parents(".ope-form").offset().top - 100;
					setTimeout(function () {
						jQuery("html,body")[0].scrollTo({
							top: $first_form_item,
							behavior: "smooth",
						});
					}, 200);
					ope_multistep_count++;
					doConfirm(jQuery(this));
				} else {
					setTimeout(function () {
						let $first_error_item = jQuery(".ope-form .error").eq(0).parents(".opeform-item").offset().top - 100;
						jQuery("html,body")[0].scrollTo({
							top: $first_error_item,
							behavior: "smooth",
						});
					}, 200);
				}
			});
	}

	function doConfirm($element) {

		let $cloned_id = $element.parents(".ope-form").data("form-id");
		let $cloned = jQuery("[data-form-id=" + $cloned_id + "].cloned");

		$cloned.addClass("confirming").siblings('[data-form-id="' + $cloned_id + '"]').addClass("hide");
		jQuery("body").addClass("ope-form-step-2").removeClass("ope-form-step-1");

		$element.parents(".ope-form").find(".opeform-item").each(function () {
			let $item = jQuery(this);
			let $id = $item.find('input, textarea').data("id");

			$item.find('input[type="text"], input[type="tel"], input[type="email"]').each(function () {
				let $val = jQuery(this).val();
				if ($item.hasClass("has-checkbox") || $item.hasClass("has-radiobox")) return;
				$cloned.find('[data-target="' + $id + '"]').text($val.replace(/\n/g, "<br>"));
			});

			$item.find('textarea').each(function () {
				let $val = jQuery(this).val();
				if ($item.hasClass("has-checkbox") || $item.hasClass("has-radiobox")) return;
				$cloned.find('[data-target="' + $id + '"]').html($val.replace(/\n/g, "<br>"));
			});

			$item.find('input[type="file"]').each(function () {
				let $val = jQuery(this).val();
				const fileName = $val.split("\\").pop();
				$cloned.find('[data-target="' + $id + '"]').text(fileName);
			});


			$item.find('input[type="ope_image"]').each(function () {
				let $val = jQuery(this).val();
				$cloned.find('[data-target="' + $id + '"]').html('<img src="' + $val + '">');
			});

			$item.find('input[type="hidden"]').each(function () {
				if (jQuery(this).parents(".select").length > 0) {
					let $val = jQuery(this).parents(".select").find(".selected-text").html() || "";
					$cloned.find('[data-target="' + $id + '"]').text($val);
				}
			});

			if ($item.hasClass("has-checkbox")) {
				let $val = "";
				$item.find('input[type="checkbox"]:not([is-other-checkbox])').each(function () {
					if (jQuery(this).prop("checked")) {
						$val += "<span>" + jQuery(this).val() + "</span>";
					}
				});
				$item.find('input[is-other-checkbox]').each(function () {
					if (jQuery(this).prop("checked")) {
						let $checked = "<span>" + jQuery(this).val();
						let $other_text = $item.find('input[is-other-field].active').val();
						if ($other_text) $checked += "-" + $other_text.trim();
						$checked += "</span>";
						$val += $checked;
					}
				});
				$cloned.find('[data-target="' + $id + '"]').html($val || "");
			}

			if ($item.hasClass("has-radiobox")) {
				let $val = "";
				$item.find('input[type="radio"]').each(function () {
					if (jQuery(this).prop("checked")) {
						$val += "<span>" + jQuery(this).val() + "</span>";
					}
				});
				$cloned.find('[data-target="' + $id + '"]').html($val || "");
			}
		});
	}

	function cloneForm() {
		const $clone = jQuery(".ope-form").clone().addClass("cloned");
		const $item_count = $clone.find(".item").length;
		let $i = 0;

		$clone.find(".control").each(function () {
			$i++;
			if (jQuery(this).find(".opeform-verification").length > 0) {
				jQuery(this).parents(".item").remove();
			}
			if (
				jQuery(this).find('input[type="email"]').attr("confirm") != undefined
			) {
				jQuery(this).parents(".item").remove();
			}

			let $id = jQuery(this).find("[data-id]").data("id");
			jQuery(this).attr("data-target", $id);

			let $type = jQuery(this).find("[type]").attr("type");
			if ($type) {
				jQuery(this).attr("data-type", $type);
			}

			let $name = jQuery(this).find("[data-item-name]").data("item-name");
			jQuery(this).attr("data-target-name", $name).html("");

			if ($i == $item_count) {
				jQuery(this).html(
					'<div class="opeform-item multi-btn"><div class="opeform-submit" data-action="prev"><span>' +
					ope_form_object.prev_btn_text +
					'</span></div><div class="opeform-submit" data-progress="0%" data-action="send"><span>' +
					ope_form_object.send_btn_text +
					"</span></div></div>"
				);
			}
		});

		if ($clone.data("confirm-text") != "") {
			$clone.prepend(
				'<div class="note">' + $clone.data("confirm-text") + "</div>"
			);
		}

		$clone.insertAfter(jQuery(".ope-form"));

		jQuery('[data-action="send"]').on("click", function (e) {
			let $thisBtn = jQuery(this);
			if ($thisBtn.hasClass("waiting")) {
				return;
			}
			let $this_id = jQuery(this).data("form-id");
			let $this = jQuery(this)
				.parents(".cloned")
				.prev('[data-form-id="' + $this_id + '"]');
			let $result = opeFormConfirmVeriry($this);
			if (!$result) {
				ope_multistep_count++;
				$thisBtn.addClass("waiting");

				(async () => {
					try {

						jQuery('[data-action="confirm"]').addClass("waiting");

						const url = ope_form_object.ajaxurl;
						const secureNonce = ope_form_object.form_nonce;
						const data = { s: secureNonce, action: "getToken" };

						const response = await fetch(url, {
							method: "POST",
							headers: {
								"Content-Type": "application/x-www-form-urlencoded",
							},
							body: new URLSearchParams(data),
						});

						if (!response.ok) {
							alert(ope_form_object.text_failed_get_token);
							throw new Error(`HTTP error! Status: ${response.status}`);
						}

						const jsonData = await response.json();

						if (jsonData && jsonData.token) {
							jQuery('[name="ope_form_token"]').val(jsonData.token);
							doSend($thisBtn, e);
						} else {
							alert(ope_form_object.text_invalid_token);
							$thisBtn.removeClass("waiting");
						}
					} catch (error) {
						alert(ope_form_object.text_error_occurred);
						$thisBtn.removeClass("waiting");
					} finally {
						jQuery('[data-action="confirm"]').removeClass("waiting");
					}
				})();

			}

		});

		jQuery('[data-action="prev"]').on("click", function () {
			let $cloned_id = jQuery(this).parents(".ope-form").data("form-id");
			let $cloned = jQuery("[data-form-id=" + $cloned_id + "].cloned");
			$cloned
				.removeClass("confirming")
				.siblings('[data-form-id="' + $cloned_id + '"]')
				.removeClass("hide");
			jQuery("body").addClass("ope-form-step-1").removeClass("ope-form-step-2");
			$cloned.find("[data-target]").html("");

			setTimeout(() => {
				let $first_form_item = jQuery(".ope-form").eq(0).offset().top - 60;
				setTimeout(function () {
					jQuery("html,body")[0].scrollTo({
						top: $first_form_item,
						behavior: "smooth",
					});
				}, 50);
			}, 100);
		});
	}

	const ajaxSendEmail = async ($data, $obj, e) => {
		if (jQuery('[name="ope_user_name"]').length > 0) {
			location.reload();
			return;
		}

		let $behavior = {
			"click_action": true,
			"multistep_count": ope_multistep_count,
			"ua": navigator.userAgent,
			"current_page": jQuery("[data-form-category]").data("form-category"),
			"language": navigator.language,
			"logical_processors": navigator.hardwareConcurrency,
			"screen_size": `${window.innerWidth}X${window.innerHeight}`,
			"click_position": `x:${e.pageX - jQuery(e.currentTarget).offset().left}||y:${e.pageY - jQuery(e.currentTarget).offset().top}`
		};

		if (jQuery(".ope-form .opeform-verification input").length > 0) {
			$behavior["request_code"] = jQuery(".ope-form .opeform-verification input").val().trim();
		} else {
			$behavior["request_code"] = '';
		}

		$behavior = JSON.stringify($behavior);

		const url = ope_form_object.ajaxurl;
		const secureNonce = ope_form_object.form_nonce;

		let from_name = "";
		const from_name_input = $obj.parents(".ope-form").prev(".ope-form").find("input[data-from-name]");
		if (from_name_input.length > 0) {
			from_name_input.each(function () {
				from_name += jQuery(this).val().trim();
				if (ope_form_object.name_format == 'EN' || ope_form_object.name_format == 'JA') {
					from_name += ' ';
				}
			});
		}

		const vid = $obj.parents(".ope-form").prev(".ope-form").find(".opeform-verification input");
		const dataFromEmail = $obj.parents(".ope-form").prev(".ope-form").find("input[data-from-email]");
		const formCat = $obj.parents(".ope-form").data("form-category");

		let $admin_email_address = $obj.parents(".ope-form").prev(".ope-form").find("[data-opeform-admin-email-address]").data("opeform-admin-email-address");
		$admin_email_address = $admin_email_address ? JSON.stringify($admin_email_address) : "";

		let $admin_email_subject = $obj.parents(".ope-form").prev(".ope-form").find("[data-opeform-admin-email-subject]").data("opeform-admin-email-subject");
		$admin_email_subject = $admin_email_subject ? JSON.stringify($admin_email_subject) : "";

		let $reply_email_subject = $obj.parents(".ope-form").prev(".ope-form").find("[data-opeform-reply-email-subject]").data("opeform-reply-email-subject");
		$reply_email_subject = $reply_email_subject ? JSON.stringify($reply_email_subject) : "";

		let $admin_email_top = $obj.parents(".ope-form").prev(".ope-form").find("[data-opeform-admin-email-top]").data("opeform-admin-email-top");
		$admin_email_top = $admin_email_top ? JSON.stringify($admin_email_top) : "";

		let $reply_email_top = $obj.parents(".ope-form").prev(".ope-form").find("[data-opeform-autoreply-email-top]").data("opeform-autoreply-email-top");
		$reply_email_top = $reply_email_top ? JSON.stringify($reply_email_top) : "";

		let $reply_email_bottom = $obj.parents(".ope-form").prev(".ope-form").find("[data-opeform-autoreply-email-bottom]").data("opeform-autoreply-email-bottom");
		$reply_email_bottom = $reply_email_bottom ? JSON.stringify($reply_email_bottom) : "";

		let $data_receiver = [];
		$('[data-receiver]').each(function () {
			if ($(this).data("receiver")) {
				$data_receiver.push($(this).data("receiver"));
			}
		});

		const $recaptcha_val = jQuery('#g-recaptcha-response').val();

		let data = {
			nonce: secureNonce,
			name: jQuery('[name="ope_user_name"]').val() || "-/-",
			data: $data,
			action: "send_email",
			behavior: $behavior,
			admin_email_address: $admin_email_address,
			admin_email_subject: $admin_email_subject,
			reply_email_subject: $reply_email_subject,
			admin_email_top: $admin_email_top,
			reply_email_top: $reply_email_top,
			reply_email_bottom: $reply_email_bottom,
			id: vid.length > 0 ? vid.data("id") : "",
			value: vid.length > 0 ? vid.val().trim() : "",
			from_email: dataFromEmail.length > 0 ? dataFromEmail.val().trim() : "",
			from_name: from_name.length > 0 ? from_name : "",
			custom_receiver: JSON.stringify($data_receiver),
			cat: formCat.length > 0 ? formCat : "",
			token: jQuery('[name="ope_form_token"]').val(),
			g_recaptcha_response: $recaptcha_val || "",
		};

		const $files = new FormData();
		for (let key in data) {
			$files.append(key, data[key]);
		}

		const $item_file = $obj.parents(".cloned").find('[data-type="file"]');
		let $data_file = [];
		$item_file.each(function () {
			if (jQuery(this).html().trim() != "") {
				const $key = jQuery(this).data("target-name");
				$data_file.push($key);
			}
		});
		$data_file = JSON.stringify($data_file);
		$files.append("fileNames", $data_file);

		const $fileItem = $obj.parents(".cloned").siblings(".ope-form").find('[type="file"]');
		if ($fileItem.length > 0) {
			$fileItem.each(function () {
				if (jQuery(this).val() != "") {
					const $key = jQuery(this).data("item-name");
					const $value = jQuery(this)[0].files[0];
					$files.append($key, $value);
				}
			});
		}
		$obj.prev('[data-action="prev"]').addClass("hold");
		jQuery.ajax({
			xhr: function () {
				let xhr = new window.XMLHttpRequest();
				xhr.upload.addEventListener("progress", function (evt) {
					if (evt.lengthComputable) {
						const percentComplete = evt.loaded / evt.total;
						const percentage = parseInt(percentComplete * 100, 10);
						if (percentage > 1) {
							if (!$obj.hasClass("progressing")) {
								$obj.addClass("progressing");
							}
						}
						$obj.attr("data-progress", `${percentage}%`);
						if (percentComplete === 1) {
							$obj.removeClass("progressing");
						}
					}
				}, false);

				return xhr;
			},
			url: url,
			type: "POST",
			data: $files,
			cache: false,
			processData: false,
			contentType: false,
		}).done(function (response) {
			try {
				response = JSON.parse(response);
				if (response.captcha === "captcha_not_mateched") {
					REFRESHcapchacode();
					checkCAPCHACODE();
					$obj.attr("data-progress", "0%");
					$obj.removeClass("waiting");
					alert(ope_form_object.verification_failed);
				} else if (response.to.status === "success") {
					if ($('.ope-form').attr("data-thanks-page-valid") === 'yes') {
						let path = $('.ope-form').attr('data-thanks-page');
						let thank_page = new URL(path, location.href).href;
						location.replace(thank_page);
					} else {
						jQuery("body").addClass("ope-form-step-3").removeClass("ope-form-step-2");
						showSuccessBox($obj.parents(".ope-form").data("thanks-text"));
						$(".opeform-item").each(function () {
							$(this).removeAttr("data-receiver");
						});
						clearFormFields($obj);
						$obj.removeClass("waiting");
						$obj.prev('[data-action="prev"]').removeClass("hold");
					}
				} else {
					alert(response.to.code);
					$obj.removeClass("waiting");
					$obj.prev('[data-action="prev"]').removeClass("hold");
				}
			} catch (e) {
				alert(ope_form_object.text_failed_process);
				$obj.removeClass("waiting");
				$obj.prev('[data-action="prev"]').removeClass("hold");
			}
		}).fail(function (jqXHR, textStatus, errorThrown) {
			alert(ope_form_object.text_error_occurred_request);
			$obj.attr("data-progress", "0%");
			$obj.removeClass("waiting");
			$obj.prev('[data-action="prev"]').removeClass("hold");
		});

	};

	const clearFormFields = ($obj) => {
		const form = $obj.parents(".ope-form").prev(".ope-form");

		form.find('input[type="text"], input[type="ope_image"], input[type="file"], input[type="email"], input[type="tel"], input[type="number"], textarea')
			.each(function () {
				jQuery(this).val("");
			});

		form.find('.has-file').each(function () {
			jQuery(this).removeClass("has-file");
			jQuery(this).find(".upload-file-name").html("");
		});

		form.find('input[type="checkbox"], input[type="radio"]')
			.each(function () {
				jQuery(this).prop("checked", false);
			});

		form.find(".has-radiobox label:first-child input[type='radio']").prop("checked", true);
		form.find(".has-checkbox .disable").removeClass("disable");
		form.find(".has-select input, .selected-text").each(function () {
			jQuery(this).val("");
			jQuery(this).html("");
		});
		form.find(".text-remaining .r").html("0");
	};


	function showSuccessBox($thanks_message) {
		if (jQuery(".ope-form-success-box").length === 0) {
			let redirectTimer;
			let $html = `
				<div class="ope-form-success-box">
					<div class="icon">
						<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
							<path fill="currentColor" d="M438.6 105.4C451.1 117.9 451.1 138.1 438.6 150.6L182.6 406.6C170.1 419.1 149.9 419.1 137.4 406.6L9.372 278.6C-3.124 266.1-3.124 245.9 9.372 233.4C21.87 220.9 42.13 220.9 54.63 233.4L159.1 338.7L393.4 105.4C405.9 92.88 426.1 92.88 438.6 105.4H438.6z"/>
						</svg>
					</div>
					${$thanks_message ? `<div class="text">${$thanks_message}</div>` : ''}
					<div class="btn-to-home">
						<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 48 48">
							<path fill="currentColor" d="M12 36V12h3v24Zm22.35-.15-11.7-11.7 11.7-11.7 2.15 2.15-9.55 9.55 9.55 9.55Z"/>
						</svg>
						${ope_form_object.return_btn_text}
					</div>
					<div class="timer"><i id="ope_timer"></i></div>
				</div>
			`;

			jQuery("body").prepend($html);
			jQuery(".ope-form.cloned")
				.removeClass("confirming")
				.siblings()
				.removeClass("hide");

			jQuery(".btn-to-home").off("click").on("click", function () {
				clearInterval(redirectTimer);
				let $redirect_url = $(".ope-form").data("return-redirect");
				if ($redirect_url !== undefined) {
					if (isValidUrl($redirect_url)) {
						window.location.replace($redirect_url);
					} else {
						window.location.replace(ope_form_object.back_to_url || location.href);
					}
				} else {
					window.location.replace(ope_form_object.back_to_url || location.href);
				}
			});

			if (ope_form_object.auto_return === "on") {
				let timeleft = ope_form_object.auto_return_timeleft || 10;
				jQuery("#ope_timer").html(timeleft);
				clearInterval(redirectTimer);
				redirectTimer = setInterval(function () {
					timeleft -= 1;
					jQuery("#ope_timer").html(timeleft);
					if (timeleft <= 0) {
						let $redirect_url = $(".ope-form").data("return-redirect");
						if ($redirect_url !== undefined) {
							if (isValidUrl($redirect_url)) {
								window.location.replace($redirect_url);
							} else {
								window.location.replace(ope_form_object.back_to_url || location.href);
							}
						} else {
							window.location.replace(ope_form_object.back_to_url || location.href);
						}
					}
				}, 1000);
			}
		}
	}


	function doSend($element, e) {
		let $data = [];

		$element
			.parents(".cloned")
			.find("[data-target]:not([data-type='file'])")
			.each(function () {
				let $key = jQuery(this).data("target-name");
				let $value = jQuery(this).html()
					.replaceAll("</span><span>", " | ")
					.replaceAll("</span>", "")
					.replaceAll("<span>", "")
					.replaceAll(/<br\s*[\/]?>/gi, "\n");

				$data.push({ key: $key, value: $value });
			});

		$data = JSON.stringify($data);

		if (jQuery(".ope-form #g-recaptcha-response").length > 0) {
			grecaptcha.ready(function () {
				const reCAPTCHA_site_key = ope_form_object.google_recaptcha_v3_site_key;
				grecaptcha.execute(reCAPTCHA_site_key, { action: 'submit' }).then(function (token) {
					$('#g-recaptcha-response').val(token);
					ajaxSendEmail($data, $element, e);
				});
			});
		} else {
			ajaxSendEmail($data, $element, e);
		}

	}

	function textRemaing() {
		jQuery(".ope-form .text-remaining .total").each(function () {
			let $this = jQuery(this);
			let $textarea = $this.closest(".opeform-item").find("textarea");
			let maxlength = parseInt($textarea.attr("maxlength"));

			$this.html(maxlength);

			$textarea.on("input", function () {
				let remaining = maxlength - $textarea.val().length;
				$this.closest(".text-remaining").find(".r").html(remaining);
			});
		});
	}

	function bodyClassControl() {
		jQuery("body").addClass("has-ope-form");
		jQuery("body").addClass("ope-form-step-1");
	}
	function zIndexControl() {
		jQuery(".ope-form .item").on("click", function () {
			jQuery(this).css({ "z-index": 10 }).siblings().css({ "z-index": 5 });
		});
	}
	function opeForm_ImageProcess() {
		if (jQuery(".ope-form-image-processor-wrapper").length <= 0) {
			const $ope_form_image_processor_panel =
				'\
		<div class="ope-form-image-processor-wrapper">\
		<div class="ope-form-image-processor">\
			<section id="dragAndDropSection">\
				<div class="drop" id="drop">\
					<span>' +
				ope_form_object.select_image_and_crop +
				'</span>\
				</div>\
				<input class="file-upload hidden" id="fileUpload" type="file">\
			</section>\
			<section class="hidden" id="resizeSection">\
				<div class="image-resize" id="resizeImage"></div>\
				<div class="control">\
					<button class="btn" id="crop">' +
				ope_form_object.image_crop_text +
				'</button>\
					<button class="btn" id="crop_cancel">' +
				ope_form_object.image_crop_text_cancel +
				'</button>\
				</div>\
			</section>\
			<div class="close-ope-form-processor-card"></div>\
		</div>\
	</div>';
			jQuery("body").append($ope_form_image_processor_panel);
		}
		jQuery(".ope-form-add-image").on("click", function () {
			let $this = jQuery(this);
			if ($this.data("image-action").includes("crop")) {
				jQuery("body").removeAttr("data-ope-form-image-crop-size");
				let $sizes = $this.data("image-action");
				if ($sizes) {
					if ($sizes.split("|").length > 1) {
						jQuery("body").attr(
							"data-ope-form-image-crop-size",
							$sizes.split("|")[1]
						);
					} else {
						let $img_crop_width = ope_form_object.crop_image_width;
						let $img_crop_height = ope_form_object.crop_image_height;
						if ($img_crop_width == '' || $img_crop_height == '') {
							alert(ope_form_object.text_image_crop_size_not_set);
						} else {
							jQuery("body").attr(
								"data-ope-form-image-crop-size",
								$img_crop_width + 'x' + $img_crop_height
							);
						}
					}
				}
				jQuery("body").find(".ope-form-add-image").removeClass("current");
				jQuery(this).addClass("current");
				if (!jQuery("body").hasClass("show-ope-form-image-processor")) {
					jQuery("body").addClass("show-ope-form-image-processor");
				}
			} else {
				readImageAndSet($this);
			}
		});

		function readImageAndSet($obj) {
			$obj.addClass("current");
			jQuery(".ope-form-image-processor #fileUpload").trigger("click");
		}

		jQuery(".upload-image-content .btn-remove").on("click", function () {
			jQuery(this)
				.parent(".img-temp-content")
				.removeClass("has-image")
				.find("img")
				.attr("src", "");
			jQuery(this)
				.parents(".opeform-item")
				.find('input[type="ope_image"]')
				.val("");
			jQuery(".ope-form-image-processor #resizeImage").html("");
			verifyImage();
		});
		jQuery(".close-ope-form-processor-card").on("click", function () {
			if (jQuery("body").hasClass("show-ope-form-image-processor")) {
				jQuery("body").removeClass("show-ope-form-image-processor");
			}
			jQuery(".ope-form-image-processor #resizeSection").addClass("hidden");
			jQuery(".ope-form-image-processor #dragAndDropSection").removeClass(
				"hidden"
			);
		});
		jQuery(".ope-form-image-processor #drop").on("click", function () {
			jQuery(".ope-form-image-processor #fileUpload").trigger("click");
		});
		jQuery(".ope-form-image-processor #fileUpload").on("change", function (e) {
			let $sizes = jQuery("body").data("ope-form-image-crop-size");
			if ($sizes) {
				addImage(e.target);
			} else {
				opeFormSetImage(e.target);
			}
			e.target.value = "";
		});
		jQuery(".ope-form-image-processor #drop").on("dragover", function (e) {
			e.preventDefault();
			e.stopPropagation();
			jQuery(this).addClass("dragging");
		});
		jQuery(".ope-form-image-processor #drop").on("dragleave", function (e) {
			jQuery(this).removeClass("dragging");
		});
		jQuery(".ope-form-image-processor #drop").on("drop", function (e) {
			e.preventDefault();
			e.stopPropagation();
			var data = e.dataTransfer || e.originalEvent.dataTransfer;
			addImage(data);
		});

		function opeFormSetImage(data) {
			var file = data.files[0];
			if (file.type.indexOf("image") === -1) {
				alert(ope_form_object.not_a_image);
				jQuery(".ope-form-add-image.current").removeClass("current");
				return false;
			}
			var reader = new FileReader();
			reader.onload = function (event) {
				var img = new Image();
				img.onload = function () {
					if (
						img.width > ope_form_object.image_max_width ||
						img.height > ope_form_object.image_max_height
					) {
						alert(ope_form_object.too_large);
						jQuery(".ope-form-add-image.current").removeClass("current");
						return false;
					}
					jQuery(".ope-form-add-image.current")
						.parents(".opeform-item")
						.find(".img-temp-content")
						.addClass("has-image")
						.find("img")
						.attr("src", img.src);
					jQuery(".ope-form-add-image.current")
						.parents(".opeform-item")
						.find('input[type="ope_image"]')
						.val(img.src);
					jQuery(".ope-form-add-image.current").removeClass("current");
					verifyImage();
				};
				img.src = event.target.result;
			};
			reader.readAsDataURL(file);
		}

		function addImage(data) {
			let $img_crop_width = ope_form_object.crop_image_width;
			let $img_crop_height = ope_form_object.crop_image_height;
			let $sizes = jQuery("body").data("ope-form-image-crop-size");
			if ($sizes) {
				$width = $sizes.split("x")[0];
				$height = $sizes.split("x")[1];
				$img_crop_width = $width;
				$img_crop_height = $height;
			}
			jQuery(".ope-form-image-processor #dragAndDropSection").addClass(
				"hidden"
			);
			jQuery(".ope-form-image-processor").addClass("loading");
			let imgCondition = "max-width";
			var file = data.files[0];
			if (file.type.indexOf("image") === -1) {
				alert(ope_form_object.not_a_image);
				jQuery(".ope-form-image-processor").removeClass("loading");
				jQuery(".ope-form-image-processor #dragAndDropSection").removeClass(
					"hidden"
				);
				return false;
			}
			var reader = new FileReader();
			reader.onload = function (event) {
				var img = new Image();
				img.onload = function () {
					if (
						(img.height / img.width).toFixed(2) >=
						(
							jQuery(".ope-form-image-processor").height() /
							jQuery(".ope-form-image-processor").width()
						).toFixed(2)
					) {
						imgCondition = "max-height";
					} else {
						imgCondition = "max-width";
					}
					if (img.width < $img_crop_width || img.height < $img_crop_height) {
						alert(ope_form_object.not_large_enough);
						jQuery(".ope-form-image-processor").removeClass("loading");
						jQuery(".ope-form-image-processor #dragAndDropSection").removeClass(
							"hidden"
						);
						return false;
					}
					if (
						img.width > ope_form_object.image_max_width ||
						img.height > ope_form_object.image_max_height
					) {
						alert(ope_form_object.too_large);
						jQuery(".ope-form-image-processor").removeClass("loading");
						jQuery(".ope-form-image-processor #dragAndDropSection").removeClass(
							"hidden"
						);
						return false;
					}
					cropImage(img, imgCondition);
				};
				img.src = event.target.result;
			};
			reader.readAsDataURL(file);
		}
		function cropImage(originalImage, imageCondition) {
			let $img_crop_width = ope_form_object.crop_image_width;
			let $img_crop_height = ope_form_object.crop_image_height;
			let $sizes = jQuery("body").data("ope-form-image-crop-size");
			if ($sizes) {
				$width = $sizes.split("x")[0];
				$height = $sizes.split("x")[1];
				$img_crop_width = $width;
				$img_crop_height = $height;
			}
			jQuery(originalImage)
				.attr("class", "ope-form-fullimage")
				.addClass(imageCondition);
			jQuery(".ope-form-image-processor #resizeImage").html(originalImage);
			jQuery(".ope-form-image-processor #resizeSection").removeClass("hidden");
			jQuery(".ope-form-image-processor").removeClass("loading");

			var newImage = new opeImageCrop(
				".ope-form-fullimage",
				$img_crop_width,
				$img_crop_height
			);
			jQuery(".ope-form-image-processor #crop")
				.off()
				.on("click", function () {
					var results = newImage.crop();
					jQuery(".ope-form-image-processor #resizeSection").addClass("hidden");
					jQuery(".ope-form-image-processor #dragAndDropSection").removeClass(
						"hidden"
					);
					jQuery(".ope-form-add-image.current")
						.parents(".opeform-item")
						.find(".img-temp-content")
						.addClass("has-image")
						.find("img")
						.attr("src", results.img.src);
					jQuery(".ope-form-add-image.current")
						.parents(".opeform-item")
						.find('input[type="ope_image"]')
						.val(results.img.src);
					jQuery("body").removeClass("show-ope-form-image-processor");
					verifyImage();
				});
			jQuery(".ope-form-image-processor #crop_cancel")
				.off()
				.on("click", function () {
					jQuery(".ope-form-image-processor #resizeSection").addClass("hidden");
					jQuery(".ope-form-image-processor #dragAndDropSection").removeClass(
						"hidden"
					);
				});
		}
	}

	function ope_form_generateRandomString(length) {
		const chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
		const charLength = chars.length;
		const result = Array.from({ length }, () => chars.charAt(Math.floor(Math.random() * charLength))).join('');
		return result;
	}

	const check_thanks_page = () => {
		if ($('.ope-form [data-thanks-page]') != undefined) {
			let path = $('.ope-form').attr('data-thanks-page');
			let thank_page = new URL(path, location.href).href;

			(async () => {
				try {
					const url = thank_page;
					const options = {
						method: 'POST',
						headers: {
							'Content-Type': 'application/json',
						},
						body: JSON.stringify({
							thanks_page_check: 'ope'
						}),
					};

					const response = await fetch(url, options);

					if (!response.ok) {
						throw new Error(`HTTP error! status: ${response.status}`);
					}

					const data = await response.json();
					if (!data.success) {
						alert(ope_form_object.text_thanks_page_config_error);
					} else {
						$('.ope-form').attr("data-thanks-page-valid", "yes");
					}
				} catch (error) {
					alert(ope_form_object.text_thanks_page_config_error);
				}
			})();

		}
	}

	jQuery(function () {
		const $opeForms = jQuery(".ope-form");
		if ($opeForms.length > 0) {
			$opeForms.each(function () {
				jQuery(this).attr("data-form-id", ope_form_generateRandomString(32));
			});

			opeForm_ImageProcess();
			jQuery('[name="ope_user_name"]').remove();
			bodyClassControl();
			capchacode();
			if (ope_form_object.check_immediately === "on") {
				const verifyFunctions = [
					verifyText,
					verifyEmail,
					verifyTel,
					verifyTextarea,
					verifyOtherFields
				];
				verifyFunctions.forEach(fn => fn());
			}
			check_thanks_page();
			verifyCheckbox();
			radioBox();
			formSelect();
			opeFormConfirm();
			cloneForm();
			textRemaing();
			zIndexControl();
			verifyFile();
		}
	});

})(jQuery);
