<?php
/* Name:OPE FORM V2
 ** Version:20241122
 ** Author:1pxeye
 */
if (!defined('ABSPATH')) {
    die('Access Denied!');
}

add_action('after_setup_theme', 'opeform_language_setup');
function opeform_language_setup()
{
    load_theme_textdomain('ope-form-pack', get_template_directory() . '/pack/contact-form/language');
}

class opeEncrypDecrypt
{
    private static function key()
    {
        $key = file_get_contents(get_theme_file_path('/pack/contact-form/admin/') . 'random.key');
        if (empty($key)) {
            $key_string = uniqid();
            file_put_contents(get_theme_file_path('/pack/contact-form/admin/') . 'random.key', $key_string);
            return $key_string;
        } else {
            return $key;
        }
    }

    public static function encrypt($plaintext, $cipher = "aes-256-gcm")
    {
        $key = self::key();
        if (!in_array($cipher, openssl_get_cipher_methods())) {
            return false;
        }
        $iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length($cipher));
        $tag = openssl_random_pseudo_bytes(16);
        $encrypted = openssl_encrypt(
            gzcompress($plaintext),
            $cipher,
            base64_decode($key),
            OPENSSL_RAW_DATA,
            $iv,
            $tag
        );
        if ($encrypted === false) {
            return false;
        }
        return json_encode([
            "a" => base64_encode($tag),
            "b" => base64_encode($encrypted),
            "c" => base64_encode($iv),
        ]);
    }

    public static function decrypt($jsonData, $cipher = "aes-256-gcm")
    {
        $key = self::key();
        try {
            $json = json_decode($jsonData, true, 512, JSON_THROW_ON_ERROR);
        } catch (Exception $e) {
            return false;
        }

        $decrypted = openssl_decrypt(
            base64_decode($json['b']),
            $cipher,
            base64_decode($key),
            OPENSSL_RAW_DATA,
            base64_decode($json['c']),
            base64_decode($json['a'])
        );

        if ($decrypted === false) {
            return false;
        }

        return gzuncompress($decrypted);
    }
}

$ope_form_panel_config = get_option('ope_form_panel_config');
$ope_form_panel_config = opeEncrypDecrypt::decrypt($ope_form_panel_config);
$ope_form_panel_config = json_decode(stripslashes($ope_form_panel_config));
$ope_form_panel_config_status = get_option('ope_form_panel_config_status');


if (current_user_can('administrator')) {
    require_once 'admin/admin.php';
}

if (@$ope_form_panel_config->smtp_support == "on") {
if (!empty($ope_form_panel_config->smtp_name)) {
    add_filter('wp_mail_from', function () use ($ope_form_panel_config) {
        return $ope_form_panel_config->smtp_name;
    });
}
}


// Hook into the PHPMailer's initialization
add_action('phpmailer_init', 'mail_smtp');
function mail_smtp($phpmailer)
{
    global $ope_form_panel_config;

    $phpmailer->CharSet = 'UTF-8';

    // Set email format (HTML or plain text)
    if (@$ope_form_panel_config->email_format == "html") {
        $phpmailer->IsHTML(true);
    } else {
        $phpmailer->IsHTML(false);
    }

    // Configure SMTP settings if supported
    if (@$ope_form_panel_config->smtp_support == "on") {
        $phpmailer->isSMTP();
        $phpmailer->Host = @$ope_form_panel_config->smtp_host;
        $phpmailer->SMTPAuth = true;
        $phpmailer->Port = @$ope_form_panel_config->smtp_port;
        $phpmailer->Username = @$ope_form_panel_config->smtp_name;
        $phpmailer->Password = @$ope_form_panel_config->smtp_pw;
        $phpmailer->SMTPDebug = 0;

        // Set encryption type for SMTP
        if (@$ope_form_panel_config->smtp_secure_type == "start_tls") {
            $phpmailer->SMTPSecure = 'tls';
        } else if (@$ope_form_panel_config->smtp_secure_type == "tls") {
            $phpmailer->SMTPSecure = 'ssl';
        }

        // Set the From name and address
        $phpmailer->From = @$ope_form_panel_config->smtp_name;
        $phpmailer->FromName = @$ope_form_panel_config->email_from_name;
        $phpmailer->Timeout = 10; // Timeout after 30 seconds
    }
}

class opeFormClass
{
    public function return_bytes($size_str)
    {
        switch (substr($size_str, -1)) {
            case 'M': case 'm': return (int) $size_str * 1048576;
            case 'K': case 'k': return (int) $size_str * 1024;
            case 'G': case 'g': return (int) $size_str * 1073741824;
            default: return $size_str;
        }
    }

    public function max_file_upload_size()
    {
        $size1 = self::return_bytes(ini_get('post_max_size'));
        $size2 = self::return_bytes(ini_get('upload_max_filesize'));
        return min($size1, $size2);
    }

    public function convertToBytes(string $from): ?int
    {
        $units = ['B', 'KB', 'MB', 'GB', 'TB', 'PB'];
        $from = trim($from);
        
        preg_match('/^(\d+(?:\.\d+)?)\s*([A-Za-z]*)$/', $from, $matches);
    
        if (!$matches) {
            return null;
        }
    
        $number = (float)$matches[1];
        $suffix = strtoupper($matches[2]);
    
        if ($suffix === '' || $suffix === 'B') {
            return (int)$number;
        }
    
        $exponent = array_search($suffix, $units, true);
        if ($exponent === false) {
            return null;
        }
    
        return (int)($number * (1024 ** $exponent));
    }

    public function getName($size)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $randomString = '';
        for ($i = 0; $i < $size; $i++) {
            $index = rand(0, strlen($characters) - 1);
            $randomString .= $characters[$index];
        }
        return $randomString;
    }
}


if (@$ope_form_panel_config->store_mail_in_db == "on") {
    require 'store.php';
    if (current_user_can('administrator')) {
        require 'mailList/list.php';
    }
}

require 'opeform-ajax-common.php';
function ope_crypto_rand_secure($min, $max)
{
    $range = $max - $min;
    if ($range < 0) {
        return $min;
    }

    $log = log($range, 2);
    $bytes = (int) ($log / 8) + 1;
    $bits = (int) $log + 1;
    $filter = (int) (1 << $bits) - 1;
    do {
        $rnd = hexdec(bin2hex(openssl_random_pseudo_bytes($bytes)));
        $rnd = $rnd &$filter;
    } while ($rnd >= $range);
    return $min + $rnd;
}
function ope_getToken($length)
{
    $token = "";
    $codeAlphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    $codeAlphabet .= "abcdefghijklmnopqrstuvwxyz";
    $codeAlphabet .= "0123456789";
    for ($i = 0; $i < $length; $i++) {
        $token .= $codeAlphabet[ope_crypto_rand_secure(0, strlen($codeAlphabet))];
    }
    return $token;
}
function opeform_function($atts)
{

    global $ope_form_panel_config;
    ob_start();
    if (@$ope_form_panel_config->google_recaptcha_v3 == 'on') {
    wp_enqueue_script('google_recaptcha_v3');
    }
    wp_enqueue_script('ope-form-module');
    wp_enqueue_style('ope-form-main');
    wp_enqueue_script('ope-form-script');
    wp_enqueue_script('ope-form-autofill-zipcode-jp');
    ?>
<input type="hidden" required name="ope_user_name">
<?php
// image
if (@$atts['use'] == "image") {
    ?><div class="opeform-item">
    <label class="upload-image-content">
        <input type="ope_image" data-item-name="<?php echo @$atts['title']; ?>" data-id="<?php echo @$atts['name']; ?>"
            <?php if (@$atts['class']) { echo 'class="' . $atts['class'] . '" '; } ?><?php echo @$atts['required'] == "true" ? "required" : ""; ?>>
        <div class="img-temp-content">
            <img src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7" alt="">
            <span class="btn-remove"></span>
        </div>
        <div class="btn-add-image">
            <span class="ope-form-add-image"
                data-image-action="<?php echo (isset($atts['crop']) && $atts['crop'] !== "true" && @$atts['crop'] !== '') ? "crop|" . @$atts['crop'] : (((isset($atts['crop']) && @$atts['crop'] == "true") || (isset($atts['crop']) && @$atts['crop'] == '')) ? "crop" : ""); ?>"><?php echo @$ope_form_panel_config->image_upload; ?></span>
        </div>
    </label>
</div>
<?php
}

// file
if (@$atts['use'] == "file") {
    $opeFormClass = new opeFormClass();
    $max_upload_size = $opeFormClass->max_file_upload_size();
    $ope_form_max_upload_size = str_replace(['MB', 'Mb', 'mb', 'M', 'm'], '', $ope_form_panel_config->upload_max_size ?? 0);
    $ope_form_user_set_upload_size = $opeFormClass->convertToBytes($ope_form_max_upload_size . 'MB');
    $max_upload_size = min($max_upload_size, $ope_form_user_set_upload_size);
    if (@$atts['size']) {
        $size = $opeFormClass->convertToBytes($atts['size']);
        $size = min($max_upload_size, $size);
    } else {
        $size = $max_upload_size;
    }
    ?><div class="opeform-item">
    <label class="file-label">
        <input type="<?php echo @$atts['use']; ?>" data-item-name="<?php echo @$atts['title']; ?>"
            size="<?php echo $size; ?>" data-id="<?php echo @$atts['name']; ?>" <?php if (@$atts['accept']) { ?>
            accept="<?php echo @$atts['accept']; ?>" <?php } ?>
            <?php if (@$atts['class']) { echo 'class="' . $atts['class'] . '" '; } ?><?php echo @$atts['required'] == "true" ? "required" : ""; ?>>
        <div class="btn-upload">
            <span><?php echo @$ope_form_panel_config->file_upload_text . '<small>(<' . round($size / 1024 / 1024, 2) . 'MB)</small>' ?></span>
        </div>
    </label>
    <div class="upload-file-status">
        <div class="upload-file-name"></div>
        <div class="remove-file"></div>
    </div>
</div>
<?php
}

// input
if (@$atts['use'] == "text" || @$atts['use'] == "email" || @$atts['use'] == "tel") {
    $classes = get_body_class();
    if (!in_array('has-ope-form', $classes)) {
        add_filter('body_class', function ($classes) {
            return array_merge($classes, array('has-ope-form'));
        });
    }
    ?><div class="opeform-item">
    <input type="<?php echo @$atts['use']; ?>" data-item-name="<?php echo @$atts['title']; ?>"
        data-id="<?php echo @$atts['name']; ?>" placeholder="<?php echo @$atts['placeholder']; ?>"
        maxlength="<?php echo @$atts['length']; ?>"
        <?php if (@$atts['class']) { echo 'class="' . $atts['class'] . '" '; } ?><?php echo @$atts['required'] == "true" ? "required" : ""; ?>
        <?php echo @$atts['confirm'] == "true" ? "confirm" : ""; ?>
        <?php echo @$atts['from_name'] == "true" ? "data-from-name" : ""; ?>
        <?php echo @$atts['from_email'] == "true" ? "data-from-email" : ""; ?>>
</div><?php
}

if (@$atts['use'] == "number") {
    ?><div class="opeform-item">
    <input type="<?php echo @$atts['use']; ?>" data-item-name="<?php echo @$atts['title']; ?>"
        data-id="<?php echo @$atts['name']; ?>" placeholder="<?php echo @$atts['placeholder']; ?>"
        maxlength="<?php echo @$atts['length']; ?>" min="<?php echo @$atts['min']; ?>"
        max="<?php echo @$atts['max']; ?>" step="<?php echo @$atts['step']; ?>"
        <?php if (@$atts['class']) { echo 'class="' . $atts['class'] . '" '; } ?><?php echo @$atts['required'] == "true" ? "required" : ""; ?>>
</div><?php
}


if (@$atts['use'] == "zipcode") {
    ?><div class="opeform-item">
    <input type="text" data-item-name="<?php echo @$atts['title']; ?>" data-id="<?php echo @$atts['name']; ?>"
        placeholder="<?php echo @$atts['placeholder']; ?>" maxlength="<?php echo @$atts['length']; ?>"
        min="<?php echo @$atts['min']; ?>" max="<?php echo @$atts['max']; ?>" step="<?php echo @$atts['step']; ?>"
        class="p-postal-code <?php echo @$atts['class'] ?? ''; ?>"
        <?php echo @$atts['required'] == "true" ? "required" : ""; ?>>
</div><?php
}

    // textarea
    if (@$atts['use'] == "textarea") {
        ?><div class="opeform-item">
    <textarea data-item-name="<?php echo @$atts['title']; ?>" data-id="<?php echo @$atts['name']; ?>"
        placeholder="<?php echo @$atts['placeholder']; ?>" maxlength="<?php echo @$atts['length']; ?>"
        class="<?php echo @$atts['class'] ?? ''; ?>" <?php echo @$atts['required'] == "true" ? "required" : ""; ?>>
            </textarea>
    <?php if (@$atts['length']) { ?>
    <div class="text-remaining">
        <span class="r">0</span>/<span class="total"></span>
    </div>
    <?php } ?>
</div>
<?php
    }
    
    // checkbox
    if (@$atts['use'] == "checkbox") {
        ?>
<div class="opeform-item has-checkbox" data-quantity="<?php echo @$atts['quantity'] ?: 100; ?>"
    <?php echo @$atts['class'] ? 'class="' . @$atts['class'] . '" ' : ''; ?>
    <?php echo @$atts['required'] == "true" ? "required" : ""; ?>>

    <?php
            if (@$atts['option']) {
                $arr = explode(",", $atts['option']);
                foreach ($arr as $a) {
                    $a_array = explode("|", $a);
                    $custom_email = !empty($a_array[1]) ? base64_encode(opeEncrypDecrypt::encrypt($a_array[1])) : '';
                    $a = $a_array[0];
                    ?>
    <label>
        <input type="checkbox" <?php echo $custom_email ? 'data-custom-receiver="' . $custom_email . '"' : ''; ?>
            data-item-name="<?php echo @$atts['title']; ?>" data-id="<?php echo @$atts['name']; ?>"
            value="<?php echo $a; ?>">
        <i class="icon"></i><span><?php echo $a; ?></span>
    </label>
    <?php
                }
            }
    
            if (@$atts['hasother']) {
                $hasother_array = explode("|", @$atts['hasother']);
                $custom_email = !empty($hasother_array[1]) ? base64_encode(opeEncrypDecrypt::encrypt($hasother_array[1])) : '';
                $has_other = !empty($hasother_array[0]) ? explode(",", $hasother_array[0]) : [];
    
                ?>
    <label class="is-other-item">
        <input type="checkbox" <?php echo $custom_email ? 'data-custom-receiver="' . $custom_email . '"' : ''; ?>
            data-item-name="<?php echo @$atts['title']; ?>" data-id="<?php echo @$atts['name']; ?>"
            value="<?php echo trim($has_other[0] ?? ''); ?>" is-other-checkbox>
        <i class="icon"></i><span><?php echo trim($has_other[0] ?? ''); ?></span>
    </label>

    <label class="other-field">
        <input type="text" data-item-name="<?php echo @$atts['title']; ?> Other Text"
            data-id="<?php echo @$atts['name']; ?>_other_text"
            <?php echo ($has_other[1] === 'required' || $has_other[1] === 'require') ? 'other_required' : ''; ?>
            <?php echo !empty($has_other[2]) ? ' placeholder="' . trim($has_other[2]) . '" ' : ''; ?> value=""
            is-other-field>
    </label>
    <?php
            }
            ?>
</div>
<?php
    }
    
// radio
if (@$atts['use'] == "radio") {
    ?>
<div class="opeform-item has-radiobox" <?php echo @$atts['required'] == "true" ? "required" : ""; ?>>

    <?php
        if (@$atts['option']) {
            $arr = explode(",", $atts['option']);
            $radio_i = 1;

            foreach ($arr as $a) {
                $a_array = explode("|", $a);
                $custom_email = !empty($a_array[1]) ? base64_encode(opeEncrypDecrypt::encrypt($a_array[1])) : '';
                $a = $a_array[0];
                ?>
    <label>
        <input type="radio" <?php echo @$atts['class'] ? 'class="' . @$atts['class'] . '" ' : ''; ?>
            <?php echo ($radio_i == 1) ? 'checked="checked"' : ''; ?> data-item-name="<?php echo @$atts['title']; ?>"
            <?php echo $custom_email ? 'data-custom-receiver="' . $custom_email . '"' : ''; ?>
            data-id="<?php echo @$atts['name']; ?>" value="<?php echo $a; ?>">
        <i class="icon"></i><span><?php echo $a; ?></span>
    </label>
    <?php
                $radio_i++;
            }
        }
        ?>
</div>
<?php
}

// select
if (@$atts['use'] == "select") {
    ?>
<div class="opeform-item has-select" <?php echo @$atts['required'] == "true" ? "required" : ""; ?>>
    <div class="select">
        <div class="selected-text"></div>
        <input type="hidden" data-item-name="<?php echo @$atts['title']; ?>"
            <?php echo @$atts['class'] ? 'class="' . @$atts['class'] . '" ' : ''; ?>
            data-id="<?php echo @$atts['name']; ?>">

        <div class="select-wrapper">
            <?php if (@$atts['required'] != "true") { ?>
            <div data-value="">-</div>
            <?php }

                if (isset($atts['option'])) {
                    if (!@$atts['dynamic-number-range']) {
                        $arr = explode(",", $atts['option']);
                        foreach ($arr as $a) {
                            $a_array = explode("|", $a);
                            $custom_email = !empty($a_array[1]) ? base64_encode(opeEncrypDecrypt::encrypt($a_array[1])) : '';
                            $a = $a_array[0];
                            ?>
            <div data-value="<?php echo $a; ?>"
                <?php echo $custom_email ? 'data-custom-receiver="' . $custom_email . '"' : ''; ?>>
                <?php echo $a; ?>
            </div>
            <?php
                        }
                    } else {
                        // Handle dynamic range
                        $range = preg_replace('/\s+/', '', @$atts['dynamic-number-range']);
                        list($start_num, $end_num) = explode('~', $range);

                        // Helper function to resolve "nowYear" and calculate the numbers
                        function resolveYear($value) {
                            if (strpos($value, 'nowYear') !== false) {
                                if (strpos($value, '-') !== false) {
                                    $parts = explode('-', $value);
                                    return (int) date('Y') - (int) $parts[1];
                                } elseif (strpos($value, '+') !== false) {
                                    $parts = explode('+', $value);
                                    return (int) date('Y') + (int) $parts[1];
                                } else {
                                    return (int) date('Y');
                                }
                            }
                            return (int) $value;
                        }

                        $start_num = resolveYear($start_num);
                        $end_num = resolveYear($end_num);

                        if ($start_num <= $end_num) {
                            for ($i = $start_num; $i <= $end_num; $i++) {
                                ?>
            <div data-value="<?php echo $i; ?>"><?php echo $i; ?></div>
            <?php
                            }
                        } else {
                            for ($i = $start_num; $i >= $end_num; $i--) {
                                ?>
            <div data-value="<?php echo $i; ?>"><?php echo $i; ?></div>
            <?php
                            }
                        }

                        // If range is empty, display current year or static value
                        if (empty($start_num) && empty($end_num)) {
                            $display_value = strpos($range, 'nowYear') !== false ? (int) date('Y') : $range;
                            ?>
            <div data-value="<?php echo $display_value; ?>"><?php echo $display_value; ?></div>
            <?php
                        }
                    }
                }
                ?>
        </div>
    </div>
</div>
<?php
}

    // submit
    if (@$atts['use'] == "submit") {
        ?>
<div class="opeform-item">
    <div class="opeform-submit" <?php echo @$atts['class'] ? 'class="' . @$atts['class'] . '" ' : ''; ?>
        data-action="confirm">
        <span>
            <?php 
                    echo @$ope_form_panel_config->button_next 
                        ? @$ope_form_panel_config->button_next 
                        : "Next"; 
                    ?>
        </span>
    </div>
    <input type="hidden" name="ope_form_token" value="">

    <?php
            if (@$ope_form_panel_config->google_recaptcha_v3 == 'on') {
                ?>
    <input type="hidden" name="g-recaptcha-response" value="" id="g-recaptcha-response">
    <?php
            }
            ?>
</div>
<?php
    }
    
    // verification
    if (@$atts['use'] == "verification") {
        // Generate unique ID for verification input
        $unique_id = uniqid();
        ?>
<div class="opeform-item">
    <div class="opeform-verification">
        <!-- Verification Input Field -->
        <input type="text" <?php echo @$atts['class'] ? 'class="' . @$atts['class'] . '" ' : ''; ?> required
            maxlength="8" data-id="<?php echo $unique_id; ?>">

        <div class="opeform-verification-wrapper">
            <!-- Verification Graph -->
            <div class="verification-graph" data-string="<?php echo $unique_id; ?>"></div>

            <!-- Notice Text -->
            <i><em><?php echo @$atts['notice']; ?></em></i>
        </div>
    </div>
</div>
<?php
    }    
    return ob_get_clean();
}

function opeform_admin_email_address_function($atts, $content)
{
    ob_start();
    $content = do_shortcode($content);
    $encrypted = opeEncrypDecrypt::encrypt($content);
    echo '<div data-opeform-admin-email-address="' . base64_encode($encrypted) . '"></div>';
    return ob_get_clean();
}

function opeform_admin_email_subject_function($atts, $content)
{
    ob_start();
    $content = do_shortcode($content);
    $encrypted = opeEncrypDecrypt::encrypt($content);
    echo '<div data-opeform-admin-email-subject="' . base64_encode($encrypted) . '"></div>';
    return ob_get_clean();
}

function opeform_reply_email_subject_function($atts, $content)
{
    ob_start();
    $content = do_shortcode($content);
    $encrypted = opeEncrypDecrypt::encrypt($content);
    echo '<div data-opeform-reply-email-subject="' . base64_encode($encrypted) . '"></div>';
    return ob_get_clean();
}

function opeform_admin_email_top_function($atts, $content)
{
    ob_start();
    $content = do_shortcode($content);
    $encrypted = opeEncrypDecrypt::encrypt($content);
    echo '<div data-opeform-admin-email-top="' . base64_encode($encrypted) . '"></div>';
    return ob_get_clean();
}

function opeform_autoreply_email_top_function($atts, $content)
{
    ob_start();
    $content = do_shortcode($content);
    $encrypted = opeEncrypDecrypt::encrypt($content);
    echo '<div data-opeform-autoreply-email-top="' . base64_encode($encrypted) . '"></div>';
    return ob_get_clean();
}

function opeform_autoreply_email_bottom_function($atts, $content)
{
    ob_start();
    $content = do_shortcode($content);
    $encrypted = opeEncrypDecrypt::encrypt($content);
    echo '<div data-opeform-autoreply-email-bottom="' . base64_encode($encrypted) . '"></div>';
    return ob_get_clean();
}
function opeform_thanks_page_function()
{
    ob_start();
    $post_data = json_decode(file_get_contents('php://input'), true);
    $thanks_page_check = isset($post_data['thanks_page_check']) ? sanitize_text_field($post_data['thanks_page_check']) : null;

    if ($thanks_page_check === 'ope') {
        wp_send_json_success(['message' => 'Thanks page verified.']);
    }

    if(!session_id()){
        session_start();
    }    

    $thanks_token = $_SESSION['thanks_token']??null;
    if(!$thanks_token && !(is_admin() && current_user_can('administrator'))){
        header('Location:'.home_url());
    }else{
        unset($_SESSION['thanks_token']);
    }
    session_write_close();
    return ob_get_clean();
}

add_action('init', function () {
    add_shortcode('opeform', 'opeform_function');
    add_shortcode('opeform_admin_email_address', 'opeform_admin_email_address_function');
    add_shortcode('opeform_admin_email_subject', 'opeform_admin_email_subject_function');
    add_shortcode('opeform_reply_email_subject', 'opeform_reply_email_subject_function');
    add_shortcode('opeform_admin_email_top', 'opeform_admin_email_top_function');
    add_shortcode('opeform_autoreply_email_top', 'opeform_autoreply_email_top_function');
    add_shortcode('opeform_autoreply_email_bottom', 'opeform_autoreply_email_bottom_function');
    add_shortcode('opeform_thanks_page', 'opeform_thanks_page_function');
});

function ope_form_enqueue_styles()
{
    wp_register_style('ope-form-main', get_template_directory_uri() . '/pack/contact-form/assets/css/style.css', array(), crc32(date("YmdH")), 'all');
}
add_action('wp_enqueue_scripts', 'ope_form_enqueue_styles', 1);

function ope_form_enqueue()
{
    global $ope_form_panel_config;
    if (@$ope_form_panel_config->google_recaptcha_v3 == 'on') {
        wp_register_script('google_recaptcha_v3', 'https://www.google.com/recaptcha/api.js?render=' . @$ope_form_panel_config->google_recaptcha_v3_site_key, array(), null, false);
    }
    wp_register_script('ope-form-module', get_template_directory_uri() . '/pack/contact-form/assets/js/module.js', array('jquery'), crc32(date("YmdH")), true);
    wp_register_script('ope-form-script', get_template_directory_uri() . '/pack/contact-form/assets/js/script.js', array('jquery'),
        crc32(date("YmdH")), true);
        wp_localize_script('ope-form-script', 'ope_form_object', array(
            'ajaxurl' => admin_url('admin-ajax.php'),
            'form_nonce' => wp_create_nonce('ope_form_nonce'),
            'prev_btn_text' => isset($ope_form_panel_config->button_prev) ? $ope_form_panel_config->button_prev : '',
            'send_btn_text' => isset($ope_form_panel_config->button_send) ? $ope_form_panel_config->button_send : '',
            'invalid_email' => isset($ope_form_panel_config->invalid_email) ? $ope_form_panel_config->invalid_email : '',
            'invalid_phone' => isset($ope_form_panel_config->invalid_phone) ? $ope_form_panel_config->invalid_phone : '',
            'email_not_matched' => isset($ope_form_panel_config->email_not_matched) ? $ope_form_panel_config->email_not_matched : '',
            'required' => isset($ope_form_panel_config->required_item) ? $ope_form_panel_config->required_item : '',
            'required_other' => isset($ope_form_panel_config->required_item_other) ? $ope_form_panel_config->required_item_other : '',
            'error' => isset($ope_form_panel_config->error) ? $ope_form_panel_config->error : '',
            'verification_failed' => isset($ope_form_panel_config->validate_code_not_mateched) ? $ope_form_panel_config->validate_code_not_mateched : '',
            'return_btn_text' => isset($ope_form_panel_config->return) ? $ope_form_panel_config->return : '',
            'check_immediately' => isset($ope_form_panel_config->fields_check) ? $ope_form_panel_config->fields_check : '',
            'auto_return' => isset($ope_form_panel_config->automatice_return) ? $ope_form_panel_config->automatice_return : '',
            'auto_return_timeleft' => isset($ope_form_panel_config->waiting_time) ? $ope_form_panel_config->waiting_time : '',
            'send_failed' => isset($ope_form_panel_config->send_failed) ? $ope_form_panel_config->send_failed : '',
            'name_format' => isset($ope_form_panel_config->name_format) ? $ope_form_panel_config->name_format : '',
            'fileTooBig' => isset($ope_form_panel_config->file_too_large) ? $ope_form_panel_config->file_too_large : '',
            'fileTypeError' => isset($ope_form_panel_config->file_type_error) ? $ope_form_panel_config->file_type_error : '',
            'auth_error' => isset($ope_form_panel_config->auth_failed) ? $ope_form_panel_config->auth_failed : '',
            'invalid_string' => isset($ope_form_panel_config->illegal_string) ? $ope_form_panel_config->illegal_string : '',
            'select_image_and_crop' => isset($ope_form_panel_config->select_image_and_crop) ? $ope_form_panel_config->select_image_and_crop : '',
            'image_crop_text' => isset($ope_form_panel_config->image_crop) ? $ope_form_panel_config->image_crop : '',
            'image_crop_text_cancel' => isset($ope_form_panel_config->cancel_crop) ? $ope_form_panel_config->cancel_crop : '',
            'crop_image_width' => isset($ope_form_panel_config->image_crop_width) ? $ope_form_panel_config->image_crop_width : '',
            'crop_image_height' => isset($ope_form_panel_config->image_crop_height) ? $ope_form_panel_config->image_crop_height : '',
            'not_a_image' => isset($ope_form_panel_config->image_type_error) ? $ope_form_panel_config->image_type_error : '',
            'not_large_enough' => isset($ope_form_panel_config->image_too_small) && isset($ope_form_panel_config->image_width) && isset($ope_form_panel_config->image_crop_width) && isset($ope_form_panel_config->image_height) && isset($ope_form_panel_config->image_crop_height)
                ? $ope_form_panel_config->image_too_small . PHP_EOL . $ope_form_panel_config->image_width . 'px>=W>=' . $ope_form_panel_config->image_crop_width . 'px' . PHP_EOL . $ope_form_panel_config->image_height . 'px>=H>=' . $ope_form_panel_config->image_crop_height . "px"
                : '',
            'image_max_width' => isset($ope_form_panel_config->image_width) ? $ope_form_panel_config->image_width : '',
            'image_max_height' => isset($ope_form_panel_config->image_height) ? $ope_form_panel_config->image_height : '',
            'too_large' => isset($ope_form_panel_config->image_too_large) && isset($ope_form_panel_config->image_width) && isset($ope_form_panel_config->image_crop_width) && isset($ope_form_panel_config->image_height) && isset($ope_form_panel_config->image_crop_height)
                ? $ope_form_panel_config->image_too_large . PHP_EOL . $ope_form_panel_config->image_width . 'px>=W>=' . $ope_form_panel_config->image_crop_width . 'px' . PHP_EOL . $ope_form_panel_config->image_height . 'px>=H>=' . $ope_form_panel_config->image_crop_height . "px"
                : '',
            'google_recaptcha_v3_site_key' => isset($ope_form_panel_config->google_recaptcha_v3_site_key) ? $ope_form_panel_config->google_recaptcha_v3_site_key : '',
            'back_to_url' => isset($ope_form_panel_config->back_to_url) ? $ope_form_panel_config->back_to_url : '',
            'text_issue_load_capcha' => __('There was an issue with loading the CAPTCHA code. Please try again.','ope-form-pack'),
            'text_failed_get_token' => __('Failed to get token. Please try again.','ope-form-pack'),
            'text_invalid_token' => __('Invalid token response from the server.','ope-form-pack'),
            'text_error_occurred' => __('An error occurred. Please try again.','ope-form-pack'),
            'text_failed_process' => __('Failed to process the server response.','ope-form-pack'),
            'text_error_occurred_request' => __('An error occurred during the request. Please try again later.','ope-form-pack'),
            'text_image_crop_size_not_set' => __('Image crop size not set in configuration.','ope-form-pack'),
            'text_thanks_page_config_error' => __('Thanks page configuration error.','ope-form-pack'),
        ));
}
add_action('wp_enqueue_scripts', 'ope_form_enqueue', 9);

function ope_form_enqueue_yubinbango()
{
    global $ope_form_panel_config;
    wp_register_script('ope-form-autofill-zipcode-jp', 'https://yubinbango.github.io/yubinbango/yubinbango.js', array('jquery'), crc32(date("YmdH")), true);
}
if (@$ope_form_panel_config->jp_address_auto_fill == "on") {
    add_action('wp_enqueue_scripts', 'ope_form_enqueue_yubinbango', 100);
}
function ope_form_footer_script()
{
    global $ope_form_panel_config;
    echo PHP_EOL;
    ?>
<script id="ope-form-add-autofill-zipcode-function">
let form = document.querySelectorAll(".ope-form");
if (form) {
    form.forEach(element => {
        if (element.dataset.confirmPageText == undefined) {
            element.dataset.confirmPageText = '<?php echo @$ope_form_panel_config->confirm_page_top; ?>';
        }
        if (element.dataset.thanksPageText == undefined) {
            element.dataset.thanksPageText = '<?php echo @$ope_form_panel_config->thanks_page_text; ?>';
        }
        if (element.dataset.formCategory == undefined) {
            element.dataset.formCategory = 'undefined category';
        }
    });
}
<?php
if (@$ope_form_panel_config->jp_address_auto_fill == 'on') {
        ?>
if (form) {
    form.forEach(element => {
        element.classList.add("h-adr");
        element.insertAdjacentHTML("afterbegin",
            "<span class=\"p-country-name\" style=\"display:none;\">Japan</span>");
    });
}
<?php }?>
</script>
<?php
}

add_action('wp_footer', 'ope_form_footer_script', 1);

function ope_form_br2nl($text)
{
    if (!empty($text)) {
        $breaks = array("<br />", "<br>", "<br/>");
        $text = str_ireplace($breaks, "\r\n", $text);
    }
    return $text;
}

if (@$ope_form_panel_config->google_recaptcha_v3_badge == 'hide') {
    add_filter('body_class', function ($classes) {
        return array_merge($classes, array('hide-google-recaptcha-badge'));
    });
}

function checkOpeFormErrorLogPath()
{
    global $ope_form_panel_config;
    $year = date("Y");
    $month = date("m");
    if (!is_dir(ABSPATH . @$ope_form_panel_config->file_upload_folder_name . "/Errorlogs" . "/" . $year . "/" . $month)) {
        mkdir(ABSPATH . @$ope_form_panel_config->file_upload_folder_name . "/Errorlogs", 0755);
        mkdir(ABSPATH . @$ope_form_panel_config->file_upload_folder_name . "/Errorlogs" . "/" . $year, 0755);
        mkdir(ABSPATH . @$ope_form_panel_config->file_upload_folder_name . "/Errorlogs" . "/" . $year . "/" . $month, 0755);
    }
}