(function ($) {
    function checkItems() {
        $("#check_all_2,#check_all_1").on("change", function () {
            const $this = $(this);
            if ($this.prop("checked") === true) {
                $(".ope-form-mail-list input").prop("checked", true);
            } else {
                $(".ope-form-mail-list input").prop("checked", false);
            }
            if ($(".ope-form-mail-list input:not([id^='check_all_']):checked").length > 0) {
                $('[data-action="del_mail"],[data-action="export_selected"],[data-action="del_cat"]').addClass("show");
            } else {
                $('[data-action="del_mail"],[data-action="export_selected"],[data-action="del_cat"]').removeClass("show");
            }
        });
        $(".ope-form-mail-list input:not([id^='check_all_'])").on("change", function () {
            const $this = $(this);
            if ($this.prop("checked") === true) {

            } else {
                $("#check_all_2,#check_all_1").prop("checked", false);
            }
            if ($(".ope-form-mail-list input:not([id^='check_all_']):checked").length > 0) {
                $('[data-action="del_mail"],[data-action="export_selected"],[data-action="del_cat"]').addClass("show");
            } else {
                $('[data-action="del_mail"],[data-action="export_selected"],[data-action="del_cat"]').removeClass("show");
            }
        });
    }
    async function ajaxDelMail($ids) {
        let url = ope_form_list_object.ajaxurl,
            secureNonce = ope_form_list_object.form_nonce_list;

        let data = {
            s: secureNonce,
            action: "delEmail",
            ids: $ids
        };
        const response = await fetch(url, {
            method: "POST",
            mode: "same-origin",
            cache: "no-cache",
            redirect: "follow",
            referrerPolicy: "same-origin",
            headers: {
                "Content-Type": "application/x-www-form-urlencoded",
                "Cache-Control": "no-cache",
            },
            credentials: "same-origin",
            body: new URLSearchParams(data),
        });
        const jsonData = await response.json();
        if (jsonData) {
            console.log(jsonData);
            if (jsonData.status == "success") {
                alert(ope_form_list_object.success);
                location.reload();
            } else {
                alert(ope_form_list_object.faild_and_try);
            }
            $('[data-action="del_mail"]').removeClass("hold");
        }
    }
    function delMail() {
        $('[data-action="del_mail"]').on("click", function () {
            if ($(".ope-form-mail-list input:not([id^='check_all_']):checked").length > 0) {
                let $ids = [];
                $(".ope-form-mail-list input:not([id^='check_all_']):checked").each(function () {
                    $ids.push($(this).val());
                });
                let $confirm = confirm(ope_form_list_object.text_really_delete);
                if ($confirm === true) {
                    $('[data-action="del_mail"]').addClass("hold");
                    ajaxDelMail($ids);
                }
            } else {
                alert(ope_form_list_object.item_select_required);
            }
        });
    }
    const generateRandomString = (length) => {
        let result = '';
        const characters =
            'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
        const charactersLength = characters.length;
        for (let i = 0; i < length; i++) {
            result += characters.charAt(Math.floor(Math.random() * charactersLength));
        }
        return result;
    };
    const opeFormYMDHis = () => {
        var currentdate = new Date();
        var datetime = currentdate.getFullYear() + "-"
            + (currentdate.getMonth() + 1) + "-"
            + currentdate.getDate() + "-"
            + currentdate.getHours() + "-"
            + currentdate.getMinutes() + "-"
            + currentdate.getSeconds();
        return datetime;
    }
    const ajaxExportSelectedMail = ($ids) => {
        let url = ope_form_list_object.ajaxurl,
            secureNonce = ope_form_list_object.form_nonce_list;
        let $data = {
            s: secureNonce,
            action: "export_selected_mail",
            ids: $ids
        };
        $.ajax({
            url: url,
            method: 'POST',
            data: $data,
            success: function (data) {
                let $name = '';
                if ($ids.length > 1) {
                    $name = 'mail-data-selected-' + opeFormYMDHis() + '-' + generateRandomString(4);
                    const wb = XLSX.utils.book_new();
                    /* Sheet data */
                    const sheetData = data.data;
                    sheetData.forEach((mail, index) => {
                        let $data_array = [];
                        $(mail).each(function () {
                            let $cell = [];
                            let $this = $(this);
                            if ($this[0].value.length >= 32767) {
                                return;
                            }
                            $cell.push($this[0].key);
                            $cell.push($this[0].value);
                            $data_array.push($cell);
                        });

                        let $form_data = XLSX.utils.aoa_to_sheet($data_array);
                        XLSX.utils.book_append_sheet(wb, $form_data, "Sheet-" + (index + 1));
                        $form_data = $data_array = [];
                    });
                    /* Sheet data end */
                    XLSX.writeFile(wb, $name + '.xlsx');
                    $('[data-action="export_selected"]').removeClass("hold");
                } else {
                    let $mid = $ids;
                    let $user_name = $('.ope-form-mail-list table td:first-child input[value="' + $mid + '"]').parents("tr").find("td:nth-child(2)").text().trim();
                    let $user_email = $('.ope-form-mail-list table td:first-child input[value="' + $mid + '"]').parents("tr").find("td:nth-child(3)").text().trim();
                    $name = $user_name + "-" + $user_email + "-" + opeFormYMDHis() + '-' + generateRandomString(4) + ".xls";
                    data = data.data;
                    data = data.replace(/&lt;/g, "<");
                    data = data.replace(/&gt;/g, ">");
                    data = data.replace(/&quot;/g, '"');
                    data = data.replace(/&#39;/g, "'");
                    data = data.replace(/&amp;/g, "&");
                    var $body =
                        '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--><style>table{border-spacing:10px;}td {font-size:14px;font-family: "Microsoft Yahei","Meiryo",Verdana, Geneva, Tahoma, sans-serif;border-spacing:10px;text-align:left;}.head{background-color: #2465b2;color:#ffffff;width:200px;text-align:center; } </style></head><body>' +
                        data +
                        "</body></html>";
                    var result =
                        "data:application/vnd.ms-excel," + encodeURIComponent($body);
                    var link = document.createElement("a");
                    document.body.appendChild(link);
                    link.download = $name;
                    link.href = result;
                    link.click();
                    $('[data-action="export_selected"],.export-current-mail-data').removeClass("hold");
                }
            }
        });
    }
    const ajaxExportAllMail = () => {
        let url = ope_form_list_object.ajaxurl,
            secureNonce = ope_form_list_object.form_nonce_list;
        let $data = {
            s: secureNonce,
            action: "export_all_mail",
        };
        $.ajax({
            url: url,
            method: 'POST',
            data: $data,
            success: function (data) {
                let $name = 'mail-data-all-' + opeFormYMDHis() + '-' + generateRandomString(4);
                const wb = XLSX.utils.book_new();
                /* Sheet data */
                const sheetData = data.data;
                sheetData.forEach((mail, index) => {
                    let $data_array = [];
                    $(mail).each(function () {
                        let $cell = [];
                        let $this = $(this);
                        if ($this[0].value.length >= 32767) {
                            return;
                        }
                        $cell.push($this[0].key);
                        $value_data = $this[0].value;
                        $value_data = $value_data.replace(/&lt;/g, "<");
                        $value_data = $value_data.replace(/&gt;/g, ">");
                        $value_data = $value_data.replace(/&quot;/g, '"');
                        $value_data = $value_data.replace(/&#39;/g, "'");
                        $value_data = $value_data.replace(/&amp;/g, "&");
                        $cell.push($value_data);
                        $data_array.push($cell);
                    });

                    let $form_data = XLSX.utils.aoa_to_sheet($data_array);
                    XLSX.utils.book_append_sheet(wb, $form_data, "Sheet-" + (index + 1));
                    $form_data = $data_array = [];
                });
                /* Sheet data end */
                XLSX.writeFile(wb, $name + '.xlsx');
                $('[data-action="export_all"]').removeClass("hold");
            }
        });
    }
    function exportSelected() {
        $('[data-action="export_selected"]').on("click", function () {
            if ($(".ope-form-mail-list input:not([id^='check_all_']):checked").length > 0) {
                let $ids = [];
                $(".ope-form-mail-list input:not([id^='check_all_']):checked").each(function () {
                    $ids.push($(this).val());
                });
                $('[data-action="export_selected"]').addClass("hold");
                let $confirm = confirm(ope_form_list_object.export_selected_note);
                if ($confirm == true) {
                    ajaxExportSelectedMail($ids);
                }
            } else {
                alert(ope_form_list_object.item_select_required);
            }
        });
    }
    function exportAll() {
        $('[data-action="export_all"]').on("click", function () {
            let $confirm = confirm(ope_form_list_object.export_all_note);
            if ($confirm == true) {
                $('[data-action="export_all"]').addClass("hold");
                ajaxExportAllMail();
            }
        });
    }

    const canDownloadFiles = () => {
        $('[data-file-download]').off().on("click", function () {
            let $this = $(this);

            // Prevent multiple clicks while in progress
            if ($this.hasClass("hold")) {
                return;
            }

            // Add 'hold' class to prevent multiple downloads
            $this.addClass("hold");

            let file_name = $this.attr("data-file-name"),
                url = ope_form_list_object.ajaxurl,
                secureNonce = ope_form_list_object.form_nonce_list,
                file = $this.attr("data-file-download");

            let $data = {
                s: secureNonce,
                action: "download_attachment_file",
                file: file
            };

            $.ajax({
                url: url,
                method: 'POST',
                data: $data,
                success: function (data) {
                    if (data.success) {
                        // Dynamically create an anchor tag to trigger download
                        let link = document.createElement('a');
                        link.href = data.data.file_url;
                        link.download = file_name;
                        document.body.appendChild(link);
                        link.click();
                        document.body.removeChild(link);
                    } else {
                        console.error("Download failed: " + data.data.message);
                    }
                },
                error: function () {
                    console.error("An error occurred while processing the request.");
                },
                complete: function () {
                    // Remove 'hold' class after the request is complete
                    $this.removeClass("hold");
                }
            });
        });
    };

    const canDownloadImages = () => {
        $('[data-img-download]').off().on("click", function () {
            let $this = $(this);

            let file_name = $this.attr("data-img-name"),
                file = $this.attr("data-img-download");

            let link = document.createElement('a');
            link.href = file;
            link.download = file_name;
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        });
    };



    const showEmailDetails = ($id) => {
        $(".ope-form-mail-list").addClass("hold");
        $(".ope-form-email-detail-wrapper").addClass("show");
        let url = ope_form_list_object.ajaxurl,
            secureNonce = ope_form_list_object.form_nonce_list;
        let $data = {
            s: secureNonce,
            action: "get_email_details",
            id: $id
        };
        $.ajax({
            url: url,
            method: 'POST',
            data: $data,
            success: function (data) {
                let $message = data.message;
                let $files = data.attachment_files;
                let $images = data.attachment_images;
                let $http_data = data.http_data;
                let $mail_id = data.mail_id;
                if ($message.length > 0) {
                    $(".ope-form-email-detail-head").html('<div class="mail_details_head"><span>' + ope_form_list_object.record_id_text + $mail_id + '</span><div class="export-current-mail-data" data-current-mail-id="' + $mail_id + '">' + ope_form_list_object.export + '</div></div>');
                    $html = '';
                    $html += '<table>';
                    $($message).each(function () {
                        let $this = $(this);
                        $html += '<tr>';
                        $html += '<td>';
                        $html += $this[0].key;
                        $html += '</td>';
                        $html += '<td>';
                        $html += $this[0].value.replace(/(?:\r\n|\r|\n)/g, '<br>');
                        $html += '</td>';
                        $html += '</tr>';
                    });
                    $html += '</table>';
                    $(".ope-form-email-detail-wrapper .ope-form-email-detail").html($html);
                }
                if ($files.length > 0) {
                    $html = '<h3>' + ope_form_list_object.text_attachment_file + '</h3>';
                    $html += '<ul>';
                    $($files).each(function () {
                        let $this = $(this);
                        let $file_name = $this[0].name + '-' + $this[0].original_name;
                        $html += '<li class="attachment_file">';
                        $html += '<a data-file-name="' + $file_name + '" data-file-download="' + $this[0].url + '">';
                        $html += $this[0].name;
                        $html += '</a>';
                        $html += '</li>';
                    });
                    $html += '</ul>';
                    $(".ope-form-email-detail-wrapper .ope-form-email-detail").append($html);
                    canDownloadFiles();
                }
                if ($images.length > 0) {
                    $html = '<h3>' + ope_form_list_object.text_attachment_images + '</h3>';
                    $html += '<ul>';
                    $($images).each(function () {
                        let $this = $(this);
                        let $file_name = $this[0].original_name;
                        $html += '<li class="attachment_image">';
                        $html += '<a data-img-name="' + $file_name + '" data-img-download="' + ope_form_list_object.homeurl + '/' + $this[0].url + '">';
                        $html += '<img src="' + ope_form_list_object.homeurl + '/' + $this[0].url + '">';
                        $html += '</a>';
                        $html += '</li>';
                    });
                    $html += '</ul>';
                    $(".ope-form-email-detail-wrapper .ope-form-email-detail").append($html);
                    canDownloadImages();
                }
                if ($http_data) {
                    $html = '<h3>' + ope_form_list_object.text_http_data + '</h3>';
                    $html += '<table>';
                    for (const [key, value] of Object.entries($http_data)) {
                        $html += '<tr>';
                        $html += '<td>';
                        $html += `${key}`;
                        $html += '</td>';
                        $html += '<td>';
                        $html += `${value}`;
                        $html += '</td>';
                        $html += '</tr>';
                    }
                    $html += '</table>';
                    $(".ope-form-email-detail-wrapper .ope-form-email-detail").append($html);
                }
                $(".export-current-mail-data").off().on("click", function () {
                    let $ids = [$(this).data("current-mail-id")];
                    $(this).addClass("hold");
                    let $confirm = confirm(ope_form_list_object.export_selected_note);
                    if ($confirm == true) {
                        ajaxExportSelectedMail($ids);
                    }
                });
            }
        });
    }
    function getEmailDetails() {
        if ($('.ope-form-mail-list-wrapper[data-area="email-list"]').length > 0) {
            if (navigator.userAgent.indexOf('Mac OS X') != -1) {
                $("body").addClass("mac");
            } else {
                $("body").addClass("pc");
            }
            if ($("body").find(".ope-form-email-detail-wrapper").length <= 0) {
                $("body").append('<div class="ope-form-email-detail-wrapper"><div class="close-ope-form-email-details"></div><div class="ope-form-email-detail-head"></div><div class="ope-form-email-detail-content"><div class="ope-form-email-detail"></div><div class="click-to-close-area"></div></div></div>');
                $(".close-ope-form-email-details,.ope-form-email-detail-wrapper .click-to-close-area").on("click", function () {
                    $(".ope-form-email-detail-wrapper").removeClass("show").find(".ope-form-email-detail").html('');
                    $(".ope-form-mail-list").removeClass("hold");
                });
            }
            $('[data-area="email-list"] [data-row-id] td:not(:first-child)').off().on("click", function () {
                const $mail_id = $(this).parent("tr").data("row-id");
                if ($mail_id) {
                    showEmailDetails($mail_id);
                }
            });
        }
    }
    async function ajaxDelCat($ids) {
        let url = ope_form_list_object.ajaxurl,
            secureNonce = ope_form_list_object.form_nonce_list;

        let data = {
            s: secureNonce,
            action: "delCat",
            ids: $ids
        };
        console.log($ids);
        const response = await fetch(url, {
            method: "POST",
            mode: "same-origin",
            cache: "no-cache",
            redirect: "follow",
            referrerPolicy: "same-origin",
            headers: {
                "Content-Type": "application/x-www-form-urlencoded",
                "Cache-Control": "no-cache",
            },
            credentials: "same-origin",
            body: new URLSearchParams(data),
        });
        const jsonData = await response.json();
        if (jsonData) {
            console.log(jsonData);
            if (jsonData.status == "success") {
                alert(ope_form_list_object.success);
                location.reload();
            } else {
                alert(ope_form_list_object.faild_and_try);
            }
            $('[data-action="del_cat"]').removeClass("hold");
        }
    }
    function delCat() {
        $('[data-action="del_cat"]').on("click", function () {
            if ($(".ope-form-mail-list input:not([id^='check_all_']):checked").length > 0) {
                let $ids = [];
                $(".ope-form-mail-list input:not([id^='check_all_']):checked").each(function () {
                    $ids.push($(this).val());
                });
                let $confirm = confirm(ope_form_list_object.text_really_delete);
                if ($confirm === true) {
                    $('[data-action="del_cat"]').addClass("hold");
                    ajaxDelCat($ids);
                }
            } else {
                alert(ope_form_list_object.item_select_required);
            }
        });
    }
    $(function () {
        checkItems();
        delMail();
        exportSelected();
        exportAll();
        getEmailDetails();
        delCat();
    });
})(jQuery);