<?php
if (!defined('ABSPATH')) {
    die('Access Denied!');
}
if (current_user_can('administrator')) {
    if (!class_exists("ope_form_list_page")) {
        class ope_form_list_page
        {
            public function add_menu_page()
            {
                global $ope_form_panel_config;
                $post_type_name = @$ope_form_panel_config->post_type_name ? @$ope_form_panel_config->post_type_name : __('Mail Box', 'ope-form-pack');
                $post_type_category = @$ope_form_panel_config->post_type_category ? @$ope_form_panel_config->post_type_category : __('Mail Category', 'ope-form-pack');
                add_menu_page(
                    $post_type_name,
                    $post_type_name,
                    'manage_options',
                    'ope_form_list_settings',
                    array($this, 'ope_form_list'),
                    'dashicons-email',
                    1
                );
                add_submenu_page('ope_form_list_settings', $post_type_category, $post_type_category, 'manage_options', 'ope_form_category_settings', array($this, 'ope_form_category'));
            }
            public function ope_form_category()
            {
                require get_template_directory() . '/pack/contact-form/mailList/ope_form_category.php';
            }
            public function ope_form_list()
            {
                require get_template_directory() . '/pack/contact-form/mailList/ope_form_list.php';
            }
            public function add_page()
            {
                add_action('admin_menu', array($this, 'add_menu_page'));
            }
            public function ope_form_enqueue()
            {
                wp_enqueue_style('ope-form-list-main', get_template_directory_uri() . '/pack/contact-form/mailList/assets/css/ope_form_list.css', array(), crc32(date("YmdH")), 'all');
                wp_enqueue_script('ope-form-list-xls-script', get_template_directory_uri() . '/pack/contact-form/mailList/assets/js/xlsx.mini.min.js', array(), crc32(date("Y")), true);
                wp_enqueue_script('ope-form-list-script', get_template_directory_uri() . '/pack/contact-form/mailList/assets/js/ope_form_list.js', array(), crc32(date("YmdH")), true);
                wp_localize_script('ope-form-list-script', 'ope_form_list_object', array(
                    'text_attachment_file' => __("Attachment Files", "ope-form-pack"),
                    'text_attachment_images' => __("Attachment Images", "ope-form-pack"),
                    'text_http_data' => __("Meta Data", "ope-form-pack"),
                    'homeurl' => get_option('home'),
                    'ajaxurl' => admin_url('admin-ajax.php'),
                    'form_nonce_list' => wp_create_nonce('ope_form_nonce_list'),
                    'text_really_delete' => __("Are You sure to delete the selected records?", "ope-form-pack"),
                    'item_select_required' => __("Please select at least one record.", "ope-form-pack"),
                    'faild_and_try' => __("Failed! Please try again.", "ope-form-pack"),
                    'export' => __("Export", "ope-form-pack"),
                    'success' => __("Success!", "ope-form-pack"),
                    'export_all_note' => __("Export up to 10,000 newest records, and individual fields exceeding 32,767 characters will be skipped.", "ope-form-pack"),
                    'export_selected_note' => __("Individual fields exceeding 32,767 characters will be skipped.", "ope-form-pack"),
                    'record_id_text' => __("Mail ID:", "ope-form-pack"),
                ));
            }

            public function enqueue()
            {
                add_action('admin_enqueue_scripts', array($this, 'ope_form_enqueue'));
            }

            public function delete($ids)
            {
                global $wpdb;
                $result = '';
                $table_name = $wpdb->prefix . 'opeform_mailbox';
                $ids = array_map('intval', explode(",", $ids));
                $ids = implode(",", $ids);
                global $ope_form_panel_config;
                if (@$ope_form_panel_config->remove_attachments_when_delete_email == "on") {
                    $urls = array();
                    $user_attachment_files = $wpdb->get_results("SELECT attachment_files FROM `$table_name` WHERE mail_id IN ($ids)");
                    $user_attachment_images = $wpdb->get_results("SELECT attachment_images FROM `$table_name` WHERE mail_id IN ($ids)");
                    if (!empty($user_attachment_files)) {
                        foreach ($user_attachment_files as $key => $value) {
                            $files = $value->attachment_files;
                            if (!empty($files)) {
                                $files = maybe_unserialize($files);
                                if (!empty($files)) {
                                    foreach ($files as $file) {
                                        array_push($urls, $file['url']);
                                    }
                                }
                            }
                        }
                    }
                    if (!empty($user_attachment_images)) {
                        foreach ($user_attachment_images as $key => $value) {
                            $images = $value->attachment_images;
                            if (!empty($images)) {
                                $images = maybe_unserialize($images);
                                if (!empty($images)) {
                                    foreach ($images as $image) {
                                        array_push($urls, $image['url']);
                                    }
                                }
                            }
                        }
                    }
                    if (!empty($urls)) {
                        foreach ($urls as $url) {
                            $file = ABSPATH . $url;
                            if (!unlink($file)) {
                                //
                            } else {
                                //
                            }
                        }
                    }
                    unset($urls);
                    $result = $wpdb->query("DELETE FROM `$table_name` WHERE mail_id IN ($ids)");
                } else {
                    $result = $wpdb->query("DELETE FROM `$table_name` WHERE mail_id IN ($ids)");
                }
                if (!empty($result)) {
                    return true;
                } else {
                    return false;
                }
            }

            public function deleteCat($ids)
            {
                global $wpdb;
                $table_name = $wpdb->prefix . 'opeform_mailbox_terms';
                $ids = array_map('intval', explode(",", $ids));
                $ids = implode(",", $ids);
                $result = $wpdb->query("DELETE FROM `$table_name` WHERE term_id IN ($ids)");
                if (!empty($result)) {
                    return true;
                } else {
                    return false;
                }
            }

            public function export_selected($ids)
            {
                global $wpdb;
                $table_name = $wpdb->prefix . 'opeform_mailbox';
                $ids = implode(",", $ids);
                $result = $wpdb->get_results("SELECT * FROM `$table_name` WHERE mail_id IN ($ids)");
                return $result;
            }
            public function export_all()
            {
                global $wpdb;
                $table_name = $wpdb->prefix . 'opeform_mailbox';
                $result = $wpdb->get_results("SELECT * FROM `$table_name` ORDER BY mail_id DESC LIMIT 10000");
                return $result;
            }
            public function get_details($id)
            {
                global $wpdb;
                $table_name = $wpdb->prefix . 'opeform_mailbox';
                $result = $wpdb->get_results("SELECT * FROM `$table_name` WHERE mail_id = $id");
                return $result;
            }
        }
    }
    $ope_form_list_page = new ope_form_list_page();
    $ope_form_list_page->add_page();
    $ope_form_list_page->enqueue();

    add_action('wp_ajax_delEmail', 'delEmail_function');
    function delEmail_function()
    {
        if (!current_user_can('administrator')) {
            wp_send_json(array('status' => 'failed', 'message' => 'Permission Denied'));
            die();
        }
        $nonce = check_ajax_referer('ope_form_nonce_list', 's');
        if ($nonce === false) {
            wp_send_json(array('status' => 'failed', 'message' => 'Auth Failed'));
            die();
        }
        $ids = $_POST['ids'];
        if (!empty($ids)) {
            $ope_form_list_page = new ope_form_list_page();
            $status = $ope_form_list_page->delete($ids);
            if ($status) {
                wp_send_json(array('status' => 'success', 'message' => ''));
            } else {
                wp_send_json(array('status' => 'failed', 'message' => 'SQL error.'));
            }
        } else {
            wp_send_json(array('status' => 'failed', 'message' => 'Empty Params'));
        }

        die();
    }

    add_action('wp_ajax_export_selected_mail', 'export_selected_mail_function');
    function export_selected_mail_function()
    {
        if (!current_user_can('administrator')) {
            wp_send_json(array('status' => 'failed', 'message' => 'Permission Denied'));
            die();
        }
        $nonce = check_ajax_referer('ope_form_nonce_list', 's');
        if ($nonce === false) {
            wp_send_json(array('status' => 'failed', 'message' => 'Auth Failed'));
            die();
        }
        $ids = $_POST['ids'];
        if (!empty($ids)) {
            $ope_form_list_page = new ope_form_list_page();
            $data = $ope_form_list_page->export_selected($ids);
            if ($data) {
                $html = '';
                if (count($ids) == 1) {
                    if (!empty($data)) {
                        $html .= '<table>';
                        foreach ($data as $m) {
                            if (!empty($m->mail_data)) {
                                $msgs = maybe_unserialize($m->mail_data);
                                foreach ($msgs as $msg) {
                                    $html .= '<tr>';
                                    $title = htmlspecialchars($msg->key);
                                    $value = htmlspecialchars($msg->value);
                                    preg_match('/(\<img.*?)*(data:image)*(\>)/', $msg->value, $img_tag);
                                    if (!empty(@$img_tag)) {
                                        $value = htmlspecialchars_decode($value);
                                    }
                                    $value = preg_replace('/\r|\n/', '<br>', trim($value));
                                    $html .= '<th>' . $title . '</th><td>' . $value . '</td>';
                                    $html .= '</tr>';
                                }
                            }
                        }
                        $html .= '</table>';
                    }
                }
                if (count($ids) > 1) {
                    if (!empty($data)) {
                        $messages = [];
                        foreach ($data as $m) {
                            $msgs = maybe_unserialize($m->mail_data);
                            array_push($messages, $msgs);
                        }
                        $html = $messages;
                    }
                }
                wp_send_json(array('status' => 'success', 'message' => '', 'data' => $html));
            } else {
                wp_send_json(array('status' => 'failed', 'message' => 'SQL error.'));
            }
        } else {
            wp_send_json(array('status' => 'failed', 'message' => 'Empty Params'));
        }

        die();
    }

    add_action('wp_ajax_export_all_mail', 'export_all_mail_function');
    function export_all_mail_function()
    {
        if (!current_user_can('administrator')) {
            wp_send_json(array('status' => 'failed', 'message' => 'Permission Denied'));
            die();
        }
        $nonce = check_ajax_referer('ope_form_nonce_list', 's');
        if ($nonce === false) {
            wp_send_json(array('status' => 'failed', 'message' => 'Auth Failed'));
            die();
        }

        $ope_form_list_page = new ope_form_list_page();
        $data = $ope_form_list_page->export_all();
        if ($data) {
            $html = '';
            if (!empty($data)) {
                $messages = [];
                foreach ($data as $m) {
                    $msgs = maybe_unserialize($m->mail_data);
                    array_push($messages, $msgs);
                }
                $html = $messages;
            }
            wp_send_json(array('status' => 'success', 'message' => '', 'data' => $html));
        } else {
            wp_send_json(array('status' => 'failed', 'message' => 'SQL error.'));
        }

        die();
    }

    add_action('wp_ajax_get_email_details', 'get_email_details_function');
    function get_email_details_function()
    {
        if (!current_user_can('administrator')) {
            wp_send_json(array('status' => 'failed', 'message' => 'Permission Denied'));
            die();
        }
        $nonce = check_ajax_referer('ope_form_nonce_list', 's');
        if ($nonce === false) {
            wp_send_json(array('status' => 'failed', 'message' => 'Auth Failed'));
            die();
        }
        $id = $_POST['id'];
        if (!empty($id)) {
            $ope_form_list_page = new ope_form_list_page();
            $data = $ope_form_list_page->get_details($id);
            if ($data) {
                $message_unserialized = maybe_unserialize($data[0]->mail_data);
                $attachment_filesunserialized = maybe_unserialize($data[0]->attachment_files);
                $attachment_images_unserialized = maybe_unserialize($data[0]->attachment_images);
                $http_data_unserialized = maybe_unserialize($data[0]->http_data);
                wp_send_json(array('status' => 'success', 'message' => '', 'mail_id' => $data[0]->mail_id, 'message' => $message_unserialized, 'attachment_files' => $attachment_filesunserialized, 'attachment_images' => $attachment_images_unserialized, 'http_data' => $http_data_unserialized));
            } else {
                wp_send_json(array('status' => 'failed', 'message' => 'SQL error.'));
            }
        } else {
            wp_send_json(array('status' => 'failed', 'message' => 'Empty Params'));
        }

        die();
    }


    add_action('wp_ajax_download_attachment_file', 'download_attachment_file_function');
    function download_attachment_file_function()
    {
        if (!current_user_can('administrator')) {
            wp_send_json(array('status' => 'failed', 'message' => 'Permission Denied'));
            die();
        }
        $nonce = check_ajax_referer('ope_form_nonce_list', 's');
        if ($nonce === false) {
            wp_send_json(array('status' => 'failed', 'message' => 'Auth Failed'));
            die();
        }
        $file = $_POST['file'] ?? null;
        if ($file) {
            $file_path = ABSPATH . $file;
            if (file_exists($file_path)) {
                $file_url = get_option('home') . '/' . $file;
                wp_send_json_success(array('file_url' => $file_url));
            } else {
                wp_send_json_error(array('message' => 'File not found.'));
            }
        } else {
            wp_send_json_error(array('message' => 'No file specified.'));
        }
        die();
    }

    add_action('wp_ajax_delCat', 'delCat_function');
    function delCat_function()
    {
        if (!current_user_can('administrator')) {
            wp_send_json(array('status' => 'failed', 'message' => 'Permission Denied'));
            die();
        }
        $nonce = check_ajax_referer('ope_form_nonce_list', 's');
        if ($nonce === false) {
            wp_send_json(array('status' => 'failed', 'message' => 'Auth Failed'));
            die();
        }
        $ids = $_POST['ids'];
        if (!empty($ids)) {
            $ope_form_list_page = new ope_form_list_page();
            $status = $ope_form_list_page->deleteCat($ids);
            if ($status) {
                wp_send_json(array('status' => 'success', 'message' => ''));
            } else {
                wp_send_json(array('status' => 'failed', 'message' => 'SQL error.'));
            }
        } else {
            wp_send_json(array('status' => 'failed', 'message' => 'Empty Params'));
        }

        die();
    }
}