<?php
if (!defined('ABSPATH')) {
    die('Access Denied!');
}
if (current_user_can('administrator')) {
    class opeFormCatPagination
    {
        public static function pagination($perPageRecord = '', $baseUrl = '')
        {
            if (empty($perPageRecord)) {
                echo 'Error: The pagination function requires setting parameters.';
            } else {
                global $wpdb;
                $table_name = $wpdb->prefix . 'opeform_mailbox';
                if (isset($_GET['ope_form_page_number']) && $_GET['ope_form_page_number'] != "") {
                    $ope_form_page_number = $_GET['ope_form_page_number'];
                } else {
                    $ope_form_page_number = 1;
                }
                $offset = ($ope_form_page_number - 1) * $perPageRecord;
                $total_records = $wpdb->get_var("SELECT COUNT(*) FROM `$table_name`");
                if ($total_records > $perPageRecord) {
                    $total_no_of_pages = ceil($total_records / $perPageRecord);
                    return '<div class="opeform-patination">' . paginate_links(array(
                        'base' => add_query_arg('ope_form_page_number', '%#%'),
                        'format' => '',
                        'prev_text' => __('&laquo;', 'ope-form-pack'),
                        'next_text' => __('&raquo;', 'ope-form-pack'),
                        'total' => $total_no_of_pages,
                        'current' => $ope_form_page_number,
                    )) . '</div>';
                } else {
                    return false;
                }
            }
        }
    }
    $opeFormCatPagination = new opeFormCatPagination();
    $perPage = 100;

    global $wpdb, $ope_form_panel_config;
    date_default_timezone_set(@$ope_form_panel_config->timezone);
    $table_name_cats = $wpdb->prefix . 'opeform_mailbox_terms';
    if (isset($_GET['ope_form_page_number']) && $_GET['ope_form_page_number'] != "") {
        $ope_form_page_number = $_GET['ope_form_page_number'];
    } else {
        $ope_form_page_number = 1;
    }
    $offset = ($ope_form_page_number - 1) * $perPage;
    $result = $wpdb->get_results("SELECT * FROM `$table_name_cats` ORDER BY term_id DESC LIMIT $offset, $perPage");
    ?>
    <div class="ope-form-mail-list-wrapper" data-area="email-category">
        <div class="mail-list-head">
            <h2><?php echo __('Mail Categories', 'ope-form-pack'); ?></h2>
        </div>
        <?php if (!empty($result)) { ?>
            <div class="control-section">
                <?php echo $opeFormCatPagination->pagination($perPage); ?>
                <div class="actions">
                    <div data-action="del_cat"><?php echo __("Delete", "ope-form-pack"); ?></div>
                </div>
            </div>
            <div class="ope-form-mail-list">
                <?php
                echo '<table>';
                echo '<tr><td><input type="checkbox" id="check_all_1"></td><th>Name</th>
    <th>Slug</th>
    <th>Date</th></tr>';
                foreach ($result as $t) {
                    ?>
                    <tr data-row-id="<?php echo @$t->term_id; ?>">
                        <td><input type="checkbox" value="<?php echo @$t->term_id; ?>"></td>
                        <td><?php echo @$t->term_name; ?></td>
                        <td><?php echo @$t->term_slug; ?></td>
                        <td><?php echo @$t->created; ?></td>
                    </tr>
                    <?php
                }
                echo '<tr><td><input type="checkbox" id="check_all_1"></td><th>Name</th>
    <th>Slug</th>
    <th>Date</th></tr>';
                echo '</table>';
                ?>
            </div>
            <div class="control-section">
                <?php echo $opeFormCatPagination->pagination($perPage); ?>
                <div class="actions">
                    <div data-action="del_cat"><?php echo __("Delete", "ope-form-pack"); ?></div>
                </div>
            </div>
        <?php } else {
            echo __("There are no entries to display", "ope-form-pack");
        } ?>
    </div>
    <?php
    unset($result);
}