<?php
if (!defined('ABSPATH')) {
    die('Access Denied!');
}

if (current_user_can('administrator')) {
    class opeFormPagination
    {
        public static function pagination($perPageRecord = '', $baseUrl = '')
        {
            if (empty($perPageRecord)) {
                echo 'Error: The pagination function requires setting parameters.';
                return false;
            }

            global $wpdb;
            $table_name = $wpdb->prefix . 'opeform_mailbox';

            $ope_form_page_number = isset($_GET['ope_form_page_number']) && is_numeric($_GET['ope_form_page_number'])
                ? intval($_GET['ope_form_page_number'])
                : 1;

            $cat_id = isset($_GET['ope_form_category']) && is_numeric($_GET['ope_form_category'])
                ? trim($_GET['ope_form_category'])
                : '';

            $where = $cat_id ? $wpdb->prepare('WHERE mail_category = %s', $cat_id) : '';

            $total_records = $wpdb->get_var("SELECT COUNT(*) FROM `$table_name` $where");
            if ($total_records > $perPageRecord) {
                $total_no_of_pages = ceil($total_records / $perPageRecord);
                return '<div class="opeform-pagination">' . paginate_links(array(
                    'base' => add_query_arg('ope_form_page_number', '%#%'),
                    'format' => '',
                    'prev_text' => __('&laquo;', 'ope-form-pack'),
                    'next_text' => __('&raquo;', 'ope-form-pack'),
                    'total' => $total_no_of_pages,
                    'current' => $ope_form_page_number,
                )) . '</div>';
            }

            return false;
        }
    }

    $opeFormPagination = new opeFormPagination();

    $perPage = isset($_GET['data-page-rows-show']) && is_numeric($_GET['data-page-rows-show'])
        ? intval($_GET['data-page-rows-show'])
        : 20;

    global $wpdb, $ope_form_panel_config;
    date_default_timezone_set(@$ope_form_panel_config->timezone);

    $table_name = $wpdb->prefix . 'opeform_mailbox';
    $ope_form_page_number = isset($_GET['ope_form_page_number']) && is_numeric($_GET['ope_form_page_number']) && $_GET['ope_form_page_number'] > 0
        ? intval($_GET['ope_form_page_number'])
        : 1;

    $offset = ($ope_form_page_number - 1) * $perPage;

    $query_string = isset($_GET['ope_form_search']) && !empty($_GET['ope_form_search'])
        ? '%' . $wpdb->esc_like($_GET['ope_form_search']) . '%'
        : '';

    $cat_id = isset($_GET['ope_form_category']) && is_numeric($_GET['ope_form_category'])
        ? trim($_GET['ope_form_category'])
        : '';

    $where_conditions = [];
    $query_params = [];

    if (!empty($cat_id)) {
        $where_conditions[] = "mail_category = %s";
        $query_params[] = $cat_id;
    }

    if (!empty($query_string)) {
        $where_conditions[] = "(from_name LIKE %s OR from_email LIKE %s OR mail_data LIKE %s)";
        array_push($query_params, $query_string, $query_string, $query_string);
    }

    $where_clause = !empty($where_conditions) ? "WHERE " . implode(" AND ", $where_conditions) : "";

    $query = "SELECT * FROM `$table_name` $where_clause ORDER BY mail_id DESC LIMIT %d, %d";

    $query_params[] = $offset;
    $query_params[] = $perPage;

    $prepared_query = $wpdb->prepare($query, ...$query_params);

    $result = $wpdb->get_results($prepared_query);

    // Fetch all categories at once
    $table_name_terms = $wpdb->prefix . 'opeform_mailbox_terms';
    $categories = $wpdb->get_results("SELECT * FROM `$table_name_terms`");

    ?>
    <div class="ope-form-mail-list-wrapper" data-area="email-list">
        <div class="mail-list-head">
            <h2><?php echo isset($_GET['ope_form_search']) && !empty($_GET['ope_form_search']) ? __('Search Result', 'ope-form-pack') : __('Mail List', 'ope-form-pack'); ?>
            </h2>
            <form method="get" action="<?php echo esc_url($_SERVER['REQUEST_URI']); ?>">
                <?php
                if (isset($_GET['data-page-rows-show'])) {
                    echo '<input type="hidden" name="data-page-rows-show" value="' . esc_attr($_GET['data-page-rows-show']) . '">';
                }
                if (isset($_GET['ope_form_category'])) {
                    echo '<input type="hidden" name="ope_form_category" value="' . esc_attr($_GET['ope_form_category']) . '">';
                }
                echo '<input type="hidden" name="page" value="' . esc_attr($_GET['page']) . '">';
                ?>
                <div class="ope-form-search-field">
                    <input type="text" name="ope_form_search"
                        value="<?php echo esc_attr(isset($_GET['ope_form_search']) ? $_GET['ope_form_search'] : ''); ?>">
                    <input type="image"
                        src="<?php echo esc_url(get_template_directory_uri() . '/pack/contact-form/mailList/assets/img/magnifying-glass-solid.svg'); ?>">
                </div>
            </form>
        </div>
        <?php if (!empty($result)) { ?>
            <div class="control-section">
                <?php echo $opeFormPagination->pagination($perPage); ?>
                <div class="actions">
                    <div data-action="del_mail"><?php echo __("Delete", "ope-form-pack"); ?></div>
                    <div data-action="export_selected"><?php echo __("Export Selected", "ope-form-pack"); ?></div>
                    <?php if ($opeFormPagination->pagination($perPage) !== false) { ?>
                        <div data-action="export_all"><?php echo __("Export All", "ope-form-pack"); ?></div>
                    <?php } ?>
                    <div class="data-page-rows-show">
                        <?php echo __("Show per page", 'ope-form-pack'); ?>&nbsp;
                        <form method="get" action="<?php echo esc_url($_SERVER['REQUEST_URI']); ?>">
                            <input type="hidden" name="page" value="<?php echo esc_attr($_GET['page']); ?>">
                            <?php if (isset($_GET['ope_form_category'])) { ?>
                                <input type="hidden" name="ope_form_category"
                                    value="<?php echo esc_attr($_GET['ope_form_category']); ?>">
                            <?php } ?>
                            <select name="data-page-rows-show" onchange="this.form.submit()">
                                <option <?php selected('1', $perPage); ?> value="1">1</option>
                                <option <?php selected('10', $perPage); ?> value="10">10</option>
                                <option <?php selected('20', $perPage); ?> value="20">20</option>
                                <option <?php selected('30', $perPage); ?> value="30">30</option>
                                <option <?php selected('50', $perPage); ?> value="50">50</option>
                                <option <?php selected('100', $perPage); ?> value="100">100</option>
                                <option <?php selected('200', $perPage); ?> value="200">200</option>
                                <option <?php selected('1000', $perPage); ?> value="1000">1000</option>
                                <option <?php selected('5000', $perPage); ?> value="5000">5000</option>
                            </select>
                        </form>
                    </div>
                    <div class="data-mail-categoies">
                        <?php echo __("Category", 'ope-form-pack'); ?>&nbsp;
                        <form method="get" action="<?php echo esc_url($_SERVER['REQUEST_URI']); ?>">
                            <input type="hidden" name="page" value="<?php echo esc_attr($_GET['page']); ?>">
                            <?php if (isset($_GET['data-page-rows-show'])) { ?>
                                <input type="hidden" name="data-page-rows-show"
                                    value="<?php echo esc_attr($_GET['data-page-rows-show']); ?>">
                            <?php } ?>
                            <select name="ope_form_category" onchange="this.form.submit()">
                                <option value=""><?php echo __('All', 'ope-form-pack'); ?></option>
                                <?php foreach ($categories as $cat) { ?>
                                    <option value="<?php echo esc_attr($cat->term_id); ?>" <?php selected($cat->term_id, isset($_GET['ope_form_category']) ? $_GET['ope_form_category'] : ''); ?>>
                                        <?php echo esc_html($cat->term_name); ?>
                                    </option>
                                <?php } ?>
                            </select>
                        </form>
                    </div>
                </div>
            </div>
            <div class="ope-form-mail-list">
                <table>
                    <tr>
                        <td><input type="checkbox" id="check_all_1"></td>
                        <th>From</th>
                        <th>Email</th>
                        <th>Date</th>
                        <th>Category</th>
                    </tr>
                    <?php foreach ($result as $m) { ?>
                        <tr data-row-id="<?php echo esc_attr($m->mail_id); ?>">
                            <td><input type="checkbox" value="<?php echo esc_attr($m->mail_id); ?>"></td>
                            <td><?php echo esc_html($m->from_name); ?></td>
                            <td><?php echo esc_html($m->from_email); ?></td>
                            <td><?php echo esc_html($m->created); ?></td>
                            <td>
                                <?php
                                if (!empty($m->mail_category)) {
                                    $cat_id = $m->mail_category;
                                    $category_name = '';
                                    foreach ($categories as $cat) {
                                        if ($cat->term_id == $cat_id) {
                                            $category_name = $cat->term_name;
                                            break;
                                        }
                                    }
                                    echo esc_html($category_name);
                                }
                                ?>
                            </td>
                        </tr>
                    <?php } ?>
                    <tr>
                        <td><input type="checkbox" id="check_all_2"></td>
                        <th>From</th>
                        <th>Email</th>
                        <th>Date</th>
                        <th>Category</th>
                    </tr>
                </table>
            </div>
            <div class="control-section">
                <?php echo $opeFormPagination->pagination($perPage); ?>
                <div class="actions">
                    <div data-action="del_mail"><?php echo __("Delete", "ope-form-pack"); ?></div>
                    <div data-action="export_selected"><?php echo __("Export Selected", "ope-form-pack"); ?></div>
                    <?php if ($opeFormPagination->pagination($perPage) !== false) { ?>
                        <div data-action="export_all"><?php echo __("Export All", "ope-form-pack"); ?></div>
                    <?php } ?>
                </div>
            </div>
        <?php } else {
            echo __("There are no entries to display", "ope-form-pack");
        } ?>
    </div>
    <?php
}