<?php
if (!defined('ABSPATH')) {
    die('Access Denied!');
}
global $ope_form_panel_config;
$token = @$_POST['token'];
$error_callBack["to"] = array("status" => "failed");
$error_callBack["reply"] = array("status" => "failed");
if (!session_id()) {
    session_start();
}
if (!(isset($token) && $token == $_SESSION["ope_form_token"])) {
    $error_callBack["to"] = array("status" => "failed", "code" => "Token Error");
    echo json_encode($error_callBack);
    die();
}
if (@$ope_form_panel_config->google_recaptcha_v3 == 'on') {
    if (empty($_POST['g_recaptcha_response'])) {
        $error_callBack["to"] = array("status" => "failed", "code" => "reCAPTCHA Error 1");
        echo json_encode($error_callBack);
        die();
    }
    function verifyReCaptchaV3()
    {
        global $ope_form_panel_config;
        $secret = @$ope_form_panel_config->google_recaptcha_v3_secret_key;
        $response = $_POST['g_recaptcha_response'];
        $url = "https://www.google.com/recaptcha/api/siteverify";
        $data = array('secret' => $secret, 'response' => $response);
        $options = array(
            'http' => array(
                'header' => "Content-type: application/x-www-form-urlencoded",
                'method' => 'POST',
                'content' => http_build_query($data),
            ),
        );
        $context = stream_context_create($options);
        $res = file_get_contents($url, false, $context);
        return $res;
    }
    $res = verifyReCaptchaV3();
    $res = json_decode($res, true);
    if ($res['success'] === true) {
    } else {
        $error_callBack["to"] = array("status" => "failed", "code" => "reCAPTCHA Error 2", "debug" => $res);
        echo json_encode($error_callBack);
        die();
    }
}
if (!(isset($_POST['nonce']) && wp_verify_nonce($_POST['nonce'], 'ope_form_nonce'))) {
    $error_callBack["to"] = array("status" => "failed", "code" => "Nonce Error");
    echo json_encode($error_callBack);
    die();
}
if ($_POST['name'] !== '-/-') {
    $error_callBack["to"] = array("status" => "failed", "code" => "You fell into the trap.");
    echo json_encode($error_callBack);
    die();
}
$unique_id = hash('sha256', time());
if (!empty(@$ope_form_panel_config->validate_code) && @$ope_form_panel_config->validate_code == "on") {
    $unique_id = $_POST['id'];
    $value = $_POST['value'];
    if (!isset($_SESSION["captcha_code_" . $unique_id])) {
        $error_callBack["to"] = array("status" => "failed", "code" => "Captcha code not detected. Please ensure you have entered the Captcha and try again.");
        echo json_encode($error_callBack);
        die();
    }
    if ($value != $_SESSION["captcha_code_" . $unique_id]) {
        $error_callBack["to"] = array("status" => "failed", "code" => "Captcha code does not match. Please refresh the Captcha and try again.");
        echo json_encode($error_callBack);
        die();
    }
}


// Helper function for sanitizing email addresses
function sanitize_ope_email($email)
{
    return filter_var($email, FILTER_SANITIZE_EMAIL);
}

// Helper function for decoding and decrypting custom emails
function decode_and_decrypt_emails($custom_receiver)
{
    $custom_emails = [];
    if (!empty($custom_receiver)) {
        foreach ($custom_receiver as $cr) {
            $email_parts = explode(",", $cr);
            foreach ($email_parts as $e) {
                $decoded_email = base64_decode($e);
                $decrypted_email = opeEncrypDecrypt::decrypt($decoded_email);
                $emails = explode(";", $decrypted_email);
                $custom_emails = array_merge($custom_emails, $emails);
            }
        }
        $custom_emails = array_unique($custom_emails);
    }
    return $custom_emails;
}

// Retrieving and sanitizing POST data
$messages = isset($_POST['data']) ? json_decode(stripslashes($_POST['data'])) : [];
$admin_email_address = isset($_POST['admin_email_address']) ? sanitize_ope_email($_POST['admin_email_address']) : '';
$admin_email_subject = isset($_POST['admin_email_subject']) ? htmlspecialchars($_POST['admin_email_subject']) : '';
$reply_email_subject = isset($_POST['reply_email_subject']) ? htmlspecialchars($_POST['reply_email_subject']) : '';
$admin_email_top = isset($_POST['admin_email_top']) ? htmlspecialchars($_POST['admin_email_top']) : '';
$reply_email_top = isset($_POST['reply_email_top']) ? htmlspecialchars($_POST['reply_email_top']) : '';
$reply_email_bottom = isset($_POST['reply_email_bottom']) ? htmlspecialchars($_POST['reply_email_bottom']) : '';
$fileNames = isset($_POST['fileNames']) ? json_decode(stripslashes($_POST['fileNames'])) : [];
$custom_receiver = isset($_POST['custom_receiver']) ? json_decode(stripslashes($_POST['custom_receiver'])) : [];

// Decode and decrypt custom emails
$custom_emails = decode_and_decrypt_emails($custom_receiver);

// Sanitize client information
$client_email = isset($_POST['from_email']) ? sanitize_ope_email($_POST['from_email']) : '(undefined email)';
$client_name = isset($_POST['from_name']) ? htmlspecialchars($_POST['from_name']) : '(undefined user)';
$category = isset($_POST['cat']) ? htmlspecialchars($_POST['cat']) : '';

// Collect server and user details
$host = $_SERVER['HTTP_HOST'];
$user_agent = $_SERVER['HTTP_USER_AGENT'];
$ip = !empty($_SERVER['HTTP_CLIENT_IP']) ? $_SERVER['HTTP_CLIENT_IP'] :
    (!empty($_SERVER['HTTP_X_FORWARDED_FOR']) ? explode(",", $_SERVER['HTTP_X_FORWARDED_FOR'])[0] : $_SERVER['REMOTE_ADDR']);
$uri = $_SERVER['REQUEST_URI'];

// Decode and process behavior data
$behavior = isset($_POST['behavior']) ? json_decode(stripslashes($_POST['behavior'])) : null;



function getOS()
{
    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    $os_platform = "Unknown System";
    $os_array = array(
        '/windows nt 10/i' => 'Windows 10/11',
        '/windows nt 6.3/i' => 'Windows 8.1',
        '/windows nt 6.2/i' => 'Windows 8',
        '/windows nt 6.1/i' => 'Windows 7',
        '/windows nt 6.0/i' => 'Windows Vista',
        '/windows nt 5.2/i' => 'Windows Server 2003/XP x64',
        '/windows nt 5.1/i' => 'Windows XP',
        '/windows xp/i' => 'Windows XP',
        '/windows nt 5.0/i' => 'Windows 2000',
        '/windows me/i' => 'Windows ME',
        '/win98/i' => 'Windows 98',
        '/win95/i' => 'Windows 95',
        '/win16/i' => 'Windows 3.11',
        '/macintosh|mac os x/i' => 'Mac OS X',
        '/mac_powerpc/i' => 'Mac OS 9',
        '/linux/i' => 'Linux',
        '/ubuntu/i' => 'Ubuntu',
        '/iphone/i' => 'iPhone',
        '/ipod/i' => 'iPod',
        '/ipad/i' => 'iPad',
        '/android/i' => 'Android',
        '/blackberry/i' => 'BlackBerry',
        '/webos/i' => 'Mobile',
    );
    foreach ($os_array as $regex => $value) {
        if (preg_match($regex, $user_agent)) {
            $os_platform = $value;
        }
    }
    return $os_platform;
}

function ope_massage_images_filter($msgs)
{
    $messages = array();
    foreach ($msgs as $msg) {
        $title = htmlspecialchars($msg->key);
        $value = $msg->value;
        preg_match('/<img[^>]*src="data:image\/jpeg;base64,([A-Za-z0-9+\/=]+)"[^>]*>/', $msg->value, $img_tag);
        if (!empty($img_tag)) {
            $newobj = new stdClass();
            $newobj->key = $title;
            $newobj->value = __('View attachment', 'ope-form-pack');
        } else {
            $newobj = new stdClass();
            $newobj->key = $title;
            $newobj->value = $value;
        }
        array_push($messages, $newobj);
    }
    return $messages;
}

if (@$ope_form_panel_config->store_mail_in_db == "on") {
    date_default_timezone_set(@$ope_form_panel_config->timezone);
    $title = 'Mail-' . date('Y-m-d H:i:s');
    $attachment_files = array();
    $attachment_images = array();
    if (@$ope_form_panel_config->save_file_to_server == "on") {
        $year = date("Y");
        $month = date("m");
        if (!is_dir(ABSPATH . @$ope_form_panel_config->file_upload_folder_name . "/" . $year . "/" . $month)) {
            mkdir(ABSPATH . @$ope_form_panel_config->file_upload_folder_name . "/" . $year, 0755);
            mkdir(ABSPATH . @$ope_form_panel_config->file_upload_folder_name . "/" . $year . "/" . $month, 0755);
        }
        $ope_form_class = new opeFormClass();
        if ($_FILES) {
            foreach ($fileNames as $fn) {
                $unique_name = $ope_form_class->getName(15);
                $hash = hash('sha256', $unique_name);
                $info = pathinfo($_FILES[$fn]['name']);
                $file_name_without_extension = $info['filename'];
                $ext = $info['extension'];
                $newname = date("Y-m-d-H-i-s") . '-' . $unique_name . '-' . $hash . '.' . $ext;
                $target = ABSPATH . @$ope_form_panel_config->file_upload_folder_name . "/" . $year . "/" . $month . "/" . $newname;
                copy($_FILES[$fn]['tmp_name'], $target);
                array_push($attachment_files, array(
                    'name' => $fn,
                    'original_name' => $file_name_without_extension . '.' . $ext,
                    'url' => @$ope_form_panel_config->file_upload_folder_name . "/" . $year . "/" . $month . "/" . $newname,
                ));
            }
        }
        foreach ($messages as $msg) {
            // Generate a random unique name using uniqid
            $unique_name = uniqid('', true);
            $timestamp = date("Y-m-d-H-i-s");

            // Extract and process the image data
            preg_match('/<img[^>]*src="([^"]+)"[^>]*>/', $msg->value, $img_tag);
            if (!empty($img_tag[1]) && preg_match('/data:image\/\w+;base64,/', $img_tag[1])) {
                $parts = explode(";base64,", $img_tag[1]);
                if (isset($parts[1])) {
                    $imagebase64 = base64_decode($parts[1], true);
                    if ($imagebase64 !== false) {
                        // Generate a hash of the image content for additional uniqueness
                        $hash = hash('sha256', $imagebase64);

                        // Determine file extension using MIME type
                        $finfo = finfo_open(FILEINFO_MIME_TYPE);
                        $mimeType = finfo_buffer($finfo, $imagebase64);
                        finfo_close($finfo);

                        // Default extension to 'jpg' if MIME type cannot be determined
                        $extension = 'jpg';
                        if (strpos($mimeType, 'image/') === 0) {
                            $extension = explode('/', $mimeType)[1];
                        }

                        // Construct the new file name
                        $newname = "{$timestamp}-{$unique_name}-{$hash}.{$extension}";

                        // Define folder path based on year/month
                        $folder_path = ABSPATH . $ope_form_panel_config->file_upload_folder_name . "/$year/$month";
                        if (!is_dir($folder_path)) {
                            mkdir($folder_path, 0777, true);
                        }

                        // Save the file
                        $target = "{$folder_path}/{$newname}";
                        if (file_put_contents($target, $imagebase64) !== false) {
                            $attachment_images[] = [
                                'name' => $msg->key,
                                'original_name' => $msg->key . '.' . $extension,
                                'url' => @$ope_form_panel_config->file_upload_folder_name . "/$year/$month/{$newname}",
                            ];
                        }
                    }
                }
            }
        }

    }
    $receiver_debug_array = [];
    if (empty($custom_emails)) {
        $receiver_debug = @$ope_form_panel_config->recipient_administrator_email;
        if (!empty($admin_email_address)) {
            $admin_email_address_debug = json_decode(stripslashes($admin_email_address));
            $admin_email_address_debug = base64_decode($admin_email_address_debug);
            $receiver_debug = opeEncrypDecrypt::decrypt($admin_email_address_debug);
        }
        if (empty($receiver_debug)) {
            $receiver_debug = array();
        }
        $receiver_debug = explode(",", $receiver_debug);
        foreach ($receiver_debug as $rd) {
            array_push($receiver_debug_array, $rd);
        }
    }

    $receiver_cc_debug_array = [];
    if (empty($custom_emails)) {
        $receiver_cc_debug = @$ope_form_panel_config->recipient_administrator_email_cc;
        if (!empty($receiver_cc_debug)) {
            $receiver_cc_debug = explode(",", $receiver_cc_debug);
            foreach ($receiver_cc_debug as $rcd) {
                array_push($receiver_cc_debug_array, $rcd);
            }
        }
    }

    $captcha_code = $_SESSION["captcha_code_" . $unique_id] ?? null;

    $http_data_raw = array(
        'ip' => $ip,
        'host' => $host,
        'uri' => $uri,
        'user_os' => getOS(),
        'user_agent' => $user_agent,
        'client_click_action' => $behavior->click_action,
        'client_multistep_count' => $behavior->multistep_count,
        'client_UA' => $behavior->ua,
        'client_request_code' => $behavior->request_code,
        'request_code_REAL' => $captcha_code,
        'current_page' => $behavior->current_page,
        'client_language' => $behavior->language,
        'client_logical_processors' => $behavior->logical_processors,
        'client_screen_size' => $behavior->screen_size,
        'client_click_position' => $behavior->click_position,
        'admin_receiver' => $receiver_debug_array,
        'admin_receiver_cc' => $receiver_cc_debug_array,
        'custom_receiver' => $custom_emails,
    );

    $ope_save_mail_data = new opeSaveMailData();

    $term = $ope_save_mail_data->term_exists($category);
    if ($term === false) {
        $term_data = $ope_save_mail_data->insert_term($category, $http_data_raw);
    } else {
        $term_data = $term;
    }

    $term_id = $term_data['term_id'];

    $messages_filtered = ope_massage_images_filter($messages);

    $ope_form_post = array(
        'user_client_name' => $client_name ? $client_name : '',
        'user_client_email' => $client_email ? $client_email : '',
        'category' => $term_id,
        'user_email_data' => $messages_filtered,
        'user_http_data' => $http_data_raw,
        'user_attachment_images' => $attachment_images,
        'user_attachment_files' => $attachment_files,
    );

    $post_id = $ope_save_mail_data->insert_post($ope_form_post);

    unset($term);
    unset($attachment_images);
    unset($attachment_files);
}

if (@$ope_form_panel_config->email_format !== "html") {
    // Plain Text Email Format
    $content = '';

    // Admin Email Top Section
    if (!empty($admin_email_top)) {
        $admin_email_top_parsed = base64_decode(opeEncrypDecrypt::decrypt(json_decode(stripslashes($admin_email_top))));
        $content .= ope_form_br2nl($admin_email_top_parsed) . PHP_EOL . PHP_EOL;
    }

    // Message Body
    foreach ($messages as $msg) {
        $title = htmlspecialchars($msg->key);
        $value = htmlspecialchars($msg->value);
        // Skip messages with embedded images
        if (preg_match('/<img[^>]*src="data:image\/jpeg;base64,([A-Za-z0-9+\/=]+)"[^>]*>/', $msg->value)) {
            continue;
        }
        $content .= $title . '：' . $value . PHP_EOL;
    }

    // Debug Info (if enabled)
    if (@$ope_form_panel_config->include_debug_info_in_admin_email == "on") {
        $content .= PHP_EOL . '----------For Debug-------------' . PHP_EOL;
        $content .= 'IP: ' . $ip . PHP_EOL;
        $content .= 'User Agent: ' . $user_agent . PHP_EOL;
        $content .= 'User OS: ' . getOS() . PHP_EOL;
        $content .= 'URI: ' . $uri . PHP_EOL;
        $content .= 'Host: ' . $host . PHP_EOL;
    }

    // Reply Email Content
    $reply_content = '';
    $reply_content .= !empty($reply_email_top) ?
        ope_form_br2nl(opeEncrypDecrypt::decrypt(base64_decode(json_decode(stripslashes($reply_email_top))))) . PHP_EOL . PHP_EOL :
        (!empty(@$ope_form_panel_config->auto_reply_email_body_top) ? ope_form_br2nl(@$ope_form_panel_config->auto_reply_email_body_top) . PHP_EOL . PHP_EOL : '');

    foreach ($messages as $msg) {
        $title = htmlspecialchars($msg->key);
        $value = htmlspecialchars($msg->value);
        // Skip messages with embedded images
        if (preg_match('/<img[^>]*src="data:image\/jpeg;base64,([A-Za-z0-9+\/=]+)"[^>]*>/', $msg->value)) {
            continue;
        }
        $reply_content .= $title . '：' . $value . PHP_EOL;
    }

    $reply_content .= !empty($reply_email_bottom) ?
        nl2br(opeEncrypDecrypt::decrypt(base64_decode(json_decode(stripslashes($reply_email_bottom))))) :
        (!empty(@$ope_form_panel_config->auto_reply_email_body_bottom) ? nl2br(@$ope_form_panel_config->auto_reply_email_body_bottom) : '');
} else {
    // HTML Email Format
    $content = '';

    // Admin Email Top Section
    if (!empty($admin_email_top)) {
        $admin_email_top_parsed = base64_decode(opeEncrypDecrypt::decrypt(json_decode(stripslashes($admin_email_top))));
        $content .= '<p>' . nl2br($admin_email_top_parsed) . '<br></p>';
    }

    // Messages Table
    $content .= '<style>img[src^="data:image/jpeg;base64"]{margin:5px 0;width:100%;display:block;max-width:200px;height:auto;}</style><table style="border:1px solid #ccc;border-collapse:collapse;font-size:14px;font-family:sans-serif;">';
    foreach ($messages as $msg) {
        $title = htmlspecialchars($msg->key);
        $value = htmlspecialchars($msg->value);
        if (preg_match('/<img[^>]*src="data:image\/jpeg;base64,([A-Za-z0-9+\/=]+)"[^>]*>/', $msg->value)) {
            $value = htmlspecialchars_decode($value);
        }
        $value = preg_replace('/\r|\n/', '<br>', trim($value));
        $content .= '<tr style="border:1px solid #ccc;">
            <th style="border:1px solid #ccc;background-color:#eeeeee;font-weight:bold;min-width:100px;padding:5px 10px;white-space:nowrap;">
                ' . $title . '</th>
            <td style="border:1px solid #ccc;background-color:#f3f3f3;font-weight:normal;padding:5px 10px;">
                ' . $value . '</td>
        </tr>';
    }
    $content .= '</table>';

    // Debug Info (if enabled)
    if (@$ope_form_panel_config->include_debug_info_in_admin_email == "on") {
        $content .= '<p style="font-size:12px;color:#666;">';
        $content .= 'IP: ' . $ip . '<br>';
        $content .= 'User Agent: ' . $user_agent . '<br>';
        $content .= 'User OS: ' . getOS() . '<br>';
        $content .= 'URI: ' . $uri . '<br>';
        $content .= 'Host: ' . $host;
        $content .= '</p>';
    }

    // Reply Email Content
    $reply_content = '';
    $reply_content .= !empty($reply_email_top) ?
        '<p>' . nl2br(opeEncrypDecrypt::decrypt(base64_decode(json_decode(stripslashes($reply_email_top))))) . '<br></p>' :
        (!empty(@$ope_form_panel_config->auto_reply_email_body_top) ? '<p>' . nl2br(@$ope_form_panel_config->auto_reply_email_body_top) . '</p>' : '');

    $reply_content .= '<table style="border:1px solid #ccc;border-collapse:collapse;font-size:14px;font-family: Verdana, Geneva, Tahoma, sans-serif;">';
    foreach ($messages as $msg) {
        $title = htmlspecialchars($msg->key);
        $value = htmlspecialchars($msg->value);
        if (preg_match('/<img[^>]*src="data:image\/jpeg;base64,([A-Za-z0-9+\/=]+)"[^>]*>/', $msg->value)) {
            continue;
        }
        $value = preg_replace('/\r|\n/', '<br>', trim($value));
        $reply_content .= '<tr style="border:1px solid #ccc;">
            <th style="border:1px solid #ccc;background-color:#eeeeee;min-width:100px;font-weight:bold;padding:5px 10px;white-space:nowrap;">
                ' . $title . '</th>
            <td style="border:1px solid #ccc;background-color:#f3f3f3;font-weight:normal;padding:5px 10px;">
                ' . $value . '</td>
        </tr>';
    }
    $reply_content .= '</table>';

    // Reply Email Bottom Section
    $reply_content .= !empty($reply_email_bottom) ?
        '<p>' . nl2br(opeEncrypDecrypt::decrypt(base64_decode(json_decode(stripslashes($reply_email_bottom))))) . '</p>' :
        (!empty(@$ope_form_panel_config->auto_reply_email_body_bottom) ? '<p>' . nl2br(@$ope_form_panel_config->auto_reply_email_body_bottom) . '</p>' : '');
}