<?php
if (!defined('ABSPATH')) {
    die('Access Denied!');
}
global $ope_form_panel_config;
if (!empty(@$ope_form_panel_config->validate_code) && @$ope_form_panel_config->validate_code == "on") {
    add_action('wp_ajax_get_CAPCHACODE', 'get_CAPCHACODE');
    add_action('wp_ajax_nopriv_get_CAPCHACODE', 'get_CAPCHACODE');
}
function get_CAPCHACODE()
{
    if (!(isset($_POST['security']) && wp_verify_nonce($_POST['security'], 'ope_form_nonce'))) {
        die();
    }
    $unique_id = $_POST['id'];
    $width = 200;
    $height = 80;
    $noise_level = 45;

    // Generate a math problem
    $operations = ['+', '-', '*', '/']; // Supported operations
    $operation = $operations[array_rand($operations)]; // Randomly pick an operation

    do {
        $num1 = rand(50, 100);
        $num2 = rand(2, 50); // Avoid division by zero
        switch ($operation) {
            case '+':
                $result = $num1 + $num2;
                break;
            case '-':
                $result = $num1 - $num2;
                break;
            case '*':
                $result = $num1 * $num2;
                break;
            case '/':
                if ($num1 % $num2 === 0) { // Ensure division results in an integer
                    $result = $num1 / $num2;
                } else {
                    $result = 201; // Force loop to repeat
                }
                break;
        }
    } while ($result < 0 || $result > 200); // Ensure result is valid

    // Format operators for frontend display
    $display_operation = $operation;
    if ($operation === '*') {
        $display_operation = '×';
    } elseif ($operation === '/') {
        $display_operation = '÷';
    }

    $captcha_question = "$num1 $display_operation $num2"; // Math question for display
    $captcha_code = $result; // The correct answer

    // Start session and store the result
    if (!session_id()) {
        session_start();
    }
    foreach ($_SESSION as $key => $value) {
        if (strpos($key, 'captcha_code_') === 0) {
            unset($_SESSION[$key]);
        }
    }
    $_SESSION["captcha_code_" . $unique_id] = $captcha_code;
    session_write_close();

    // Create CAPTCHA image
    $im = imagecreatetruecolor($width, $height);
    $bg = imagecolorallocate($im, rand(50, 60), rand(70, 90), rand(100, 120)); // Background color
    $fg = imagecolorallocate($im, rand(200, 200), rand(200, 200), rand(200, 200)); // Text color
    $ns = imagecolorallocate($im, rand(110, 140), rand(140, 160), rand(150, 170)); // Noise color
    imagefill($im, 0, 0, $bg);

    $font = get_template_directory() . '/pack/contact-form/assets/fonts/capchafont.ttf';

    // Draw the math problem on the image
    imagettftext($im, 30, 0, 20, 50, $fg, $font, $captcha_question);

    // Add noise
    for ($i = 0; $i < $noise_level; $i++) {
        for ($j = 0; $j < $noise_level; $j++) {
            imagesetpixel($im, rand(0, $width), rand(0, $height), $ns);
        }
    }
    for ($i = 0; $i < 9; $i++) {
        imagearc($im, mt_rand(-$width, $width), mt_rand(-$height, $height), mt_rand(30, $width * 2), mt_rand(20, $height * 2), mt_rand(0, 360), mt_rand(0, 360), $fg);
    }

    // Output the image as base64
    header("Cache-Control: no-cache, must-revalidate");
    header('Content-type: image/png');
    ob_start();
    imagepng($im);
    $imagedata = ob_get_contents();
    ob_end_clean();
    echo base64_encode($imagedata);

    imagedestroy($im);
    die();
}

if (!empty(@$ope_form_panel_config->validate_code) && @$ope_form_panel_config->validate_code == "on") {
    add_action('wp_ajax_check_CAPCHACODE', 'check_CAPCHACODE');
    add_action('wp_ajax_nopriv_check_CAPCHACODE', 'check_CAPCHACODE');
}
function check_CAPCHACODE()
{
    if (!(isset($_POST['security']) && wp_verify_nonce($_POST['security'], 'ope_form_nonce'))) {
        die("Access Denied!");
    }
    $unique_id = $_POST['id'];
    $value = $_POST['value'];
    if (!session_id()) {
        session_start();
    }
    if ($value == $_SESSION["captcha_code_" . $unique_id]) {
        echo json_encode(array("match" => 1));
    } else {
        echo json_encode(array("match" => 0));
    }
    session_write_close();
    die();
}
add_action('wp_ajax_export_email_data_to_csv', 'export_email_data_to_csv');
function export_email_data_to_csv()
{
    if (!(isset($_POST['security']) && wp_verify_nonce($_POST['security'], 'ope_form_nonce_admin'))) {
        die("Access Denied!");
    }
    $id = $_POST['pid'];
    $user_email_data = get_post_meta($id, 'user_email_data', true);
    if (count($user_email_data) == 0) {
        return null;
    }
    ?>
    <table><?php
    foreach ($user_email_data as $ued) {
        ?>
            <tr>
                <td class="head"><?php echo $ued->key; ?></td>
                <td><?php echo esc_html($ued->value); ?></td>
            </tr><?php
    }
    ?>
    </table>
    <?php
    die();
}
require 'opeform-ajax-send-mail.php';
add_action('wp_ajax_getToken', 'getTokenFuntion');
add_action('wp_ajax_nopriv_getToken', 'getTokenFuntion');
function getTokenFuntion()
{
    if (!(isset($_POST['s']) && wp_verify_nonce($_POST['s'], 'ope_form_nonce'))) {
        wp_send_json(array("message" => "Access Denied! Invalid nonce."));
        die();
    }
    if (!session_id()) {
        session_start();
    }
    if (!isset($_SESSION["ope_form_token"])) {
        $ope_form_token = ope_getToken(64);
        $_SESSION["ope_form_token"] = $ope_form_token;
        session_write_close();
    }
    wp_send_json(array("token" => $_SESSION["ope_form_token"]));
    die();
}