<?php
if (!defined('ABSPATH')) {
    die('Access Denied!');
}

global $ope_form_panel_config;


// Handle email sending via AJAX
add_action('wp_ajax_send_email', 'send_email');
add_action('wp_ajax_nopriv_send_email', 'send_email');
function send_email()
{
    global $ope_form_panel_config;

    require 'ope-form-data.php';

    // Check for invalid strings (newline characters)
    if (strpos($content, '0x0A') !== false || strpos($content, '0x0D') !== false) {
        $callBack["to"] = ["status" => "failed", "code" => "Invalid String"];
        $callBack["reply"] = ["status" => "failed", "code" => "Invalid String"];
        echo json_encode($callBack);
        die();
    }

    // Set the "From" name and address
    $MAIL_FROM_NAME = @$ope_form_panel_config->email_from_name;
    $MAIL_FROM_ADDRESS = @$ope_form_panel_config->smtp_support == "on" ? @$ope_form_panel_config->smtp_name : @$ope_form_panel_config->email_from_address;

    if ($client_email !== '(undefined email)') {
        $MAIL_FROM_ADDRESS = $client_email;
        $MAIL_FROM_NAME = $client_name ?: '(undefined name)';
    }

    // Get receiver email address
    $receiver = @$ope_form_panel_config->recipient_administrator_email;
    if (!empty($admin_email_address)) {
        $admin_email_address = json_decode(stripslashes($admin_email_address));
        $admin_email_address = base64_decode($admin_email_address);
        $receiver = opeEncrypDecrypt::decrypt($admin_email_address);
    }
    $receiver = $receiver ? explode(",", $receiver) : [];

    // Prepare email subject
    $admin_mail_subject = @$ope_form_panel_config->admin_email_subject . '-' . date('Y-m-d H:i:s');
    if (!empty($admin_email_subject)) {
        $admin_email_subject_parsed = json_decode(stripslashes($admin_email_subject));
        $admin_email_subject_parsed = base64_decode($admin_email_subject_parsed);
        $admin_mail_subject = opeEncrypDecrypt::decrypt($admin_email_subject_parsed);
    }

    // Replace placeholders in subject
    $admin_mail_subject = str_replace("{{from_name}}", $client_name, $admin_mail_subject);
    $admin_mail_subject = str_replace("{{from_email}}", $client_email, $admin_mail_subject);
    $subject = $admin_mail_subject;
    $message = $content;
    $headers = ['Content-Type: text/html; charset=UTF-8', 'From: ' . $MAIL_FROM_NAME . ' <' . $MAIL_FROM_ADDRESS . '>'];

    // Add CC recipients if any
    $receiver_cc = @$ope_form_panel_config->recipient_administrator_email_cc;
    if (!empty($receiver_cc) && empty($custom_emails) && empty($admin_email_address)) {
        $receiver_cc = explode(",", $receiver_cc);
        foreach ($receiver_cc as $c) {
            $headers[] = 'Cc:' . $c;
        }
    }

    // Process attachments
    $attachments = process_attachments($fileNames);

    // Send the email
    $status = wp_mail($receiver, $subject, $message, $headers, $attachments);

    // Handle email failure
    if ($status == false) {
        handle_email_failure($attachments);
        $callBack["to"] = ["status" => "failed", "code" => "Message could not be sent"];
    } else {
        handle_successful_email($attachments);
        $callBack["to"] = ["status" => "success", "code" => "Message has been sent", "name" => $client_name ?: 'false'];
    }

    // Send auto-reply if enabled
    if (@$ope_form_panel_config->auto_reply == "on" && $client_email != '(undefined email)') {
        send_auto_reply($client_email,$reply_content);
    } else {
        $callBack["reply"] = ["status" => "failed", "code" => "Auto reply is disabled."];
    }

    // Clean up session data
    if (!session_id()) {
        session_start();
    }
    $_SESSION['thanks_token'] = true;
    foreach ($_SESSION as $key => $value) {
        if (strpos($key, 'captcha_code_') === 0) {
            unset($_SESSION[$key]);
        }
    }
    unset($_SESSION["ope_form_token"]);
    session_write_close();


    // Output the response
    echo json_encode($callBack);

    die();
}

// Handle email failure
function handle_email_failure($attachments)
{
    foreach ($attachments as $file) {
        unlink($file);
    }
    log_error('Admin Mail could not be sent.');
}

// Handle successful email
function handle_successful_email($attachments)
{
    foreach ($attachments as $file) {
        unlink($file);
    }
}

// Send auto-reply email
function send_auto_reply($client_email,$reply_content)
{
    global $ope_form_panel_config;
    $MAIL_FROM_NAME = @$ope_form_panel_config->email_from_name;
    $MAIL_FROM_ADDRESS = @$ope_form_panel_config->smtp_support == "on" ? @$ope_form_panel_config->smtp_name : @$ope_form_panel_config->email_from_address;
    $receiver = $client_email;

    $reply_mail_subject = @$ope_form_panel_config->auto_reply_email_subject;
    if (!empty($reply_email_subject)) {
        $reply_mail_subject_parsed = json_decode(stripslashes($reply_email_subject));
        $reply_mail_subject_parsed = base64_decode($reply_mail_subject_parsed);
        $reply_mail_subject = opeEncrypDecrypt::decrypt($reply_mail_subject_parsed);
    }

    $subject = $reply_mail_subject;
    $message = $reply_content;
    $headers = ['Content-Type: text/html; charset=UTF-8', 'From: ' . $MAIL_FROM_NAME . ' <' . $MAIL_FROM_ADDRESS . '>'];

    // Send auto-reply
    $status = wp_mail($receiver, $subject, $message, $headers);
    if ($status == false) {
        log_error('Auto reply Mail could not be sent.');
    }
}

// Process and return attachments
function process_attachments($fileNames)
{
    $attachments = [];
    $ope_form_class = new opeFormClass();
    if ($_FILES) {
        if (!empty($fileNames) && is_array($fileNames)) {
            foreach ($fileNames as $fn) {
                if (!empty($_FILES[$fn]['tmp_name'])) {
                    $unique_name = $ope_form_class->getName(5);
                    $file_path = dirname($_FILES[$fn]['tmp_name']);
                    $file_name = preg_replace('/\s+/', '_', $_FILES[$fn]['name']);
                    $new_file_uri = $file_path . '/' . $file_name;
                    $path_parts = pathinfo($new_file_uri);
                    $new_file_uri = $path_parts['filename'] . '-' . $unique_name . '.' . $path_parts['extension'];
                    $moved = copy($_FILES[$fn]['tmp_name'], $new_file_uri);
                    $attachments[] = $moved ? $new_file_uri : $_FILES[$fn]['tmp_name'];
                }
            }
        }
    }
    return $attachments;
}

// Log error to file with detailed context
function log_error($message, $context = [])
{
    global $ope_form_panel_config;
    $year = date('Y');
    $month = date('m');
    $day = date('d');
    $target = ABSPATH . @$ope_form_panel_config->file_upload_folder_name . "/Errorlogs/{$year}/{$month}/";

    // Ensure the log directory exists
    if (!file_exists($target)) {
        mkdir($target, 0777, true);
    }

    // Build the error message with additional context
    $error_message = "[" . date("Ymd-His") . "] " . $message . PHP_EOL;

    // Add additional context if provided
    if (!empty($context)) {
        foreach ($context as $key => $value) {
            $error_message .= "[Context: $key] " . print_r($value, true) . PHP_EOL;
        }
    }

    // Write the error message to the log file
    file_put_contents($target . "{$day}.log", $error_message, FILE_APPEND);
}

// Handle WP Mail error with additional details
add_action('wp_mail_failed', 'onMailError', 10, 1);
function onMailError($wp_error)
{
    // Additional context for the error
    $context = [
        'user_id' => get_current_user_id(), // Current user ID if available
        'user_email' => get_option('admin_email'), // Admin email or use recipient if available
        'request_data' => $_REQUEST, // Request data (potentially useful to see what was sent with the email)
        'wp_error_code' => $wp_error->get_error_code(), // WP error code for easier lookup
        'wp_error_message' => $wp_error->get_error_message(), // Detailed error message
    ];

    // Log the error with detailed context
    log_error('Mail sending failed', $context);
}