(function ($) {
    $.fn.lazyLoadImgInTheViewport = function () {
        var deviation = 300;
        if (deviation < 0 && (-deviation > (document.documentElement.clientHeight / 2))) {
            deviation = document.documentElement.clientHeight / 2;
        }
        var elementHeight = $(this)[0].offsetHeight;
        var bounding = $(this)[0].getBoundingClientRect();
        return bounding.top + deviation >= -elementHeight && bounding.bottom - deviation <= (window.innerHeight || document.documentElement.clientHeight) + elementHeight;
    }

    function lazyLoadAssets() {
        $('[data-lazy="loading"]').each(function () {
            var $this = $(this);
            if ($(this).lazyLoadImgInTheViewport()) {
                var $src = $this.data("lazyload-src");
                var $srcset = $this.data("lazyload-srcset");
                $this.attr("src", $src);
                $this.attr("srcset", $srcset);
                $this.attr("data-lazy", "loaded");
            }
        });
    }

    $(function () {
        lazyLoadAssets();
    });

    $(window).on("scroll", function () {
        lazyLoadAssets();
    });

})(jQuery);