<?php
function ten_optimized_setup()
{
    add_theme_support('title-tag');
    add_theme_support('post-thumbnails');
    add_theme_support('html5', array(
        'gallery',
        'caption',
    ));
}
add_action('after_setup_theme', 'ten_optimized_setup');

function ten_optimized_widgets_init()
{
    register_sidebar(array(
        'name' => 'Main Sidebar',
        'id' => 'sidebar-main',
        'description' => 'Add widgets here to appear in your sidebar.',
        'before_widget' => '<section id="%1$s" class="widget %2$s section-content">',
        'after_widget' => '</section>',
        'before_title' => '<h2 class="widget-title">',
        'after_title' => '</h2>',
    ));
}
add_action('widgets_init', 'ten_optimized_widgets_init');

function search_items_highlight($items)
{
    if (is_search()) {
        $words = explode(" ", get_search_query());
        $words = array_unique($words);
        foreach ($words as $s) {
            if ($s) {
                $items = preg_replace("/(" . $s . ")/i", "<mark>$1</mark>", $items);
            }
        }

    }
    return $items;
}
add_filter("the_title", "search_items_highlight", 300);
add_filter("the_excerpt", "search_items_highlight", 300);
add_filter("the_content", "search_items_highlight", 300);
