<?php
function archive_title($title)
{
    if (is_category()) {
        $title = single_cat_title('', false);
    } elseif (is_year()) {
        $title = get_the_date('Y');
    } elseif (is_month()) {
        $title = get_the_date('F Y');
    } elseif (is_day()) {
        $title = get_the_date('F j, Y');
    } elseif (is_tax()) {
        $title = single_cat_title('', false);
    }
    return $title;
}
add_filter('get_the_archive_title', 'archive_title');

function wpbx_excerpt_length($length)
{
    return 120;
}
add_filter('excerpt_length', 'wpbx_excerpt_length');

function excerpt_read_more_link($output)
{
    global $post;
    $output = mb_substr($output, 0, 80);
    return $output . '...';
}
add_filter('the_excerpt', 'excerpt_read_more_link');

function category_template($template)
{
    $category = get_queried_object();
    if ($category->parent != '0') {
        while ($category->parent != '0') {
            $category = get_category($category->parent);
        }
    }
    $templates = array();
    if ($category) {
        $templates[] = "category-{$category->slug}.php";
        $templates[] = "category-{$category->term_id}.php";
    }
    $templates[] = 'category.php';
    return locate_template($templates);
}
add_filter('category_template', 'category_template');
if (!function_exists('post_is_in_descendant_category')) {
    function post_is_in_descendant_category($cats, $_post = null)
    {
        foreach ((array) $cats as $cat) {
            $descendants = get_term_children((int) $cat, 'category');
            if ($descendants && in_category($descendants, $_post)) {
                return true;
            }

        }
        return false;
    }
}

function upload_media($filename)
{
    $parts = explode('.', $filename);
    $filename = array_shift($parts);
    $extension = array_pop($parts);
    foreach ((array) $parts as $part) {
        $filename .= '.' . $part;
    }

    if (preg_match('/[\x{4e00}-\x{9fa5}]+/u', $filename)) {
        $filename = substr(md5($filename), 0, 10);
    }
    $filename .= '.' . $extension;
    return $filename;
}
add_filter('sanitize_file_name', 'upload_media', 5, 1);

add_filter('style_loader_tag', 'cm_remove_type_attr', 10, 2);
add_filter('script_loader_tag', 'cm_remove_type_attr', 10, 2);

function cm_remove_type_attr($tag, $handle)
{
    return preg_replace("/ type=['\"]text\/(javascript|css)['\"]/", '', $tag);
}
