(function ($) {

    $.fn.lazyLoadImgInTheViewport = function (deviation) {
        if (!deviation) {
            deviation = 300;
        }
        if (deviation < 0 && (-deviation > (document.documentElement.clientHeight / 2))) {
            deviation = document.documentElement.clientHeight / 2;
        }
        let elementHeight = $(this)[0].offsetHeight;
        let bounding = $(this)[0].getBoundingClientRect();
        return bounding.top + deviation >= -elementHeight && bounding.bottom - deviation <= (window.innerHeight || document.documentElement.clientHeight) + elementHeight;
    }

    const lazyLoadBgImages = () => {
        $('[data-bg-lazy="loading-bg-img"]').each(function () {
            let $this = $(this);
            if ($(this).lazyLoadImgInTheViewport(100)) {
                $this.attr('data-bg-lazy', 'bg-img-loaded');
                let $src = $this.data("bg-src");
                let $downloadingImage = $("<img>");
                $downloadingImage.attr("src", $src);
                $downloadingImage.on('load', function () {
                    $this.css({
                        'background-image': function () {
                            return 'url(' + $src + ')';
                        }
                    });
                    $this.addClass("bg-loaded");
                });
            }
        });
    }

    const fetchPosts = async () => {
        if ($("body").hasClass("hold-scroll")) {
            return;
        }
        let $flag = $('[data-next-page]');
        if ($flag.length > 0) {
            if ($flag.lazyLoadImgInTheViewport()) {
                $("body").addClass("hold-scroll");
                let $pageNumber = $('[data-next-page]').data("next-page");
                if ($pageNumber > 0) {
                    $flag.remove();
                    try {
                        let url = script_ajax_object.ajax_url,
                            secureNonce = script_ajax_object.securecode;
                        let data = {
                            action: "fetch_posts",
                            page_string: $pageNumber,
                            security: secureNonce,
                        };
                        let res = await fetch(url, {
                            body: new URLSearchParams(data),
                            credentials: 'same-origin',
                            headers: {
                                'Content-Type': 'application/x-www-form-urlencoded',
                                'Cache-Control': 'no-cache',
                            },
                            method: "POST"
                        });
                        let response = await res.text();
                        let html = $($.parseHTML(response));
                        $('.container').append(html);
                        $('.container').masonry('appended', html);
                        lazyLoadBgImages();
                        $("body").removeClass("hold-scroll");
                        fetchPosts();
                    } catch (err) { }
                }
            }
        } else {
            $("body").addClass("hold-scroll");
            if ($("body").hasClass("start-loading")) {
                return;
            } else {
                $("body").addClass("start-loading");
            }
            try {
                let url = script_ajax_object.ajax_url,
                    secureNonce = script_ajax_object.securecode;
                let data = {
                    action: "fetch_posts",
                    security: secureNonce,
                };
                let res = await fetch(url, {
                    body: new URLSearchParams(data),
                    credentials: 'same-origin',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                        'Cache-Control': 'no-cache',
                    },
                    method: "POST"
                });
                let response = await res.text();
                let html = $($.parseHTML(response));
                $('.container').append(html);
                $('.container').masonry({
                    itemSelector: 'article',
                    transitionDuration: 0
                });
                lazyLoadBgImages();
                $("body").removeClass("hold-scroll");
                fetchPosts();
            } catch (err) { }
        }
    }


    document.addEventListener("DOMContentLoaded", function () {
        fetchPosts();
        lazyLoadBgImages();
    });

    window.addEventListener('scroll', () => {
        fetchPosts();
        lazyLoadBgImages();
    });

})(jQuery);