<?php
add_action('wp_ajax_fetch_posts', 'fetch_posts');
add_action('wp_ajax_nopriv_fetch_posts', 'fetch_posts');
function fetch_posts()
{
    $page = isset($_POST['page_string']) ? (int) $_POST['page_string'] : 1;
    $args = array(
        'post_type' => 'post',
        'posts_per_page' => 9,
        'post_status' => 'publish',
        'paged' => $page,
    );
    $main_query = new WP_Query($args);
    if ($main_query->have_posts()) {
        while ($main_query->have_posts()) {
            $main_query->the_post();
            global $post;
            $post_thumbnail_id = get_post_thumbnail_id($post->ID);
            $excerpt_original = get_the_excerpt($aid);
            $excerpt = mb_substr($excerpt_original, '0', '120');
            if (!empty($post_thumbnail_id)) {
                $thumbnail = wp_get_attachment_metadata($post_thumbnail_id);
                $origent = ($thumbnail['width']) / ($thumbnail['height']);
                $origent_reverse = ($thumbnail['height']) / ($thumbnail['width']);
                if ($origent > 1) {
                    $o = "landscape";
                } else {
                    $o = "portrait";
                }
                $pt = number_format((float) ($origent_reverse * 100), 2, '.', '') . '%';
                $img = get_the_post_thumbnail_url($post->ID, 'medium-large');
            }
            ?>
<article data-id="<?php echo get_the_ID(); ?>" data-origient="<?php echo $o; ?>">
    <a href="<?php echo get_the_permalink(); ?>" target="_blank"></a>
    <?php if (!empty($post_thumbnail_id)) {
                $colorPoll = array("#a2c9b7", "#dae0c4", "#8ba88a", "#cbe1ef", "#9acdde", "#5ea9bc", "#d5c2d5", "#ffddd3", "#e2e6c3", "#e6b451", "#ffcf56", "#b9d39c", "#97bebd", "#d7b0c2", "#c4d6da", "#ebd7c4");
                $rand_keys = $colorPoll[array_rand($colorPoll)];
                ?>
    <div class="post-thumbnail-wrapper" data-bg-src="<?php echo $img; ?>" style="padding-top:<?php echo $pt; ?>"
        data-bg-lazy="loading-bg-img">
        <div class="loading-mask" style="background-color:<?php echo $rand_keys; ?>;"></div>
    </div>
    <?php
}?>
    <?php if (!empty(get_the_title())) {
                ?>
    <div class="title_text">
        <?php
$author_id = get_the_author_meta('ID');
                $avatar = get_avatar($author_id, 64);
                if ($avatar) {
                    ?>
        <div class="small-avatar">
            <?php echo $avatar; ?>
        </div>
        <?php
}
                ?>
        <span><?php echo get_the_title(); ?><span>
    </div>
    <?php
}?>
    <?php if (!empty(get_the_excerpt())) {
                ?>
    <div class="excerpt_text"><?php echo $excerpt;
                echo mb_strlen($excerpt) < mb_strlen($excerpt_original) ? "..." : ""; ?></div>
    <?php
}?>
    <div class="date"><?php echo get_the_date('Y/m/d'); ?></div>
</article>
<?php
}
        //while ended
        $next = $page < $main_query->max_num_pages ? (intval($page) + 1) : '';
        if ($next != '') {
            ?>
<article data-next-page="<?php echo $next; ?>"></article>
<?php
}
    } else {
        echo '<div class="no-works">No works can be show.</div>';
    }
    wp_reset_postdata();
    die();
}