<?php
function is_dev_environment()
{
    if (function_exists('wp_get_environment_type')) {
        $environment_type = wp_get_environment_type();
        if (in_array($environment_type, array('local', 'development'))) {
            return true;
        }
    }

    $host = $_SERVER['HTTP_HOST'];
    $local_hosts = array('localhost', '127.0.0.1', '::1', 'local', 'dev.site');
    if (in_array($host, $local_hosts) || preg_match('/\b(dev|test|staging)\./', $host)) {
        return true;
    }

    $server_ip = $_SERVER['SERVER_ADDR'];
    $local_ips = array('127.0.0.1', '::1');
    if (in_array($server_ip, $local_ips)) {
        return true;
    }

    return false;
}

function dev_footer_script($mode = 'notification')
{
    $log_function = $mode === 'notification' ? 'console.warn' : 'console.error';
    ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const ogTitle = document.querySelector('meta[property="og:title"]');
            const ogDescription = document.querySelector('meta[property="og:description"]');
            const ogImage = document.querySelector('meta[property="og:image"]');

            if (!ogTitle || !ogDescription || !ogImage) {
                <?php echo esc_js($log_function); ?>('OPE25 Warning: Missing Open Graph Protocol tags!');
            }

            const metaDescription = document.querySelector('meta[name="description"]');
            if (!metaDescription) {
                <?php echo esc_js($log_function); ?>('OPE25 Warning: Missing Meta Description tag!');
            }

            const gaScript = document.querySelector('script[src*="googletagmanager.com"]');
            if (!gaScript) {
                <?php echo esc_js($log_function); ?>('OPE25 Warning: Missing Google Analytics code!');
            }
        });
    </script>
    <?php
}

if (is_dev_environment()) {
    add_filter('wp_footer', function () {
        dev_footer_script('notification');
    });
} else {
    add_filter('wp_footer', function () {
        dev_footer_script('error');
    });
}