<?php
add_filter('auto_update_core', '__return_false');
add_filter('auto_update_plugin', '__return_false');
add_filter('auto_update_theme', '__return_false');
add_filter('the_generator', '__return_empty_string');
add_filter('admin_email_check_interval', '__return_false');
add_filter('wp_is_application_passwords_available', '__return_false');
add_filter('do_redirect_guess_404_permalink', '__return_false');
add_filter('wp_sitemaps_enabled', '__return_false');
add_filter('login_display_language_dropdown', '__return_false');

function disable_wp_head_items()
{
    remove_action('wp_head', 'rsd_link');
    remove_action('wp_head', 'wlwmanifest_link');
    remove_action('wp_head', 'wp_generator');
    remove_action('wp_head', 'wp_shortlink_wp_head');
    remove_action('wp_head', 'feed_links', 2);
    remove_action('wp_head', 'feed_links_extra', 3);
    remove_action('wp_head', 'rest_output_link_wp_head');
    remove_action('wp_head', 'wp_resource_hints', 2);
    remove_action('admin_print_styles', 'print_emoji_styles');
    remove_action('wp_head', 'print_emoji_detection_script', 7);
    remove_action('admin_print_scripts', 'print_emoji_detection_script');
    remove_action('wp_print_styles', 'print_emoji_styles');
    remove_filter('wp_mail', 'wp_staticize_emoji_for_email');
    remove_filter('the_content_feed', 'wp_staticize_emoji');
    remove_filter('comment_text_rss', 'wp_staticize_emoji');
}
add_action('init', 'disable_wp_head_items');

add_filter('xmlrpc_enabled', '__return_false');

function remove_admin_menus()
{
    remove_menu_page('edit-comments.php');
}

add_action('admin_menu', 'remove_admin_menus');

add_action('init', 'remove_comment_support', 100);

function remove_comment_support()
{
    remove_post_type_support('post', 'comments');
    remove_post_type_support('page', 'comments');
}

function d78596_admin_bar_render()
{
    global $wp_admin_bar;
    $wp_admin_bar->remove_menu('comments');
}
add_action('wp_before_admin_bar_render', 'd78596_admin_bar_render');

function remove_post_metaboxes()
{
    remove_meta_box('commentstatusdiv', 'post', 'normal');
    remove_meta_box('commentsdiv', 'post', 'normal');
    remove_meta_box('trackbacksdiv', 'post', 'normal');
    remove_meta_box('commentstatusdiv', 'post', 'normal');

}
add_action('admin_menu', 'remove_post_metaboxes');

function remove_jquery_migrate($scripts)
{
    if (!is_admin() && isset($scripts->registered['jquery'])) {
        $script = $scripts->registered['jquery'];

        if ($script->deps) {
            $script->deps = array_diff($script->deps, array(
                'jquery-migrate',
            ));
        }
    }
}
add_action('wp_default_scripts', 'remove_jquery_migrate');

function remove_dashboard_widgets()
{
    remove_meta_box('dashboard_right_now', 'dashboard', 'normal');
    remove_meta_box('dashboard_recent_comments', 'dashboard', 'normal');
    remove_meta_box('dashboard_incoming_links', 'dashboard', 'normal');
    remove_meta_box('dashboard_plugins', 'dashboard', 'normal');
    remove_meta_box('dashboard_quick_press', 'dashboard', 'side');
    remove_meta_box('dashboard_recent_drafts', 'dashboard', 'side');
    remove_meta_box('dashboard_primary', 'dashboard', 'side');
    remove_meta_box('dashboard_secondary', 'dashboard', 'side');
    remove_meta_box('dashboard_activity', 'dashboard', 'side');
    remove_meta_box('dashboard_site_health', 'dashboard', 'normal');
    remove_action('welcome_panel', 'wp_welcome_panel');

    global $wp_meta_boxes;
    unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_activity']);
}
add_action('wp_dashboard_setup', 'remove_dashboard_widgets');

class Password_Reset_Removed
{

    public function __construct()
    {
        add_filter('show_password_fields', array($this, 'disable'));
        add_filter('allow_password_reset', array($this, 'disable'));
        add_filter('gettext', array($this, 'remove'));
    }

    public function disable()
    {
        if (is_admin()) {
            $userdata = wp_get_current_user();
            $user = new WP_User($userdata->ID);
            if (!empty($user->roles) && is_array($user->roles) && $user->roles[0] == 'administrator') {
                return true;
            }

        }
        return false;
    }

    public function remove($text)
    {
        return str_replace(array('Lost your password?', 'Lost your password'), '', trim($text, '?'));
    }
}

$pass_reset_removed = new Password_Reset_Removed();

function disable_pingbacks($methods)
{
    unset($methods['pingback.ping']);
    unset($methods['pingback.extensions.getPingbacks']);
    return $methods;
}
add_filter('xmlrpc_methods', 'disable_pingbacks');


function disable_gravatars($avatar)
{
    return '';
}
add_filter('get_avatar', 'disable_gravatars');


function disable_dashicons_for_non_admins()
{
    if (!is_admin() && !current_user_can('administrator')) {
        wp_deregister_style('dashicons');
    }
}
add_action('wp_enqueue_scripts', 'disable_dashicons_for_non_admins');

function disable_rss_feeds()
{
    wp_die(__('RSS feeds are disabled.'));
}
add_action('do_feed', 'disable_rss_feeds', 1);
add_action('do_feed_rdf', 'disable_rss_feeds', 1);
add_action('do_feed_rss', 'disable_rss_feeds', 1);
add_action('do_feed_rss2', 'disable_rss_feeds', 1);
add_action('do_feed_atom', 'disable_rss_feeds', 1);