<?php
function archive_title($title)
{
    if (is_category()) {
        $title = single_cat_title('', false);
    } elseif (is_year()) {
        $title = get_the_date('Y');
    } elseif (is_month()) {
        $title = get_the_date('F Y');
    } elseif (is_day()) {
        $title = get_the_date('F j, Y');
    } elseif (is_tax()) {
        $title = single_term_title('', false);
    }
    return esc_html($title);
}
add_filter('get_the_archive_title', 'archive_title');

define('EXCERPT_LENGTH', 120);
function wpbx_excerpt_length($length)
{
    return EXCERPT_LENGTH;
}
add_filter('excerpt_length', 'wpbx_excerpt_length');

function excerpt_read_more_link($output)
{
    $output = mb_substr($output, 0, 80);
    return $output . '... <a href="' . get_permalink() . '">Read More</a>';
}
add_filter('the_excerpt', 'excerpt_read_more_link');

function category_template($template)
{
    $category = get_queried_object();
    if ($category->parent != '0') {
        while ($category->parent != '0') {
            $category = get_category($category->parent);
        }
    }
    $templates = array();
    if ($category) {
        $templates[] = "category-{$category->slug}.php";
        $templates[] = "category-{$category->term_id}.php";
    }
    $templates[] = 'category.php';
    return locate_template($templates);
}
add_filter('category_template', 'category_template');


if (!function_exists('post_is_in_descendant_category')) {
    function post_is_in_descendant_category($cats, $_post = null)
    {
        $ancestors = get_ancestors(get_the_ID(), 'category');
        return !empty(array_intersect($cats, $ancestors));
    }
}

function upload_media($filename)
{
    $parts = explode('.', $filename);
    $filename = array_shift($parts);
    $extension = array_pop($parts);
    $filename = sanitize_title($filename);
    $filename .= '.' . $extension;
    return $filename;
}
add_filter('sanitize_file_name', 'upload_media', 5, 1);

if (!is_admin()) {
    add_filter('style_loader_tag', 'ope25_remove_type_attr', 10, 2);
    add_filter('script_loader_tag', 'ope25_remove_type_attr', 10, 2);
}

function ope25_remove_type_attr($tag, $handle)
{
    return preg_replace("/ type=['\"]text\/(javascript|css)['\"]/", '', $tag);
}