(function ($) {
    $(function () {
        const OPE_random_string = (length) => {
            let chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
            let str = '';
            for (let i = 0; i < length; i++) {
                str += chars.charAt(Math.floor(Math.random() * chars.length));
            }
            return str;
        };
        $("#ope_regenerate_random_string").on("click", function () {
            $("#hide_login_url").val(OPE_random_string(10));
            $(".ope-hide-login-panel .has-code").removeClass("has-code");
        });
        $("#set_ope_hide_login").on("click", function () {
            const $this = $(this);
            $this.addClass("hold");
            $this.addClass("processing");
            (async () => {
                const body = {
                    url: $("#hide_login_url").val().trim(),
                    redirection_url: $("#hide_login_redirection_url").val().trim(),
                    action: "saveOPEHideLogin"
                };
                const urlRequest = ope_hide_login_object.ajaxurl;
                const siteUrl = ope_hide_login_object.siteurl;
                const response = await fetch(urlRequest, {
                    method: "POST",
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                        'Cache-Control': 'no-cache',
                    },
                    credentials: 'same-origin',
                    body: new URLSearchParams(body),
                });
                const data = await response.json();
                if (data.status == "OK") {
                    if (data.type == "new") {
                        $("#ope_hide_login_url").attr("data-url", siteUrl + "/" + data.url + "/").removeClass("hide").addClass("show");
                    } else {
                        $("#ope_hide_login_url").attr("data-url", siteUrl + "/wp-login.php").removeClass("hide").addClass("show");
                    }
                    $this.removeClass("processing");
                    $this.find("span").html("Success");
                    setTimeout(function () {
                        $this.find("span").html("Save");
                        $this.removeClass("hold");
                        location.reload();
                    }, 500);
                } else if (data.status == "BAD") {
                    $this.find("span").html("Faild! Try Again!");
                    setTimeout(function () {
                        $this.find("span").html("Save");
                        $this.removeClass("hold");
                    }, 2000);
                } else {
                    $this.find("span").html("Unknown Error!");
                    setTimeout(function () {
                        $this.find("span").html("Save");
                        $this.removeClass("hold");
                    }, 2000);
                }
            })();
        });
        function copyToClipboard(textToCopy) {
            if (navigator.clipboard && window.isSecureContext) {
                return navigator.clipboard.writeText(textToCopy);
            } else {
                let textArea = document.createElement("textarea");
                textArea.value = textToCopy;
                textArea.style.position = "absolute";
                textArea.style.opacity = 0;
                textArea.style.left = "-999999px";
                textArea.style.top = "-999999px";
                document.body.appendChild(textArea);
                textArea.focus();
                textArea.select();
                return new Promise((res, rej) => {
                    document.execCommand('copy') ? res() : rej();
                    textArea.remove();
                });
            }
        }
        $("#ope_hide_login_url").on("click", function () {
            let $string = $(this).attr("data-url");
            let $return = copyToClipboard($string);
            $return.then(function () {
                alert("Copied!");
            }, function () {
                alert("Faild!");
            });
        });
        $("#disable_ope_hide_login").on("click", function () {
            const $this = $(this);
            $this.addClass("hold");
            $this.addClass("processing");
            (async () => {
                const body = {
                    url: '',
                    redirection_url: '',
                    action: "saveOPEHideLogin"
                };
                const urlRequest = ope_hide_login_object.ajaxurl;
                const siteUrl = ope_hide_login_object.siteurl;
                const response = await fetch(urlRequest, {
                    method: "POST",
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                        'Cache-Control': 'no-cache',
                    },
                    credentials: 'same-origin',
                    body: new URLSearchParams(body),
                });
                const data = await response.json();
                if (data.status == "OK") {
                    $("#ope_hide_login_url").attr("data-url", siteUrl + "/wp-login.php").removeClass("hide").addClass("show");
                    $this.removeClass("processing");
                    $this.find("span").html("Disabled!");
                    setTimeout(function () {
                        $this.find("span").html("Disable");
                        $this.removeClass("hold");
                        location.reload();
                    }, 500);
                } else if (data.status == "BAD") {
                    $this.find("span").html("Faild! Try Again!");
                    setTimeout(function () {
                        $this.find("span").html("Disable");
                        $this.removeClass("hold");
                    }, 2000);
                } else {
                    $this.find("span").html("Unknown Error!");
                    setTimeout(function () {
                        $this.find("span").html("Disable");
                        $this.removeClass("hold");
                    }, 2000);
                }
            })();
        });
    });
})(jQuery);