<?php
if (!defined('ABSPATH')) {
    die('Access Denied!');
}

require get_template_directory() . '/pack/hide-login/admin/ajax.php';
require get_template_directory() . '/pack/hide-login/plugin.php';

if (!class_exists("ope_hide_login_menu_page")) {
    class ope_hide_login_menu_page
    {
        public function add_menu_page()
        {
            add_menu_page(
                'OPE Hide Login',
                'OPE Hide Login',
                'manage_options',
                'ope_hide_login_admin_settings',
                array($this, 'ope_hide_login_admin'),
                get_template_directory_uri() . '/pack/hide-login/assets/img/ope-hide-login.png',
                500
            );
        }

        public function ope_hide_login_admin()
        {

            require get_template_directory() . '/pack/hide-login/admin/ope_hide_login_admin.php';
        }

        public function add_page()
        {
            add_action('admin_menu', array($this, 'add_menu_page'));
        }

        public function ope_hide_login_enqueue()
        {
            wp_enqueue_style('ope-hide-login-main', get_template_directory_uri() . '/pack/hide-login/assets/css/style.css', array(), crc32(date("YmdH")), 'all');
            wp_enqueue_script('ope-hide-login-script', get_template_directory_uri() . '/pack/hide-login/assets/js/script.js', array(), crc32(date("YmdH")), true);
            wp_localize_script('ope-hide-login-script', 'ope_hide_login_object', array(
                'ajaxurl' => admin_url('admin-ajax.php'),
                'siteurl' => get_option("siteurl"),
            ));
        }

        public function enqueue()
        {
            add_action('admin_enqueue_scripts', array($this, 'ope_hide_login_enqueue'));
        }
    }
}
$ope_hide_login_add_menu_page = new ope_hide_login_menu_page();
$ope_hide_login_add_menu_page->add_page();
$ope_hide_login_add_menu_page->enqueue();
