<?php
if (!defined('ABSPATH')) {
    die('Access Denied!');
}
class OPE_HIDE_LOGIN_URL
{
    private $wp_login_php;
    public function init()
    {
        add_action('init', array($this, 'plugins_loaded'), 9999);
        add_action('wp_loaded', array($this, 'wp_loaded'));
        add_action('setup_theme', array($this, 'setup_theme'), 1); // /wp-admin/customize.php "This has been disabled"
        add_filter('site_url', array($this, 'site_url'), 10, 4);
        add_filter('network_site_url', array($this, 'network_site_url'), 10, 3);
        add_filter('wp_redirect', array($this, 'wp_redirect'), 10, 2);
        add_filter('site_option_welcome_email', array($this, 'welcome_email'));
        remove_action('template_redirect', 'wp_redirect_admin_locations', 1000); // If a user visits example.com/admin, they’ll be redirected to /wp-admin. Visiting /login redirects to /wp-login.php, and so on.
        add_action('template_redirect', array($this, 'redirect_export_data'));
        add_filter('login_url', array($this, 'login_url'), 10, 3);
        add_filter('user_request_action_email_content', array($this, 'user_request_action_email_content'), 999, 2);
    }
    public function user_request_action_email_content($email_text, $email_data)
    {
        $email_text = str_replace('###CONFIRM_URL###', esc_url_raw(str_replace($this->new_login_slug() . '/', 'wp-login.php', $email_data['confirm_url'])), $email_text);
        return $email_text;
    }
    private function use_trailing_slashes()
    {
        return ('/' === substr(get_option('permalink_structure'), -1, 1));
    }
    private function user_trailingslashit($string)
    {
        return $this->use_trailing_slashes() ? trailingslashit($string) : untrailingslashit($string);
    }
    private function wp_template_loader()
    {
        global $pagenow;
        $pagenow = 'index.php';
        if (!defined('WP_USE_THEMES')) {
            define('WP_USE_THEMES', true);
        }
        wp();
        require_once ABSPATH . WPINC . '/template-loader.php';
        die;
    }
    private function new_login_slug($blog_id = '')
    {
        if ($blog_id) {
            if ($slug = get_blog_option($blog_id, 'ope_hide_login_url')) {
                return $slug;
            }
        } else {
            if ($slug = get_option('ope_hide_login_url')) {
                return $slug;
            } else if ((is_multisite() && is_plugin_active_for_network(OPE_HIDE_LOGIN_BASENAME) && ($slug = get_site_option('ope_hide_login_url', 'login')))) {
                return $slug;
            } else if ($slug = 'login') {
                return $slug;
            }
        }
    }
    private function new_redirect_slug()
    {
        if ($slug = get_option('ope_hide_login_redirection_url')) {
            return $slug;
        } else if ((is_multisite() && is_plugin_active_for_network(OPE_HIDE_LOGIN_BASENAME) && ($slug = get_site_option('ope_hide_login_redirection_url', '404')))) {
            return $slug;
        } else if ($slug = '404') {
            return $slug;
        }
    }
    public function new_login_url($scheme = null)
    {
        $url = apply_filters('ope_hide_login_home_url', home_url('/', $scheme));
        if (get_option('permalink_structure')) {
            return $this->user_trailingslashit($url . $this->new_login_slug());
        } else {
            return $url . '?' . $this->new_login_slug();
        }
    }
    public function new_redirect_url($scheme = null)
    {
        if (get_option('permalink_structure')) {
            return $this->user_trailingslashit(home_url('/', $scheme) . $this->new_redirect_slug());
        } else {
            return home_url('/', $scheme) . '?' . $this->new_redirect_slug();
        }
    }
    public function redirect_export_data()
    {
        if (!empty($_GET) && isset($_GET['action']) && 'confirmation' === $_GET['action'] && isset($_GET['request_id']) && isset($_GET['confirm_key'])) {
            $request_id = (int) $_GET['request_id'];
            $key = sanitize_text_field(wp_unslash($_GET['confirm_key']));
            $result = wp_validate_user_request_key($request_id, $key);
            if (!is_wp_error($result)) {
                wp_redirect(add_query_arg(array(
                    'action' => 'confirmation',
                    'request_id' => $_GET['request_id'],
                    'confirm_key' => $_GET['confirm_key'],
                ), $this->new_login_url()
                ));
                exit();
            }
        }
    }

    public function getRandomString()
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $randomString = '';

        for ($i = 0; $i < 10; $i++) {
            $index = rand(0, strlen($characters) - 1);
            $randomString .= $characters[$index];
        }

        return $randomString;
    }

    public function plugins_loaded()
    {
        global $pagenow;
        if (!is_multisite() && (strpos(rawurldecode($_SERVER['REQUEST_URI']), 'wp-signup') !== false
            || strpos(rawurldecode($_SERVER['REQUEST_URI']), 'wp-activate') !== false) && apply_filters('ope_hide_login_signup_enable', false) === false) {
            wp_die('This feature is not enabled.');
        }
        $request = parse_url(rawurldecode($_SERVER['REQUEST_URI']));
        if ((strpos(rawurldecode($_SERVER['REQUEST_URI']), 'wp-login.php') !== false
            || (isset($request['path']) && untrailingslashit($request['path']) === site_url('wp-login', 'relative')))
            && !is_admin()) {
            $this->wp_login_php = true;
            $_SERVER['REQUEST_URI'] = $this->user_trailingslashit('/' . str_repeat('-/', 10));
            $pagenow = 'index.php';
        } elseif ((isset($request['path']) && untrailingslashit($request['path']) === home_url($this->new_login_slug(), 'relative'))
            || (!get_option('permalink_structure')
                && isset($_GET[$this->new_login_slug()])
                && empty($_GET[$this->new_login_slug()]))) {
            $pagenow = 'wp-login.php';
        } elseif ((strpos(rawurldecode($_SERVER['REQUEST_URI']), 'wp-register.php') !== false
            || (isset($request['path']) && untrailingslashit($request['path']) === site_url('wp-register', 'relative')))
            && !is_admin()) {
            $this->wp_login_php = true;
            $_SERVER['REQUEST_URI'] = $this->user_trailingslashit('/' . str_repeat('-/', 10));
            $pagenow = 'index.php';
        }
    }
    public function setup_theme()
    {
        global $pagenow;
        if (!is_user_logged_in() && 'customize.php' === $pagenow) {
            wp_die('This has been disabled', 403);
        }
    }
    public function wp_loaded()
    {
        global $pagenow;
        $request = parse_url(rawurldecode($_SERVER['REQUEST_URI']));
        do_action('ope_hide_login_before_redirect', $request);
        if (!(isset($_GET['action']) && $_GET['action'] === 'postpass' && isset($_POST['post_password']))) {
            if (is_admin() && !is_user_logged_in() && !defined('WP_CLI') && !defined('DOING_AJAX') && !defined('DOING_CRON') && $pagenow !== 'admin-post.php' && $request['path'] !== '/wp-admin/options.php') {
                wp_safe_redirect($this->new_redirect_url());
                die();
            }
            if (!is_user_logged_in() && isset($_GET['wc-ajax']) && $pagenow === 'profile.php') {
                wp_safe_redirect($this->new_redirect_url());
                die();
            }
            if (!is_user_logged_in() && isset($request['path']) && $request['path'] === '/wp-admin/options.php') {
                header('Location: ' . $this->new_redirect_url());
                die;
            }
            if ($pagenow === 'wp-login.php' && isset($request['path']) && $request['path'] !== $this->user_trailingslashit($request['path']) && get_option('permalink_structure')) {
                wp_safe_redirect($this->user_trailingslashit($this->new_login_url())
                    . (!empty($_SERVER['QUERY_STRING']) ? '?' . $_SERVER['QUERY_STRING'] : ''));
                die;
            } elseif ($this->wp_login_php) {
                if (($referer = wp_get_referer())
                    && strpos($referer, 'wp-activate.php') !== false
                    && ($referer = parse_url($referer))
                    && !empty($referer['query'])) {
                    parse_str($referer['query'], $referer);
                    @require_once WPINC . '/ms-functions.php';
                    if (!empty($referer['key'])
                        && ($result = wpmu_activate_signup($referer['key']))
                        && is_wp_error($result)
                        && ($result->get_error_code() === 'already_active'
                            || $result->get_error_code() === 'blog_taken')) {
                        wp_safe_redirect($this->new_login_url()
                            . (!empty($_SERVER['QUERY_STRING']) ? '?' . $_SERVER['QUERY_STRING'] : ''));
                        die;
                    }
                }
                $this->wp_template_loader();
            } elseif ($pagenow === 'wp-login.php') {
                global $error, $interim_login, $action, $user_login;
                $redirect_to = admin_url();
                $requested_redirect_to = '';
                if (isset($_REQUEST['redirect_to'])) {
                    $requested_redirect_to = $_REQUEST['redirect_to'];
                }
                if (is_user_logged_in()) {
                    $user = wp_get_current_user();
                    if (!isset($_REQUEST['action'])) {
                        $logged_in_redirect = apply_filters('ope_logged_in_redirect', $redirect_to, $requested_redirect_to, $user);
                        wp_safe_redirect($logged_in_redirect);
                        die();
                    }
                }
                @require_once ABSPATH . 'wp-login.php';
                die;
            }
        }
    }
    public function site_url($url, $path, $scheme, $blog_id)
    {
        return $this->filter_wp_login_php($url, $scheme);
    }
    public function network_site_url($url, $path, $scheme)
    {
        return $this->filter_wp_login_php($url, $scheme);
    }
    public function wp_redirect($location, $status)
    {
        if (strpos($location, 'https://wordpress.com/wp-login.php') !== false) {
            return $location;
        }
        return $this->filter_wp_login_php($location);
    }
    public function filter_wp_login_php($url, $scheme = null)
    {
        if (strpos($url, 'wp-login.php?action=postpass') !== false) {
            return $url;
        }
        if (strpos($url, 'wp-login.php') !== false && strpos(wp_get_referer(), 'wp-login.php') === false) {
            if (is_ssl()) {
                $scheme = 'https';
            }
            $args = explode('?', $url);
            if (isset($args[1])) {
                parse_str($args[1], $args);
                if (isset($args['login'])) {
                    $args['login'] = rawurlencode($args['login']);
                }
                $url = add_query_arg($args, $this->new_login_url($scheme));
            } else {
                $url = $this->new_login_url($scheme);
            }
        }
        return $url;
    }
    public function welcome_email($value)
    {
        return $value = str_replace('wp-login.php', trailingslashit(get_site_option('ope_hide_login_url', 'login')), $value);
    }
    public function forbidden_slugs()
    {
        $wp = new \WP;
        return array_merge($wp->public_query_vars, $wp->private_query_vars);
    }
    public function ope_hide_login_menu_page()
    {
        $title = __('OPE Hide Login');
        add_options_page($title, $title, 'manage_options', 'ope_settings', array(
            $this,
            'settings_page',
        ));
    }
    public function settings_page()
    {
        _e('OPE Hide Login');
    }
    public function login_url($login_url, $redirect, $force_reauth)
    {
        if (is_404()) {
            return '#';
        }
        if ($force_reauth === false) {
            return $login_url;
        }
        if (empty($redirect)) {
            return $login_url;
        }
        $redirect = explode('?', $redirect);
        if ($redirect[0] === admin_url('options.php')) {
            $login_url = admin_url();
        }
        return $login_url;
    }
}
$hide_login_url = get_option("ope_hide_login_url");
if (!empty($hide_login_url)) {
    $OPE_HIDE_LOGIN_URL = new OPE_HIDE_LOGIN_URL();
    $OPE_HIDE_LOGIN_URL->init();
}
