<style type="text/css">
	.vopam-wrapper {
		overflow: hidden;
		padding: 15px 25px 10px;
		box-sizing: border-box;
		background-color: #fff;
		border-left: 4px solid #fff;
		border-left-color: rgb(255, 255, 255);
		box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);
		margin-top: 20px;
		margin-right: 20px;
	}
	
	.vopam-wrapper h3 {
		font-size: 24px;
		display: block;
		font-weight: bold;
		margin-bottom: 15px;
		margin-top: 15px;
	}
	
	.vopam-wrapper h4 {
		font-size: 16px;
		display: block;
		font-weight: bold;
		margin-bottom: 15px;
	}
	
	.vopam-wrapper ul {
		list-style: none;
		margin: 0;
		padding: 0 0 0 1.2em;
		border-left: 2px solid #46b450;
	}
	
	.vopam-wrapper ul li {
		font-size: 12px;
		text-transform: capitalize;
		display: flex;
		align-items: center;
		justify-content: flex-start;
	}
	
	.vopam-wrapper ul li input {
		margin-right: 5px;
	}
	
	.notice,
	div.error,
	div.updated {
		padding: 6px 12px;
		margin-top: 20px;
		margin-left: 0;
		margin-right: 20px;
	}
</style>
<div class="vopam-wrapper">
	<h3>
		<?php esc_html_e('VOPAM - Options', 'vopmobyone'); ?>
	</h3>
	<form method="post" action="options-general.php?page=vopam.php">
		<?php	if (count($post_types)>0) {?>
		<h4>
			<?php esc_html_e('Exclude Custom Post Types:', 'vopmobyone'); ?>
		</h4>
		<div class="vopam-options">
			<ul>
				<?php
				foreach ( $post_types as $post_type ) {
					if ( in_array( $post_type, $exclude_custom_post_types ) ) {
						$checked = 'checked="checked"';
					} else {
						$checked = '';
					}
					?>
				<li><input type="checkbox" name="exclude_custom_post_types[]" id="<?php echo $post_type;?>" value="<?php echo $post_type;?>" <?php echo $checked; ?> />
					<label for="<?php echo $post_type;?>">
						<?php echo $post_type;?>
					</label>
				</li>
				<?php }?>
			</ul>
		</div>
		<?php } ?>
		<?php wp_nonce_field('vopam-by-onepxeye'); ?>
		<div class="submit">
			<input type="submit" class="button-primary" name="View_Own_PAM_Only_update" value="<?php _e('Update', 'vopmobyone') ?>"/>
		</div>
	</form>
</div>