<?php
Class LILILogin {
    const _AUTHORIZE_URL = 'https://www.linkedin.com/uas/oauth2/authorization';
    const _TOKEN_URL = 'https://www.linkedin.com/uas/oauth2/accessToken';
    const _BASE_URL = 'https://api.linkedin.com/v1';
    public $li_api_key;
    public $li_secret_key;
    public $access_token;
    public $oauth;
    public $user_redirect = false;
    public $li_options;
    public function __construct() {
        add_action('login_form', array($this, 'display_login_button'));
        add_action('init', array($this, 'process_login'));
        $li_keys = get_option('LILI_basic_options');
        $this->li_api_key = $li_keys['li_api_key'];
        $this->li_secret_key = $li_keys['li_secret_key'];
        $this->li_options = get_option('LILI_basic_options');
        add_shortcode('lili_button', array($this, 'get_login_link'));
        require_once(LILI_PATH . '/includes/lib/LILI_OAuth2Client.php');
        $this->oauth = new LILI_OAuth2Client($this->li_api_key, $this->li_secret_key);
        $this->oauth->redirect_uri = wp_login_url() . '?action=LILI_login';
        $this->oauth->authorize_url = self::_AUTHORIZE_URL;
        $this->oauth->token_url = self::_TOKEN_URL;
        $this->oauth->api_base_url = self::_BASE_URL;
        if (get_current_user_id()) {
            $this->oauth->access_token = get_user_meta(get_current_user_id(), 'LILI_access_token', true);
        }        
        if (!session_id()) {
            session_start();
        }
    }
    public function get_auth_url($redirect = false) {
        $state = wp_generate_password(12, false);
        $authorize_url = $this->oauth->authorizeUrl(array('scope' => 'r_basicprofile r_emailaddress',
            'state' => $state));
        if (!isset($_SESSION['li_api_state'])) {
            $_SESSION['li_api_state'] = $state;
        }
        $_SESSION['li_api_redirect'] = $redirect;
        return $authorize_url;
    }
    public function display_login_button() {
        echo "<p><a rel='nofollow' href='" . $this->get_auth_url() . "'>
                                            <img style='width:140px;display:block;margin:0 auto 15px;' alt='LinkedIn' src='" . plugins_url() . "/linkedin-login-onepxeye/includes/assets/img/linkedin-login.svg' />
        </a></p>";
    }
    function process_login() {
        if (!$this->is_linkedin_signin()) {
            return;
        }
        if (isset($_REQUEST['error']) && $_REQUEST['error'] == 'access_denied') {
            $cancel_redirect_url = $this->li_options['li_cancel_redirect_url'];
            if (empty($cancel_redirect_url)) {
                wp_redirect(wp_login_url());
            }
            wp_safe_redirect($cancel_redirect_url);
        }
        if (isset($_REQUEST['error'])) {
            $error = $_REQUEST['error'];
            $error_description = $_REQUEST['error_description'];
            error_log("WP_LinkedIn Login Error\nError: $error\nDescription: $error_description");
        }
        $xml = $this->get_linkedin_profile();
        $user_id = $this->authenticate_user($xml);
        wp_set_auth_cookie($user_id);
        wp_set_current_user($user_id);
        update_user_meta($user_id, 'LILI_access_token', $this->access_token, true);
        do_action('LILI_linkedin_authenticated', $user_id);
        if (filter_var($this->user_redirect, FILTER_VALIDATE_URL, FILTER_FLAG_HOST_REQUIRED)) {
            wp_safe_redirect($this->user_redirect);
        }
        else {
            wp_redirect(admin_url());
        }
    }
    private function get_linkedin_profile() {
        $this->oauth->curl_authenticate_method = 'GET';
        $response = $this->oauth->authenticate($_REQUEST['code']);
        $this->access_token = $response->{'access_token'};
        $xml = simplexml_load_string($this->oauth->get('https://api.linkedin.com/v1/people/~:(id,first-name,last-name,email-address,headline,specialties,positions:(id,title,summary,start-date,end-date,is-current,company),summary,site-standard-profile-request,picture-url,location:(name,country:(code)),industry)'));
        return $xml;
    }
    private function is_linkedin_signin() {
        if (!isset($_REQUEST['action']) || ($_REQUEST['action'] != "LILI_login")) {
            return false;
        }
        if (!isset($_REQUEST['code']) && !isset($_REQUEST['error'])) {
            return false;
        }
        unset($_SESSION['li_api_state']);
        return true;
    }
    private function authenticate_user($xml) {
        wp_logout();
          $this->user_redirect = $_SESSION['li_api_redirect'];
       $email = (string) $xml->{'email-address'};
        $linkedin_id = (string) $xml->{'id'};
       $user_by_id = get_users(array('meta_key' => 'LILI_linkedin_id',
            'meta_value' => $linkedin_id));
        if (count($user_by_id) == 1) {
            $user_id = $user_by_id[0]->ID;
            if ($_SESSION['li_api_redirect'] === false) {
                $this->user_redirect = $this->li_options['li_redirect_url'];
            }
            if ($this->li_options['li_auto_profile_update'] == 'yes') {
                $this->update_user_data($xml, $user_id);
            }
            do_action('LILI_login', $user_id);
            
            return $user_id;
        }
        elseif (email_exists($email)) {
            $user = get_user_by('email', $email);
          
            if ($_SESSION['li_api_redirect'] === false) {
               
                $this->user_redirect = $this->li_options['li_registration_redirect_url'];
            }
          
            if ($this->li_options['li_auto_profile_update'] == 'yes') {
                $this->update_user_data($xml, $user->ID);
            }
            
          
            do_action('LILI_first_login', $user->ID);
            
          
            return $user->ID;
        }
       
        elseif (is_email($email)) {
          
            $user_id = wp_create_user($email, wp_generate_password(16), $email);
           
            $this->user_redirect = $this->li_options['li_registration_redirect_url'];
          
            $this->update_user_data($xml, $user_id);
            
           
            do_action('LILI_registration', $user_id);
            return $user_id;
        }
        
        return false;
    }
   
    public function get_login_link($attributes = false) {
        if (is_user_logged_in()) {
                 if (is_user_logged_in()) {
          return $this->li_options['li_logged_in_message'];
        }

        }
        
        extract(shortcode_atts(array('text' => 'Login With LinkedIn', 'img' => LILI_URL . 'includes/assets/img/linkedin-login.svg', 'redirect' => false, 'class' => ''), $attributes));
        $auth_url = $this->get_auth_url($redirect);
        
        if (isset($attributes['img'])) {
            return "<a href='" . $auth_url . "' class='$class'><img src='" . $img . "' /></a>";
        }
  
        if (isset($attributes['text'])) {
            return "<a href='" . $auth_url . "' class='$class'>" . $text . "</a>";
        }
  
        return "<a href='" . $auth_url . "' class='$class'><img src='" . $img . "' /></a>";
    }
   
    private function update_user_data($xml, $user_id = false) {
        $first_name = (string) $xml->{'first-name'};
        $last_name = (string) $xml->{'last-name'};
        $description = (string) $xml->{'summary'};
        $linkedin_url = (string) $xml->{'site-standard-profile-request'}->url;
        $linkedin_id = (string) $xml->{'id'};
        $picture_url = (string) $xml->{'picture-url'};
        $location = array('name' => (string) $xml->{'location'}->{'name'}, 'country_code' => (string) $xml->{'location'}->{'country'}->{'code'});
        $industry = (string) $xml->{'industry'};
        $headline = (string) $xml->{'headline'};
        $specialties = (string) $xml->{'specialties'};
        
        $total_positions = (int) $xml->positions->attributes()->total;
        
        switch ($total_positions) {
            case 1:
                $user_positions[] = array('title' => (string) $xml->positions->position->{'title'}, 'summary' => (string) $xml->positions->position->{'summary'});
                break;
            case $total_positions > 1:
                foreach ($xml->positions->position as $position) {
                    $user_positions[] = array('title' => (string) $position->{'title'}, 'summary' => (string) $position->{'summary'});
                }
                break;
            default:
                $user_positions = array();
                break;
        }
        if (!$user_id) {
            $user_id = get_current_user_id();
        }
       
        $result = wp_update_user(array('ID' => $user_id, 'first_name' => $first_name, 'last_name' => $last_name, 'description' => $description, 'user_url' => $linkedin_url));
       
        update_user_meta($user_id, 'LILI_linkedin_id', $linkedin_id);
        
        update_user_meta($user_id, 'LILI_linkedin_profile', array('first' => $first_name, 'last' => $last_name, 'description' => $description, 'linkedin_url' => $linkedin_url, 'linkedin_id' => $linkedin_id, 'profile_picture' => $picture_url, 'location' => $location, 'industry' => $industry, 'headline' => $headline, 'specialties' => $specialties, 'positions' => $user_positions));
        return $result;
    }
}