(function ($) {
    var $body, $window, $sidebar, top = false,
        bottom = false,
        windowHeight, lastWindowPos = 0,
        topOffset = 0,
        bodyHeight, sidebarHeight;

    function scroll() {
        var windowPos = $window.scrollTop();
        sidebarHeight = $sidebar.outerHeight();
        windowHeight = $window.height();
        bodyHeight = $body.height();
        if (sidebarHeight > windowHeight) {
            if (windowPos > lastWindowPos) {
                if (top) {
                    top = false;
                    topOffset = ($sidebar.offset().top > 0) ? $sidebar.offset().top : 0;
                    $sidebar.attr('style', 'top: ' + topOffset + 'px;');
                } else if (!bottom && windowPos + windowHeight > sidebarHeight + $sidebar.offset().top && sidebarHeight < bodyHeight) {
                    bottom = true;
                    $sidebar.attr('style', 'position: fixed; bottom: 0;');
                }
            } else if (windowPos < lastWindowPos) {
                if (bottom) {
                    bottom = false;
                    topOffset = ($sidebar.offset().top > 0) ? $sidebar.offset().top : 0;
                    $sidebar.attr('style', 'top: ' + topOffset + 'px;');
                } else if (!top && windowPos < $sidebar.offset().top) {
                    top = true;
                    $sidebar.attr('style', 'position: fixed;');
                }
            } else {
                top = bottom = false;
                topOffset = ($sidebar.offset().top > 0) ? $sidebar.offset().top : 0;
                $sidebar.attr('style', 'top: ' + topOffset + 'px;');
            }
        } else if (!top) {
            top = true;
            $sidebar.attr('style', 'position: fixed;');
        }
        lastWindowPos = windowPos;
    }

    $(function () {
        $body = $(document.body);
        $window = $(window);
        $sidebar = $('aside'); // 作用对象
        $window.on('scroll', scroll);
        scroll();
        for (var i = 1; i < 6; i++) {
            setTimeout(scroll, 100 * i);
        }
    });
})(jQuery);