function contactFormDate() {
	if ($('.birthday').length != 0) {
		$cur_year = new Date().getFullYear();
		$max_old_year = $cur_year - 100; // 设定最小为一百年前。
		$max_available_year = $cur_year - 16; // 设定最大为16年前，若为0即为当前年份。

		/* 填充年份下拉菜单 */
		var $birthyears = '<option value="">--</option>';
		for (var i = $max_old_year; i <= $max_available_year; i++) {
			$birthyears = $birthyears + '<option value="' + i + '">' + i + '</option>';
		}
		$('#birthyearmenu').html($birthyears);

		/* 填充月份下拉菜单 */
		var $birthmonthes = '<option value="">--</option>';
		for (var i = 1; i <= 12; i++) {
			$birthmonthes = $birthmonthes + '<option value="' + i + '">' + i + '</option>';
		}
		$('#birthmonthmenu').html($birthmonthes);

		/* 填充日下拉菜单设定默认31天 */
		var $birthdays = '<option value="">--</option>';
		for (var i = 1; i <= 31; i++) {
			$birthdays = $birthdays + '<option value="' + i + '">' + i + '</option>';
		}
		$('#birthdaymenu').html($birthdays);

		/* 以下开始判断每个月具体的日数 */

		/* 设定每月默认天数 */
		var month_maxday = new Array();
		month_maxday[1] = 31;
		month_maxday[2] = 28;
		month_maxday[3] = 31;
		month_maxday[4] = 30;
		month_maxday[5] = 31;
		month_maxday[6] = 30;
		month_maxday[7] = 31;
		month_maxday[8] = 31;
		month_maxday[9] = 30;
		month_maxday[10] = 31;
		month_maxday[11] = 30;
		month_maxday[12] = 31;

		/* 判断你是否是闰年 */
		function isLeapYear(year) {
			var a = false;
			if (0 == year % 4 && (year % 100 != 0 || year % 400 == 0)) {
				a = true;
			}
			return a;
		}

		/* 计算2月份具体日数 */
		function getMonthCount(year, month) {
			var c = month_maxday[month];
			if (month == 2 && isLeapYear(year)) {
				c++;
			}
			var $birthdays = '<option value="">--</option>';
			for (var i = 1; i <= c; i++) {
				$birthdays = $birthdays + '<option value="' + i + '">' + i + '</option>';
			}
			$('#birthdaymenu').html($birthdays);
		}

		/* 当年/月发生改变时重新设定2月份的天数 */
		$('#birthyearmenu,#birthmonthmenu').on('change', function() {
			$year = $('#birthyearmenu').val();
			$month = $('#birthmonthmenu').val();
			getMonthCount($year, $month);
		});
	}
}

$(function() {
	/* 触发函数 */
	contactFormDate();

	/* 表单提交时触发 */
	$('#smartdate').on('submit', function(e) {
		e.preventDefault();
		var y = $('#birthyearmenu').val(),
			m = $('#birthmonthmenu').val(),
			d = $('#birthdaymenu').val();
		alert('提交的日期为：' + y + '年' + m + '月' + d + '日');
	});
});
